<div id="editAdvancedPaymentModal" class="modal fade" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h2><?php echo e(__('messages.advanced_payment.edit_advanced_payment')); ?></h2>
                <button type="button" aria-label="Close" class="btn btn-sm btn-icon btn-active-color-primary"
                    data-bs-dismiss="modal">
                    <span class="svg-icon svg-icon-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" viewBox="0 0 24 24"
                            version="1.1">
                            <g transform="translate(12.000000, 12.000000) rotate(-45.000000) translate(-12.000000, -12.000000) translate(4.000000, 4.000000)"
                                fill="#000000">
                                <rect fill="#000000" x="0" y="7" width="16" height="2"
                                    rx="1" />
                                <rect fill="#000000" opacity="0.5"
                                    transform="translate(8.000000, 8.000000) rotate(-270.000000) translate(-8.000000, -8.000000)"
                                    x="0" y="7" width="16" height="2" rx="1" />
                            </g>
                        </svg>
                    </span>
                </button>
            </div>
            <?php echo e(Form::open(['id' => 'editAdvancedPaymentForm'])); ?>

            <div class="modal-body">
                <div class="alert alert-danger d-none hide" id="editPatientPaymentErrorsBox"></div>
                <?php echo e(Form::hidden('advanced_payment_id', null, ['id' => 'patientAdvancePaymentId'])); ?>

                <div class="row">
                    <div class="form-group col-sm-12 mb-5">
                        <?php echo e(Form::label('patient_id', __('messages.advanced_payment.patient') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::select('patient_id', $patients ?? [], null, ['class' => 'form-select', 'id' => 'editPatientPaymentId', 'placeholder' => __('messages.document.select_patient'), 'required', 'data-control' => 'select2'])); ?>

                    </div>
                    <div class="form-group col-sm-12 mb-5">
                        <?php echo e(Form::label('receipt_no', __('messages.advanced_payment.receipt_no') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::text('receipt_no', null, ['class' => 'form-control ', 'id' => 'editPatientPaymentReceiptNo', 'required', 'readonly'])); ?>

                    </div>
                    <div class="form-group col-sm-12 mb-5">
                        <?php echo e(Form::label('amount', __('messages.advanced_payment.amount') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::text('amount', null, ['class' => 'form-control price-input ', 'id' => 'editPatientPaymentAmount', 'required', 'onkeyup' => 'if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,"")', 'maxlength' => '7'])); ?>

                    </div>
                    <div class="form-group col-sm-12 mb-5">
                        <?php echo e(Form::label('date', __('messages.advanced_payment.date') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::text('date', null, ['class' => 'form-control ', 'id' => 'editPatientPaymentDate', 'required', 'autocomplete' => 'off'])); ?>

                    </div>
                </div>
                <div class="text-right">
                    <?php echo e(Form::button(__('messages.common.save'), ['type' => 'submit', 'class' => 'btn btn-primary me-2', 'id' => 'editPatientPaymentSave', 'data-loading-text' => "<span class='spinner-border spinner-border-sm'></span> Processing..."])); ?>

                    <button type="button" class="btn btn-light btn-active-light-primary me-2"
                        data-bs-dismiss="modal"><?php echo e(__('messages.common.cancel')); ?></button>
                </div>
            </div>
            <?php echo e(Form::close()); ?>

        </div>
    </div>
</div>
<?php /**PATH /home/iankim/public_html/resources/views/patients/advanced_payments/edit_modal.blade.php ENDPATH**/ ?>