<div class="row gx-10 mb-5">
    <div class="alert alert-danger d-none hide" id="scheduleErrorsBox"></div>
    <?php if(Auth::user()->hasRole('Doctor')): ?>
        <input type="hidden" name="doctor_id" value="<?php echo e(Auth::user()->owner_id); ?>">
    <?php else: ?>
        <div class="form-group col-sm-8 mb-5">
            <?php echo e(Form::label('doctor_name', __('messages.case.doctor').':', ['class' => 'form-label'])); ?>

            <span class="required"></span>
            <?php echo e(Form::select('doctor_id',$data['doctors'], null, ['class' => 'form-select','required','id' => 'doctorId','placeholder' => __('messages.schedule.select_doctor_name'),'data-control' => 'select2'])); ?>

        </div>
    <?php endif; ?>
    <?php if(Auth::user()->hasRole('Doctor')): ?>
        <div class="form-group col-sm-12 mb-5">
            <?php echo e(Form::label('per_patient_time', __('messages.schedule.per_patient_time').':', ['class' => 'form-label'])); ?>

            <span class="required"></span>
            <?php echo e(Form::text('per_patient_time', null, ['id'=>'perPatientTime', 'class' => 'form-control perPatientTime'.(getLoggedInUser()->thememode ? ' bg-light' : ' bg-white'), 'required','autocomplete' => 'off','placeholder' => __('messages.schedule.per_patient_time')])); ?>

        </div>
    <?php else: ?>
        <div class="form-group col-sm-4 mb-5">
            <?php echo e(Form::label('per_patient_time', __('messages.schedule.per_patient_time').':', ['class' => 'form-label'])); ?>

            <span class="required"></span>
            <?php echo e(Form::text('per_patient_time', null, ['id'=>'perPatientTime', 'class' => 'form-control perPatientTime'.(getLoggedInUser()->thememode ? ' bg-light' : ' bg-white'), 'required','placeholder'=>__('messages.schedule.per_patient_time')])); ?>

        </div>
    <?php endif; ?>

    <div class="col-lg-12 col-md-12 col-sm-12 schedulesCon table-responsive">
        <table
            class="schedules-table schedules-table-bordered table table-striped">
            <thead class="schedules-table-theme text-start text-muted fw-bolder fs-7 text-uppercase gs-0">
            <th><?php echo e(__('messages.schedule.available_on').':'); ?> <span class="required"></span></th>
            <th><?php echo e(__('messages.schedule.available_from').':'); ?> <span class="required"></span></th>
            <th><?php echo e(__('messages.schedule.available_to').':'); ?> <span class="required"></span></th>
            <th class="text-center"><?php echo e(__('messages.common.action')); ?></th>
            </thead>
            <tbody class="schedule-container text-gray-600 fw-bold">
            <?php $__currentLoopData = $data['availableOn']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $days): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="schedules-table-td">
                        <?php echo e(Form::text('available_on_day[]', isset($scheduleDays)?__('messages.schedule_weekday.'.$scheduleDays[$loop->iteration-1]->available_on):__('messages.schedule_weekday.'.$days),
            ['class' => 'form-control availableOn','required','id' => 'availableOn-'.($loop->iteration-1),'readonly'])); ?>

                        <?php echo e(Form::hidden('available_on[]',isset($scheduleDays)?$scheduleDays[$loop->iteration-1]->available_on:$days)); ?>

                    </td>
                    <td class="schedules-table-td position-relative">
                        <?php echo e(Form::text('available_from[]', isset($scheduleDays)?$scheduleDays[$loop->iteration-1]->available_from:"00:00:00",['id'=>'availableFrom-'.($loop->iteration-1), 'class' => 'form-control availableFrom hospitalScheduleFrom-'.$loop->iteration.(getLoggedInUser()->thememode ? ' bg-light' : ' bg-white'), 'required','autocomplete' => 'off'])); ?>

                    </td>
                    <td class="schedules-table-td position-relative">
                        <?php echo e(Form::text('available_to[]', isset($scheduleDays)?$scheduleDays[$loop->iteration-1]->available_to:"00:00:00",
            ['id'=>'availableTo-'.($loop->iteration-1), 'class' => 'form-control availableTo hospitalScheduleTo-'.$loop->iteration.(getLoggedInUser()->thememode ? ' bg-light' : ' bg-white'), 'required','autocomplete' => 'off'])); ?>

                    </td>
                    <td class="text-center schedules-table-td">
                        
                        <a title="copy-previous"
                           class="btn action-btn btn-primary btn-sm copy-btn cpy-btn<?php echo e($loop->iteration-1); ?>" href="javascript:void(0)"
                           data-id="<?php echo e($loop->iteration-1); ?>">
                            <i class="fa fa-copy action-icon"></i>
                        </a>
                        
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<div class="d-flex justify-content-end">
    <?php echo Form::submit(__('messages.common.save'), ['class' => 'btn btn-primary me-2','id' => 'scheduleSave']); ?>

</div>
<?php /**PATH /home/iankim/public_html/resources/views/schedules/fields.blade.php ENDPATH**/ ?>