<div class="row">
    <!-- Patient Id Field -->
    <div class="form-group mb-5 col-sm-6">
        <?php echo e(Form::label('patient_id', __('messages.patient_admission.patient') . ':', ['class' => 'form-label'])); ?>

        <span class="required"></span>
        <?php echo e(Form::select('patient_id', $data['patients'], null, ['class' => 'form-select select2Selector', 'id' => 'admissionPatientId', 'placeholder' => __('messages.document.select_patient'), 'data-control' => 'select2', 'required', isset($patientAdmission->patient_admission_id) ? 'disabled' : ''])); ?>

        <?php if(isset($patientAdmission->patient_admission_id)): ?>
            <?php echo e(Form::hidden('patient_id', $patientAdmission->patient_admission_id)); ?>

        <?php endif; ?>
    </div>

    <!-- Doctor Id Field -->
    <?php if(Auth::user()->hasRole('Doctor')): ?>
        <input type="hidden" name="doctor_id" value="<?php echo e(Auth::user()->owner_id); ?>">
    <?php else: ?>
        <div class="form-group mb-5 col-sm-6">
            <?php echo e(Form::label('doctor_id', __('messages.patient_admission.doctor') . ':', ['class' => 'form-label'])); ?>

            <span class="required"></span>
            <?php echo e(Form::select('doctor_id', $data['doctors'], null, ['class' => 'form-select select2Selector', 'id' => 'admissionDoctorId', 'placeholder' => __('messages.web_home.select_doctor'), 'data-control' => 'select2', 'required'])); ?>

        </div>
    <?php endif; ?>

    <!-- Admission Date Field -->
    <div class="form-group mb-5 col-sm-6">
        <input type="hidden" id="admissionPatientBirthDate"
            value="<?php echo e(isset($data['patientAdmissionDate']->patient->user) ? $data['patientAdmissionDate']->patient->user->dob : ''); ?>">
        <?php echo e(Form::label('admission_date', __('messages.patient_admission.admission_date') . ':', ['class' => 'form-label'])); ?>

        <span class="required"></span>
        <?php echo e(Form::text('admission_date', null, ['class' => (getLoggedInUser()->thememode ? 'bg-light form-control' : 'bg-white form-control'),'id' => 'admissionDate','required','autocomplete' => 'off','placeholder'=>__('messages.patient_admission.admission_date')])); ?>

    </div>

    <?php if(isset($patientAdmission)): ?>
        <!-- Discharge Date Field -->
        <div class="form-group mb-5 col-sm-6 date-container">
            <?php echo e(Form::label('discharge_date', __('messages.patient_admission.discharge_date') . ':', ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('discharge_date', null, ['placeholder' => __('messages.patient_admission.discharge_date'),'class' => 'form-control bg-white', 'id' => 'admissionDischargeDate', 'autocomplete' => 'off'])); ?>

        </div>
    <?php endif; ?>

    <!-- Package Id Field -->
    <div class="form-group mb-5 col-sm-6">
        <?php echo e(Form::label('package_id', __('messages.patient_admission.package') . ':', ['class' => 'form-label'])); ?>

        <?php echo e(Form::select('package_id', $data['packages'], null, ['class' => 'form-select select2Selector', 'id' => 'admissionPackageId', 'placeholder' => __('messages.common.choose') . ' ' . __('messages.package.package'), 'data-control' => 'select2'])); ?>

    </div>

    <!-- Insurance Id Field -->
    <div class="form-group mb-5 col-sm-6">
        <?php echo e(Form::label('insurance_id', __('messages.patient_admission.insurance') . ':', ['class' => 'form-label'])); ?>

        <?php echo e(Form::select('insurance_id', $data['insurances'], null, ['class' => 'form-select select2Selector', 'id' => 'admissionInsuranceId', 'placeholder' => __('messages.common.choose') . ' ' . __('messages.patient_admission.insurance'), 'data-control' => 'select2'])); ?>

    </div>

    <!-- Bed Id Field -->
    <div class="form-group mb-5 col-sm-6">
        <?php echo e(Form::label('bed_id', __('messages.patient_admission.bed') . ':', ['class' => 'form-label'])); ?>

        <?php echo e(Form::select('bed_id', $data['beds'], null, ['class' => 'form-select select2Selector', 'id' => 'admissionBedId', 'placeholder' => __('messages.common.choose') . ' ' . __('messages.bed_assign.bed'), 'data-control' => 'select2'])); ?>

    </div>

    <!-- Policy No Field -->
    <div class="form-group mb-5 col-sm-6">
        <?php echo e(Form::label('policy_no', __('messages.patient_admission.policy_no').':', ['class' => 'form-label'])); ?>

        <?php echo e(Form::text('policy_no', null, ['class' => 'form-control','placeholder'=>__('messages.patient_admission.policy_no')])); ?>

    </div>

    <!-- Agent Name Field -->
    <div class="form-group mb-5 col-sm-6">
        <?php echo e(Form::label('agent_name', __('messages.patient_admission.agent_name').':', ['class' => 'form-label'])); ?>

        <?php echo e(Form::text('agent_name', null, ['class' => 'form-control','placeholder'=>__('messages.patient_admission.agent_name')])); ?>

    </div>

    <!-- Guardian Name Field -->
    <div class="form-group mb-5 col-sm-6">
        <?php echo e(Form::label('guardian_name', __('messages.patient_admission.guardian_name').':', ['class' => 'form-label'])); ?>

        <?php echo e(Form::text('guardian_name', null, ['class' => 'form-control','placeholder'=>__('messages.patient_admission.guardian_name')])); ?>

    </div>

    <!-- Guardian Relation Field -->
    <div class="form-group mb-5 col-sm-6">
        <?php echo e(Form::label('guardian_relation', __('messages.patient_admission.guardian_relation').':', ['class' => 'form-label'])); ?>

        <?php echo e(Form::text('guardian_relation', null, ['class' => 'form-control','placeholder'=>__('messages.patient_admission.guardian_relation')])); ?>

    </div>

    <!-- Guardian Contact Field -->
    <div class="form-group mb-5 col-sm-6 mb-5">
        <?php echo e(Form::label('guardian_contact', __('messages.patient_admission.guardian_contact') . ':', ['class' => 'form-label'])); ?>

        <br>
        <?php echo e(Form::text('guardian_contact', $patientAdmission->guardian_contact ?? getCountryCode(), ['class' => 'form-control phoneNumber', 'id' => 'admissionPhoneNumber', 'onkeyup' => 'if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,"")'])); ?>

        <?php echo e(Form::hidden('prefix_code', null, ['class' => 'prefix_code'])); ?>

        <?php echo e(Form::hidden('country_iso', null, ['class' => 'country_iso'])); ?>

        <span class="text-success valid-msg d-none fw-400 fs-small mt-2">✓ &nbsp; <?php echo e(__('messages.valid')); ?></span>
        <span class="text-danger error-msg d-none fw-400 fs-small mt-2"></span>
    </div>

    <!-- Guardian Address Field -->
    <div class="form-group mb-5 col-sm-6">
        <?php echo e(Form::label('guardian_address', __('messages.patient_admission.guardian_address').':', ['class' => 'form-label'])); ?>

        <?php echo e(Form::text('guardian_address', null, ['class' => 'form-control','placeholder'=>__('messages.patient_admission.guardian_address')])); ?>

    </div>

    <!-- Status Field -->
    <div class="col-md-3">
        <div class="form-group mb-5">
            <?php echo e(Form::label('status', __('messages.common.status') . ':', ['class' => 'form-label'])); ?>

            <br>
            <div class="form-check form-switch fv-row">
                <input name="status" class="form-check-input w-35px h-20px is-active" value="1" type="checkbox"
                    <?php echo e(isset($patientAdmission) && $patientAdmission->status ? 'checked' : ''); ?>

                    <?php echo e(!isset($patientAdmission) ? 'checked' : ''); ?>>
            </div>
        </div>
    </div>

    <!-- Submit Field -->
    <div class="d-flex justify-content-end">
        <?php echo e(Form::submit(__('messages.common.save'), ['class' => 'btn btn-primary me-2', 'id' => 'admissionSaveBtn'])); ?>

        <a href="<?php echo e(route('patient-admissions.index')); ?>"
            class="btn btn-secondary me-2"><?php echo e(__('messages.common.cancel')); ?></a>
    </div>
</div>
<?php /**PATH /home/iankim/public_html/resources/views/patient_admissions/fields.blade.php ENDPATH**/ ?>