<div id="edit_blood_issues_modal" class="modal fade" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title" id="exampleModalLabel"><?php echo e(__('messages.blood_issue.edit_blood_issue')); ?></h3>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <?php echo e(Form::open(['id' => 'editBloodIssueForm'])); ?>

            <?php echo e(Form::hidden('currency_symbol', getCurrentCurrency(), ['class' => 'currencySymbol'])); ?>

            <div class="modal-body">
                <div class="alert alert-danger d-none hide" id="editBloodIssueErrorsBox"></div>
                <?php echo e(Form::hidden('blood_issue_id', null, ['id' => 'bloodIssueId'])); ?>

                <div class="row">
                    <div class="form-group col-sm-6 mb-5">
                        <?php echo e(Form::label('issue_date', __('messages.blood_issue.issue_date') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::text('issue_date', '', ['id' => 'editBloodIssueDate', 'class' => getLoggedInUser()->thememode ? 'bg-light form-control' : 'bg-white form-control', 'required', 'placeholder' => __('messages.blood_issue.issue_date')])); ?>

                    </div>
                    <div class="form-group col-sm-6 mb-5">
                        <?php echo e(Form::label('doctor_id', __('messages.blood_issue.doctor_name') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::select('doctor_id', $doctors, null, ['class' => 'form-select', 'required', 'id' => 'editBloodIssueDoctorName', 'placeholder' => __('messages.schedule.select_doctor_name'), 'data-control' => 'select2', 'required'])); ?>

                    </div>
                    <div class="form-group col-sm-6 mb-5">
                        <?php echo e(Form::label('patient_id', __('messages.blood_issue.patient_name') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::select('patient_id', $patients, null, ['class' => 'form-select', 'required', 'id' => 'editBloodIssuePatientName', 'placeholder' =>  __('messages.document.select_patient'), 'data-control' => 'select2', 'required'])); ?>

                    </div>
                    <div class="form-group col-sm-6 mb-5">
                        <?php echo e(Form::label('donor_id', __('messages.blood_issue.donor_name') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::select('donor_id', $donors, null, ['class' => 'form-select', 'required', 'id' => 'editDonorName', 'placeholder' => __('messages.common.choose') . ' ' . __('messages.blood_donation.donor_name'), 'data-control' => 'select2', 'required'])); ?>

                    </div>
                    <div class="form-group col-sm-6 mb-5">
                        <?php echo e(Form::label('blood_group', __('messages.user.blood_group') . ':', ['class' => 'form-label'])); ?>

                        <?php echo e(Form::select('blood_group', [], null, ['class' => 'form-select', 'required', 'id' => 'editIssuedBloodGroup', 'placeholder' => __('messages.user.select_blood_group'), 'data-control' => 'select2', 'disabled'])); ?>

                    </div>
                    <div class="form-group col-sm-6 mb-5">
                        <?php echo e(Form::label('amount', __('messages.blood_issue.amount') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::text('amount', '', ['id' => 'editBloodIssueAmount', 'class' => 'form-control price-input price', 'required', 'maxlength' => '9', 'placeholder' => __('messages.blood_issue.amount')])); ?>

                    </div>
                    <div class="form-group col-sm-6">
                        <?php echo e(Form::label('remarks', __('messages.blood_issue.remarks') . ':', ['class' => 'form-label'])); ?>

                        <?php echo e(Form::textarea('remarks', '', ['id' => 'editBloodIssueRemarks', 'class' => 'form-control', 'rows' => 3, 'cols' => 3, 'placeholder' => __('messages.blood_issue.remarks') ])); ?>

                    </div>
                </div>
            </div>
            <div class="modal-footer pt-0">
                <?php echo e(Form::button(__('messages.common.save'), ['type' => 'submit', 'class' => 'btn btn-primary m-0', 'id' => 'editBloodIssueSave', 'data-loading-text' => "<span class='spinner-border spinner-border-sm'></span> Processing..."])); ?>

                <button type="button" class="btn btn-secondary"
                    data-bs-dismiss="modal"><?php echo e(__('messages.common.cancel')); ?></button>
            </div>
            <?php echo e(Form::close()); ?>

        </div>
    </div>
</div>
<?php /**PATH /home/iankim/public_html/resources/views/blood_issues/edit_modal.blade.php ENDPATH**/ ?>