<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="title" content="<?php echo e(config('app.name')); ?>">

    <meta name="keywords" content="<?php echo e(getCompanyName()); ?>"/>

    <meta name="description" content="<?php echo e(getAppName()); ?>"/>
    <meta name="author" content="<?php echo e(getCompanyName()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>404 Not Found | <?php echo e(config('app.name')); ?></title>
    <link rel="stylesheet" href="<?php echo e(mix('web_front/css/bootstrap.css')); ?>">
    <?php echo $__env->yieldContent('page_css'); ?>
</head>
<body>
    <div class="container con-404 vh-100 d-flex justify-content-center">
        <div class="row justify-content-md-center d-block">
            <div class="col-md-12 mt-5">
                <img src="<?php echo e(asset('web/img/404.svg')); ?>" class="img-fluid img-404 mx-auto d-block">
            </div>
            <div class="col-md-12 text-center error-page-404">
                <h2>Opps! Something's missing...</h2>
                <p class="not-found-subtitle">The page you are looking for doesn't exists / isn't available / was loading
                    incorrectly.</p>
                <a class="btn btn-success back-btn mt-3" href="<?php echo e(url()->previous()); ?>" data-turbo="false">Back to Previous Page</a>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/iankim/public_html/resources/views/errors/404.blade.php ENDPATH**/ ?>