<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages.doctor.doctor_details')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page_css'); ?>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- start hero section -->
    <section
        class="hero-section position-relative p-t-60 border-bottom-right-rounded border-bottom-left-rounded bg-gray overflow-hidden">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 text-lg-start text-center">
                    <div class="hero-content">
                        <h1 class="mb-3 pb-1">
                            <?php echo e(__('messages.doctor.doctor_details')); ?>

                        </h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb justify-content-lg-start justify-content-center mb-lg-0 mb-5">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(url('/')); ?>"><?php echo e(__('messages.web_home.home')); ?></a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    <?php echo e(__('messages.doctor.doctor_details')); ?>

                                </li>
                            </ol>
                        </nav>
                    </div>
                </div>
                <div class="col-lg-6 text-lg-end text-center">
                    <img src="<?php echo e(asset('web_front/images/page-banner/Doctors.png')); ?>" alt="Infy Care" class="img-fluid" />
                </div>
            </div>
        </div>
    </section>
    <!-- end hero section -->

    
    <section class="container p-sm-5 p-3">
        <div class="card mb-3 p-lg-5 p-md-4 p-3">
            <div class="row justify-content-center m-0">
                <div class="col-md-3">
                    <img src="<?php echo e($doctorDetails->doctorUser->image_url); ?>" style="height:250px" class="img-fluid rounded"
                        alt="Doctor Details">
                </div>
                <div class="col-md-9">
                    <div class="card-body">
                        <div class="row">
                            <div>
                                <h4><?php echo e($doctorDetails->doctorUser->fullname); ?></h4>
                                <h5><?php echo e(__('messages.user.email')); ?></h5>
                                <p>
                                    <i class="fa-solid fa-envelope text-success px-2"></i>
                                    <?php echo e($doctorDetails->doctorUser->email); ?>

                                </p>
                                <h5> <?php echo e(__('messages.user.qualification')); ?></h5>
                                <p>
                                    <?php if(!empty($doctorDetails->doctorUser->qualification)): ?>
                                        <i class="fa-solid fa-graduation-cap text-success px-2"></i>
                                        <?php echo e($doctorDetails->doctorUser->qualification); ?>

                                    <?php else: ?>
                                        <?php echo e(__('messages.common.n/a')); ?>

                                    <?php endif; ?>
                                </p>
                                <h5><?php echo e(__('messages.doctor.specialist')); ?></h5>
                                <p>
                                    <i class="fas fa-user-md text-success px-2"></i>
                                    <?php echo e($doctorDetails->specialist); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row text-center container bg-white shadow-lg rounded mt-sm-5 mt-4 ">
                    <nav class="pt-lg-5 pt-4  ">
                        <ul class="nav nav-pills mb-1 border-0 flex-nowrap overflow-auto">
                            <?php if(!empty($doctorDetails->description)): ?>
                                <li class="nav-item text-nowrap mb-2">
                                    <a class="nav-link active" data-bs-toggle="tab" data-bs-target="#overview"
                                        type="button"><?php echo e(__('messages.about_us')); ?></a>
                                </li>
                            <?php endif; ?>
                            <li class="nav-item text-nowrap mb-2">
                                <a class="nav-link <?php echo e(empty($doctorDetails->description) ? 'active' : ''); ?>"
                                    data-bs-toggle="tab" data-bs-target="#schedule"
                                    type="button"><?php echo e(__('messages.schedules')); ?></a>
                            </li>
                        </ul>
                    </nav>
                    <div class="tab-content text-start p-3">
                        <div class="tab-pane fade active show" id="overview" role="tabpanel">
                            <div class="row">
                                <?php if(!empty($doctorDetails->description)): ?>
                                    <div class="col-md-12">
                                        <h5><?php echo e(__('messages.common.description')); ?></h5>
                                        <p class="fw-normal pb-3 text-break"><?php echo e($doctorDetails->description); ?></p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="tab-pane fade overflow-auto <?php echo e(empty($doctorDetails->description) ? 'active show' : ''); ?>"
                            id="schedule" role="tabpanel">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('messages.schedule.available_on')); ?></th>
                                        <th><?php echo e(__('messages.schedule.available_from')); ?></th>
                                        <th><?php echo e(__('messages.schedule.available_to')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $doctorSchedule; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(__('messages.schedule_weekday.'.$schedule->available_on)); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($schedule->available_from)->format('h:i A')); ?>

                                            </td>
                                            <td><?php echo e(\Carbon\Carbon::parse($schedule->available_to)->format('h:i A')); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('web.layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iankim/public_html/resources/views/web/home/doctor-details.blade.php ENDPATH**/ ?>