<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages.appointments')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('page_css'); ?>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php
        $settingValue = getSettingValue();
    ?>

    <div class="appointment-page">
        <!-- start hero section -->
        <section
            class="hero-section position-relative p-t-60 border-bottom-right-rounded border-bottom-left-rounded bg-gray overflow-hidden">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 text-lg-start text-center">
                        <div class="hero-content">
                            <h1 class="mb-3 pb-1">
                                <?php echo e(__('messages.web_home.make_appointment')); ?>

                            </h1>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb justify-content-lg-start justify-content-center mb-lg-0 mb-5">
                                    <li class="breadcrumb-item">
                                        <a href="<?php echo e(route('front')); ?>"><?php echo e(__('messages.web_home.home')); ?></a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        <?php echo e(__('messages.web_home.make_appointment')); ?>

                                    </li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                    <div class="col-lg-6 text-lg-end text-center">
                        <img src="<?php echo e(asset('web_front/images/page-banner/make-appointment.png')); ?>" alt="Infy Care"
                            class="img-fluid" />
                    </div>
                </div>
            </div>
        </section>
        <!-- end hero section -->

        <section class="appointment-section p-t-120 position-relative">
            <div class="container">
                <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="alert alert-danger" id="validationErrorsBox" style="display: none"></div>
                
                <?php echo e(Form::open(['id' => 'webAppointmentFormSubmit', 'class' => 'appointment-form'])); ?>

                <?php echo csrf_field(); ?>
                <?php echo $__env->make('web.home.appointment_fields', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php echo e(Form::close()); ?>

            </div>
        </section>
        <!-- end appointment-form section -->

        <!-- start contact section -->
        <section class="contact-details-section p-t-120 p-b-120">
            <div class="container">
                <div class="row mt-xl-5">
                    <div class="col-lg-6">
                        <div class="text-lg-start text-center mb-lg-0 mb-5">
                            <h2 class="mb-3">
                                <?php echo e(getFrontSettingValue(\App\Models\FrontSetting::APPOINTMENT, 'appointment_title')); ?></h2>
                            <p class="mb-0">
                                <?php echo getFrontSettingValue(\App\Models\FrontSetting::APPOINTMENT, 'appointment_description'); ?>

                            </p>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="row">
                            <div class="col-md-6 contact-details-block d-flex align-items-stretch">
                                <div class="card text-center mx-xl-2 flex-fill">
                                    <div class="icon-details-box d-flex align-items-center justify-content-center mx-auto">
                                        <i class="fa-solid fa-phone fs-3"></i>
                                    </div>
                                    <div class="card-body text-center d-flex flex-column pb-4">
                                        <a href="tel:<?php echo e($settingValue['hospital_phone']['value']); ?>"
                                            class="text-decoration-none fs-5 text-success my-2">
                                            <?php echo e($settingValue['hospital_phone']['value']); ?>

                                        </a>
                                        <span class="text-secondary fw-light">
                                            <?php echo e(__('messages.web_appointment.call_now_and_get_a_free_consulting')); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 contact-details-block d-flex align-items-stretch">
                                <div class="card text-center mx-xl-2 flex-fill">
                                    <div class="icon-details-box d-flex align-items-center justify-content-center mx-auto">
                                        <i class="fa-solid fa-envelope fs-3"></i>
                                    </div>
                                    <div class="card-body text-center d-flex flex-column pb-4">
                                        <a href="mailto:<?php echo e($settingValue['hospital_email']['value']); ?>"
                                            class="text-decoration-none fs-5 text-success my-2">
                                            <?php echo e($settingValue['hospital_email']['value']); ?>

                                        </a>
                                        <span class="text-secondary fw-light">Contact Hospital</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 text-center">
                    <div class="btn-group mt-4 mt-xl-5">
                        <?php if($settingValue['facebook_url']['value'] != '' && !empty($settingValue['facebook_url']['value'])): ?>
                            <a href="<?php echo e($settingValue['facebook_url']['value']); ?>" target="_blank"
                                class="btn btn-primary fs-4">
                                <i class="fa-brands fa-facebook"></i>
                            </a>
                        <?php endif; ?>
                        <?php if($settingValue['twitter_url']['value'] != '' && !empty($settingValue['twitter_url']['value'])): ?>
                            <a href="<?php echo e($settingValue['twitter_url']['value']); ?>" target="_blank"
                                class="btn btn-primary fs-4">
                                <i class="fa-brands fa-twitter"></i>
                            </a>
                        <?php endif; ?>
                        <?php if($settingValue['instagram_url']['value'] != '' && !empty($settingValue['instagram_url']['value'])): ?>
                            <a href="<?php echo e($settingValue['instagram_url']['value']); ?>" target="_blank"
                                class="btn btn-primary fs-4">
                                <i class="fa-brands fa-instagram"></i>
                            </a>
                        <?php endif; ?>
                        <?php if($settingValue['linkedIn_url']['value'] != '' && !empty($settingValue['linkedIn_url']['value'])): ?>
                            <a href="<?php echo e($settingValue['linkedIn_url']['value']); ?>" target="_blank"
                                class="btn btn-primary fs-4">
                                <i class="fa-brands fa-linkedin-in"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </section>
        <!-- end  contact section -->

        <?php echo $__env->make('appointments.templates.appointment_slot', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo e(Form::hidden('doctorDepartmentUrl', route('appointment.doctor.list'), ['id' => 'homeDoctorDepartmentUrl', 'class' => 'homeDoctorDepartmentUrl'])); ?>

        <?php echo e(Form::hidden('doctorUrl', route('appointment.doctors.list'), ['id' => 'homeDoctorUrl', 'class' => 'homeDoctorUrl'])); ?>

        <?php echo e(Form::hidden('webDoctorChargeUrl', url('web-doctors-appointment-charge'), ['class' => 'webDoctorChargeUrl'])); ?>

        <?php echo e(Form::hidden('appointmentSaveUrl', route('web.appointments.store'), ['id' => 'homeAppointmentSaveUrl', 'class' => 'homeAppointmentsSaveUrl'])); ?>

        <?php echo e(Form::hidden('webAppointmentRazorpay', route('web.appointment.razorpay.init'), ['id' => 'webAppointmentRazorpayInit', 'class' => 'webAppointmentRazorpayInit'])); ?>

        <?php echo e(Form::hidden('webAppointmentPaypal', route('web.appointment.paypal.init'), ['id' => 'webAppointmentPaypal', 'class' => 'webAppointmentPaypal'])); ?>

        <?php echo e(Form::hidden('doctorScheduleList', url('appointment-doctor-schedule-list'), ['id' => 'homeDoctorScheduleList', 'class' => 'homeDoctorScheduleList'])); ?>

        <?php echo e(Form::hidden('isEdit', false, ['id' => 'homeIsEdit', 'class' => 'isEdit'])); ?>

        <?php echo e(Form::hidden('isCreate', true, ['id' => 'homeIsCreate', 'class' => 'isCreate'])); ?>

        <?php echo e(Form::hidden('getBookingSlot', route('appointment.get.booking.slot'), ['id' => 'homeGetBookingSlot', 'class' => 'homeGetBookingSlot'])); ?>

        <?php echo e(Form::hidden('webAppointmentIndexPage', route('appointment'), ['class' => 'webAppointmentIndexPage'])); ?>

        <?php echo e(Form::hidden('backUrl', route('appointment'), ['class' => 'backUrl'])); ?>

    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page_scripts'); ?>
    
    
    <script src="<?php echo e(asset('backend/js/moment-round/moment-round.js')); ?>"></script>
    
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="https://js.stripe.com/v3/"></script>
    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <script>
        let options = {
            'key': "<?php echo e(getPaymentCredentials('razorpay_key')); ?>",
            'amount': 0,
            'currency': "<?php echo e(strtoupper(getCurrentCurrency())); ?>",
            'name': "<?php echo e(getAppName()); ?>",
            'order_id': '',
            'description': '',
            'image': "<?php echo e(asset(getLogoUrl())); ?>",
            'callback_url': "<?php echo e(route('web.appointment.razorpay.success')); ?>",
            'prefill': {
                'appointment_id': '',
                'amount': '',
                'payment_mode': '',
            },
            'theme': {
                'color': '#FF8E4B',
            },
            'modal': {
                'ondismiss': function() {
                    // livewire.emit("refresh");
                    $.ajax({
                        type: 'POST',
                        url: route('web.appointment.razorpay.failed'),
                        data: $("#appointmentForm").serialize(),
                        success: function(result) {
                            if (result.success) {
                                displayErrorMessage(result.message.message);
                                setTimeout(function() {
                                    window.location.href = result.message.url
                                }, 5000);
                            }
                        },
                        error: function(result) {
                            displayErrorMessage(result.responseJSON.message)
                        },
                    });
                },
            }
        }
        let stripe = '';
        <?php if(getPaymentCredentials('stripe_key')): ?>
            stripe = Stripe('<?php echo e(getPaymentCredentials('stripe_key')); ?>');
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('web.layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iankim/public_html/resources/views/web/home/appointment.blade.php ENDPATH**/ ?>