<div>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-xxl-5 col-12">
                    <div class="d-sm-flex align-items-center mb-5 mb-xxl-0 text-center text-sm-start">
                        <div class="image image-circle image-small">
                            <img src="<?php echo e(!empty($data->patientUser->image_url) ? $data->patientUser->image_url : ''); ?>"
                                alt="image" />
                        </div>
                        <div class="ms-0 ms-md-10 mt-5 mt-sm-0">
                            <h2><a href="javascript:void(0)"
                                    class="text-decoration-none"><?php echo e(!empty($data->patientUser->full_name) ? $data->patientUser->full_name : ''); ?></a>
                            </h2>

                            <a href="mailto:<?php echo e(!empty($data->patientUser->email) ? $data->patientUser->email : ''); ?>"
                                class="text-gray-600 text-decoration-none fs-5">
                                <?php echo e(!empty($data->patientUser->email) ? $data->patientUser->email : ''); ?>

                            </a>
                            <span class="d-flex align-items-center me-2 mb-2 mt-2">
                                <?php if(
                                    !empty($data->address->address1) ||
                                        !empty($data->address->address2) ||
                                        !empty($data->address->city) ||
                                        !empty($data->address->zip)): ?>
                                    <span><i class="fas fa-location"></i></span>
                                <?php endif; ?>
                                <span class="p-2">
                                    <?php echo e(!empty($data->address->address1) ? $data->address->address1 : ''); ?><?php echo e(!empty($data->address->address2) ? (!empty($data->address->address1) ? ',' : '') : ''); ?>

                                    <?php echo e(empty($data->address->address1) || !empty($data->address->address2) ? (!empty($data->address->address2) ? $data->address->address2 : '') : ''); ?>

                                    <?php echo e(empty($data->address->address1) && empty($data->address->address2) ? '' : ''); ?><?php echo e(!empty($data->address->city) ? ',' . $data->address->city : ''); ?><?php echo e(!empty($data->address->zip) ? ',' . $data->address->zip : ''); ?>

                                </span>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-7 col-12">
                    <div class="row justify-content-center">
                        <div class="col-md-4 col-sm-6 col-12 mb-6 mb-md-0">
                            <div class="border rounded-10 p-5 h-100">
                                <h2 class="text-primary mb-3"><?php echo e(!empty($data->cases) ? $data->cases->count() : 0); ?>

                                </h2>
                                <h3 class="fs-5 fw-light text-gray-600 mb-0"><?php echo e(__('messages.patient.total_cases')); ?>

                                </h3>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-6 col-12 mb-6 mb-md-0">
                            <div class="border rounded-10 p-5 h-100">
                                <h2 class="text-primary mb-3">
                                    <?php echo e(!empty($data->admissions) ? $data->admissions->count() : 0); ?></h2>
                                <h3 class="fs-5 fw-light text-gray-600 mb-0">
                                    <?php echo e(__('messages.patient.total_admissions')); ?></h3>
                            </div>
                        </div>
                        <div class="col-md-4 col-sm-6 col-12 mb-6 mb-md-0">
                            <div class="border rounded-10 p-5 h-100">
                                <h2 class="text-primary mb-3">
                                    <?php echo e(!empty($data->appointments) ? $data->appointments->count() : 0); ?></h2>
                                <h3 class="fs-5 fw-light text-gray-600 mb-0">
                                    <?php echo e(__('messages.patient.total_appointments')); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="mt-7 overflow-hidden">
        <ul class="nav nav-tabs mb-5 pb-1 overflow-auto flex-nowrap text-nowrap">
            <li class="nav-item position-relative me-7 mb-3">
                <a class="nav-link active p-0" data-bs-toggle="tab"
                    href="#PatientOverview"><?php echo e(__('messages.overview')); ?></a>
            </li>
            <li class="nav-item position-relative me-7 mb-3">
                <a class="nav-link p-0" data-bs-toggle="tab" href="#showPatientCases"><?php echo e(__('messages.cases')); ?></a>
            </li>
            <li class="nav-item position-relative me-7 mb-3">
                <a class="nav-link p-0" data-bs-toggle="tab"
                    href="#showPatientAdmissions"><?php echo e(__('messages.patient_admissions')); ?></a>
            </li>
            <li class="nav-item position-relative me-7 mb-3">
                <a class="nav-link p-0" data-bs-toggle="tab"
                    href="#showPatientAppointments"><?php echo e(__('messages.appointments')); ?></a>
            </li>
            <li class="nav-item position-relative me-7 mb-3">
                <a class="nav-link p-0" data-bs-toggle="tab" href="#showPatientBills"><?php echo e(__('messages.bills')); ?></a>
            </li>
            <li class="nav-item position-relative me-7 mb-3">
                <a class="nav-link p-0" data-bs-toggle="tab"
                    href="#showPatientInvoices"><?php echo e(__('messages.invoices')); ?></a>
            </li>
            <li class="nav-item position-relative me-7 mb-3">
                <a class="nav-link p-0" data-bs-toggle="tab"
                    href="#showPatientAdvancedPayments"><?php echo e(__('messages.advanced_payments')); ?></a>
            </li>
            <li class="nav-item position-relative me-7 mb-3">
                <a class="nav-link p-0" data-bs-toggle="tab"
                    href="#showPatientDocument"><?php echo e(__('messages.documents')); ?></a>
            </li>
            <li class="nav-item position-relative me-7 mb-3">
                <a class="nav-link p-0" data-bs-toggle="tab"
                    href="#showPatientVaccinated"><?php echo e(__('messages.vaccinations')); ?></a>
            </li>
        </ul>
    </div>
</div>
<div class="tab-content" id="myPatientTabContent">
    <div class="tab-pane fade show active" id="PatientOverview" role="tabpanel">
        <div class="card mb-5 mb-xl-10">
            <div>
                <div class="card-body  border-top p-9">
                    <div class="row">
                        <div class="col-sm-6 d-flex flex-column mb-md-10 mb-5">
                            <label for="name"
                                class="pb-2 fs-5 text-gray-600"><?php echo e(__('messages.user.phone')); ?></label>
                            <p>
                                <span
                                    class="fs-5 text-gray-800"><?php echo e(!empty($data->patientUser->phone) ? $data->patientUser->phone : __('messages.common.n/a')); ?></span>
                            </p>
                        </div>
                        <div class="col-sm-6 d-flex flex-column mb-md-10 mb-5">
                            <label for="name"
                                class="pb-2 fs-5 text-gray-600"><?php echo e(__('messages.user.gender')); ?></label>
                            <p>
                                <span
                                    class="fs-5 text-gray-800"><?php echo e(!empty($data->patientUser->phone) ? ($data->patientUser->gender != 1 ? __('messages.user.male') : __('messages.user.female')) : ''); ?></span>
                            </p>
                        </div>
                        <div class="col-sm-6 d-flex flex-column mb-md-10 mb-5">
                            <label for="name"
                                class="pb-2 fs-5 text-gray-600"><?php echo e(__('messages.user.blood_group')); ?></label>
                            <p>
                                <?php if(!empty($data->patientUser->blood_group)): ?>
                                    <span
                                        class="badge fs-6 bg-light-<?php echo e(!empty($data->patientUser->blood_group) ? 'success' : 'danger'); ?>">
                                        <?php echo e($data->patientUser->blood_group); ?> </span>
                                <?php else: ?>
                                    <span class="fs-5 text-gray-800"><?php echo e(__('messages.common.n/a')); ?></span>
                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="col-sm-6 d-flex flex-column mb-md-10 mb-5">
                            <label for="name" class="pb-2 fs-5 text-gray-600"><?php echo e(__('messages.user.dob')); ?></label>
                            <p>
                                <span
                                    class="fs-5 text-gray-800"><?php echo e(!empty($data->patientUser->dob) ? \Carbon\Carbon::parse($data->patientUser->dob)->translatedFormat('jS M, Y') : __('messages.common.n/a')); ?></span>
                            </p>
                        </div>
                        <div class="col-sm-6 d-flex flex-column mb-md-10 mb-5">
                            <label for="name"
                                class="pb-2 fs-5 text-gray-600"><?php echo e(__('messages.common.created_at')); ?></label>
                            <p>
                                <span
                                    class="fs-5 text-gray-800"><?php echo e(!empty($data->patientUser->created_at) ? $data->patientUser->created_at->diffForHumans() : __('messages.common.n/a')); ?></span>
                            </p>
                        </div>
                        <div class="col-sm-6 d-flex flex-column mb-md-10 mb-5">
                            <label for="name"
                                class="pb-2 fs-5 text-gray-600"><?php echo e(__('messages.common.updated_at')); ?></label>
                            <p>
                                <span
                                    class="fs-5 text-gray-800"><?php echo e(!empty($data->patientUser->updated_at) ? $data->patientUser->updated_at->diffForHumans() : __('messages.common.n/a')); ?></span>
                            </p>
                        </div>
                        <div class="col-sm-6 d-flex flex-column mb-md-10 mb-5">
                            <label for="name"
                                class="pb-2 fs-5 text-gray-600"><?php echo e(__('messages.facebook_url')); ?></label>
                            <p>
                                <?php if(!empty($doctorData->doctorUser->facebook_url)): ?>
                                    <a href="<?php echo e($doctorData->doctorUser->facebook_url); ?>"
                                        class="fs-5 text-primary-800 text-decoration-none"><?php echo e($doctorData->doctorUser->facebook_url); ?></a>
                                <?php else: ?>
                                    <?php echo e(__('messages.common.n/a')); ?>

                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="col-sm-6 d-flex flex-column mb-md-10 mb-5">
                            <label for="name"
                                class="pb-2 fs-5 text-gray-600"><?php echo e(__('messages.twitter_url')); ?></label>
                            <p>
                                <?php if(!empty($doctorData->doctorUser->twitter_url)): ?>
                                    <a href="<?php echo e($doctorData->doctorUser->twitter_url); ?>"
                                        class="fs-5 text-primary-800 text-decoration-none"><?php echo e($doctorData->doctorUser->twitter_url); ?></a>
                                <?php else: ?>
                                    <?php echo e(__('messages.common.n/a')); ?>

                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="col-sm-6 d-flex flex-column mb-md-10 mb-5">
                            <label for="name"
                                class="pb-2 fs-5 text-gray-600"><?php echo e(__('messages.instagram_url')); ?></label>
                            <p>
                                <?php if(!empty($doctorData->doctorUser->instagram_url)): ?>
                                    <a href="<?php echo e($doctorData->doctorUser->instagram_url); ?>"
                                        class="fs-5 text-primary-800 text-decoration-none"><?php echo e($doctorData->doctorUser->instagram_url); ?></a>
                                <?php else: ?>
                                    <?php echo e(__('messages.common.n/a')); ?>

                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="col-sm-6 d-flex flex-column mb-md-10 mb-5">
                            <label for="name"
                                class="pb-2 fs-5 text-gray-600"><?php echo e(__('messages.linkedIn_url')); ?></label>
                            <p>
                                <?php if(!empty($doctorData->doctorUser->linkedIn_url)): ?>
                                    <a href="<?php echo e($doctorData->doctorUser->linkedIn_url); ?>"
                                        class="fs-5 text-primary-800 text-decoration-none"><?php echo e($doctorData->doctorUser->linkedIn_url); ?></a>
                                <?php else: ?>
                                    <?php echo e(__('messages.common.n/a')); ?>

                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="tab-pane fade" id="showPatientCases" role="tabpanel">
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('patient-case-table', ['patientId' => ''.e($data->id).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-1804912186-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>
    <div class="tab-pane fade" id="showPatientAdmissions" role="tabpanel">
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('patient-admission-detail-table', ['patientId' => ''.e($data->id).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-1804912186-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>
    <div class="tab-pane fade" id="showPatientAppointments" role="tabpanel">
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('patient-appoinment-detail-table', ['patientId' => ''.e($data->id).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-1804912186-2', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>
    <div class="tab-pane fade" id="showPatientBills" role="tabpanel">
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('patient-bill-detail-table', ['patientId' => ''.e($data->id).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-1804912186-3', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>
    <div class="tab-pane fade" id="showPatientInvoices" role="tabpanel">
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('patient-invoice-detail-table', ['patientId' => ''.e($data->id).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-1804912186-4', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>
    <div class="tab-pane fade" id="showPatientAdvancedPayments" role="tabpanel">
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('patient-advance-payment-detail-table', ['patientId' => ''.e($data->id).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-1804912186-5', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>
    <div class="tab-pane fade" id="showPatientDocument" role="tabpanel">
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('patient-document-table', ['patientId' => ''.e($data->id).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-1804912186-6', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>
    <div class="tab-pane fade" id="showPatientVaccinated" role="tabpanel">
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('patient-vaccination-detail-table', ['patientId' => ''.e($data->id).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-1804912186-7', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>
</div>
<?php /**PATH /home/iankim/public_html/resources/views/patients/show_fields.blade.php ENDPATH**/ ?>