<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages.front_settings')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('section'); ?>
    <div class="card">
        <div class="card-header pb-0">
            <div class="card-title m-0">
                <h3><?php echo e(__('messages.front_setting.about_us_details')); ?></h3>
            </div>
        </div>
        <div class="card-body pt-3">
            <?php echo e(Form::open(['route' => ['front.settings.update'], 'method' => 'post', 'files' => true, 'id' => 'createAboutUs'])); ?>

            <?php echo e(Form::hidden('sectionName', $sectionName)); ?>

            <div class="alert alert-danger d-none hide" id="aboutUsErrorsBox"></div>
            <div class="row">
                <!-- About Us title Field -->
                <div class="form-group col-sm-12 mb-5">
                    <?php echo e(Form::label('about_us_title', __('messages.front_setting.about_us_title') . ':', ['class' => 'form-label'])); ?>

                    <span class="required"></span>
                    <?php echo e(Form::text('about_us_title', $frontSettings['about_us_title'], ['class' => 'form-control', 'required', 'id' => 'aboutUsTitle', 'placeholder' => __('messages.front_setting.about_us_title')])); ?>

                </div>
                <!-- About Us description Field -->
                <div class="form-group col-sm-12 mb-5">
                    <?php echo e(Form::label('about_us_description', __('messages.front_setting.about_us_description') . ':', ['class' => 'form-label'])); ?>

                    <span class="required"></span>
                    <?php echo e(Form::textarea('about_us_description', $frontSettings['about_us_description'], ['class' => 'form-control', 'required', 'rows' => 5, 'id' => 'aboutUsDes', 'placeholder' => __('messages.front_setting.about_us_description')])); ?>

                </div>
                <!-- About Us mission Field -->
                <div class="form-group col-sm-12 mb-5">
                    <?php echo e(Form::label('about_us_mission', __('messages.front_setting.about_us_mission') . ':', ['class' => 'form-label'])); ?>

                    <span class="required"></span>
                    <?php echo e(Form::textarea('about_us_mission', $frontSettings['about_us_mission'], ['class' => 'form-control', 'required', 'rows' => 5, 'id' => 'aboutUsMission', 'placeholder' => __('messages.front_setting.about_us_mission')])); ?>

                </div>
                <?php echo e(Form::label('about_us_image', __('messages.front_setting.about_us_image') . ':', ['class' => 'form-label required'])); ?>

                <div class="d-block">
                    <div class="image-picker">
                        <div class="image previewImage" id="aboutUsPreviewImage"
                            style="background-image: url(<?php echo e($frontSettings['about_us_image'] ? $frontSettings['about_us_image'] : asset('assets/img/default_image.jpg')); ?>)">
                            <span class="picker-edit rounded-circle text-gray-500 fs-small"
                                title="<?php echo e(__('messages.common.change_profile')); ?>">
                                <label>
                                    <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                    <?php echo e(Form::file('about_us_image', ['id' => 'aboutUsImage', 'class' => 'image-upload d-none homePageImage', 'accept' => '.png, .jpg, .jpeg'])); ?>

                                    <input type="hidden" name="avatar_remove" />
                                </label>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="clearfix"></div>
                <div class="row">
                    <!-- Submit Field -->
                    <div class="form-group col-sm-12 mb-5 d-flex justify-content-end">
                        <?php echo e(Form::submit(__('messages.common.save'), ['class' => 'btn btn-primary me-3'])); ?>

                        <?php echo e(Form::reset(__('messages.common.cancel'), ['class' => 'btn btn-secondary'])); ?>

                    </div>
                </div>
            </div>
            <?php echo e(Form::close()); ?>

        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('front_settings.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/niconorg/allaboutali.nicon.org.pk/resources/views/front_settings/about-us.blade.php ENDPATH**/ ?>