<?php
    App::setLocale(session('languageName'));
?>
<?php $__env->startSection('title'); ?>
    <?php echo e(__('web.register')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!--begin::Authentication - Sign-up -->
    <?php
        $style = 'style=background-image:url(' . asset('assets/img/progress-hd.png') . ')';
        $settingValue = getSettingValue();
        App::setLocale(checkLanguageSession());
    ?>

    <ul class="nav nav-pills" style="justify-content: flex-end; cursor: pointer">
        <li class="nav-item dropdown">
            <a class="btn btn-primary w-150px mb-5 indicator m-3" data-bs-toggle="dropdown" href="javascript:void(0)"
                role="button" aria-expanded="false"><?php echo e(__('messages.language.' . getCurrentLanguageName())); ?></a>
            <ul class="dropdown-menu w-150px">
                <?php $__currentLoopData = getLanguages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="<?php echo e(checkLanguageSession() == $key ? 'active' : ''); ?>"><a
                            class="dropdown-item  px-5 language-select <?php echo e(checkLanguageSession() == $key ? 'bg-primary text-white' : 'text-dark'); ?>"
                            data-id="<?php echo e($key); ?>"><?php echo e($value); ?></a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </li>
    </ul>

    <div class="d-flex flex-column flex-column-fluid align-items-center justify-content-center p-4">
        <div class="col-12 text-center">
            <a href="<?php echo e(route('front')); ?>" class="image mb-7 mb-sm-10" data-turbo="false">
                <img alt="Logo" src="<?php echo e($settingValue['app_logo']['value']); ?>" class="img-fluid logo-fix-size">
            </a>
        </div>
        <div class="width-540">
            <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
        </div>
        <div class="bg-white rounded-15 shadow-md width-540 px-5 px-sm-7 py-10 mx-auto">
            <h1 class="text-center mb-7"><?php echo e(__('auth.registration.patient_registration')); ?></h1>
            <form method="POST" action="<?php echo e(url('/register')); ?>">
                <?php echo csrf_field(); ?>

                <div class="row">
                    <div class="col-md-6 mb-sm-7 mb-4">
                        <label for="formInputFirstName" class="form-label">
                            <?php echo e(__('messages.profile.first_name') . ':'); ?><span class="required"></span>
                        </label>
                        <input name="first_name" type="text" class="form-control" id="first_name"
                            placeholder=" <?php echo e(__('messages.profile.first_name')); ?>" aria-describedby="firstName"
                            value="<?php echo e(old('first_name')); ?>"
                            onkeypress='if (/\s/g.test(this.value)) this.value = this.value.replace(/\s/g,"")' required>
                    </div>
                    <div class="col-md-6 mb-sm-7 mb-4">
                        <label for="last_name" class="form-label">
                            <?php echo e(__('messages.profile.last_name') . ':'); ?><span class="required"></span>
                        </label>
                        <input name="last_name" type="text" class="form-control" id="last_name"
                            placeholder=" <?php echo e(__('messages.profile.last_name')); ?>" aria-describedby="lastName"
                            onkeypress='if (/\s/g.test(this.value)) this.value = this.value.replace(/\s/g,"")' required
                            value="<?php echo e(old('last_name')); ?>">
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-sm-7 mb-4">
                        <label for="email" class="form-label">
                            <?php echo e(__('auth.email') . ':'); ?><span class="required"></span>
                        </label>
                        <input name="email" type="email" class="form-control" id="email" aria-describedby="email"
                            placeholder=" <?php echo e(__('auth.email')); ?>" value="<?php echo e(old('email')); ?>" required>
                    </div>
                    <div class="col-md-6 mb-sm-7 mb-4">
                        <?php echo e(Form::label('phone', __('messages.user.phone') . ': ', ['class' => 'form-label required'])); ?>

                        <br>
                        <?php echo e(Form::tel('phone', getCountryCode(), ['class' => 'form-control phoneNumber', 'onkeyup' => 'if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,"")'])); ?>

                        <?php echo e(Form::hidden('prefix_code', null, ['class' => 'prefix_code'])); ?>

                        <span class="text-success valid-msg d-none fw-400 fs-small mt-2">✓ &nbsp;
                            <?php echo e(__('messages.valid')); ?></span>
                        <span class="text-danger error-msg d-none fw-400 fs-small mt-2"></span>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6 mb-sm-7 mb-4">
                        <label for="password" class="form-label">
                            <?php echo e(__('auth.password') . ':'); ?><span class="required"></span>
                        </label>
                        <div class="mb-3 position-relative">
                            <input type="password" name="password" class="form-control" id="password"
                                onkeypress='if (/\s/g.test(this.value)) this.value = this.value.replace(/\s/g,"")'
                                placeholder=" <?php echo e(__('auth.password')); ?>" aria-describedby="password" required
                                aria-label="Password" data-toggle="password">
                        </div>
                    </div>
                    <div class="col-md-6 mb-sm-7 mb-4">
                        <label for="password_confirmation" class="form-label">
                            <?php echo e(__('auth.confirm_password') . ':'); ?><span class="required"></span>
                        </label>
                        <div class="mb-3 position-relative">
                            <input name="password_confirmation" type="password" class="form-control"
                                placeholder=" <?php echo e(__('auth.confirm_password')); ?>" id="password_confirmation"
                                aria-describedby="confirmPassword" required aria-label="Password"
                                onkeypress='if (/\s/g.test(this.value)) this.value = this.value.replace(/\s/g,"")'
                                data-toggle="password">
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-sm-7 mb-4">
                    <div class="form-group mb-5">
                        <label class="form-label"><?php echo e(__('messages.user.gender')); ?>

                            <span class="required"></span> &nbsp;<br>
                        </label>
                        <br>
                        <div class="d-flex align-items-center">

                            <div class="form-check me-5">
                                <input class="form-check-input" type="radio" name="gender" value="0" checked
                                    id="male" />
                                <label class="form-check-label" for="male">
                                    <?php echo e(__('messages.user.male')); ?>

                                </label>
                            </div>

                            <div class="form-check me-10">
                                <input class="form-check-input" type="radio" name="gender" value="1"
                                    id="female" />
                                <label class="form-check-label" for="female">
                                    <?php echo e(__('messages.user.female')); ?>

                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary"><?php echo e(__('auth.submit')); ?></button>
                </div>

                <div class="d-flex align-items-center mt-4">
                    <span class="text-gray-700 me-2"><?php echo e(__('auth.already_user')); ?></span>
                    <a href="<?php echo e(route('login')); ?>" class="link-info fs-6 text-decoration-none">
                        <?php echo e(__('auth.sign_in')); ?>

                    </a>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/niconorg/allaboutali.nicon.org.pk/resources/views/auth/register.blade.php ENDPATH**/ ?>