<div id="add_front_service_modal" class="modal fade" role="dialog" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title" id="exampleModalLabel"><?php echo e(__('messages.service.new_service')); ?></h3>
                <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
            </div>
            <?php echo e(Form::open(['id'=>'addFrontServiceForm','files' => true])); ?>

            <div class="modal-body">
                <div class="alert alert-danger d-none hide" id="frontServiceErrorsBox"></div>
                <div class="row">
                    <div class="form-group col-sm-12 mb-5">
                        <?php echo e(Form::label('name', __('messages.common.name').(':'), ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::text('name', null, ['class' => 'form-control','required','placeholder'=>__('messages.common.name')])); ?>

                    </div>
                    <div class="form-group col-sm-12 mb-5">
                        <?php echo e(Form::label('short_description', __('messages.short_description').(':'),['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::textarea('short_description', null, ['class' => 'form-control','rows' => 6,'placeholder'=>__('messages.short_description')])); ?>

                    </div>
                    <div class="form-group col-sm-12 mb-5">
                        <div class="row2" io-image-input="true">
                            <?php echo e(Form::label('image',__('messages.icon').(':'), ['class' => 'form-label'])); ?>

                            <span class="required"></span>
                            <div class="d-block">
                                <?php
                                $style = 'style=';
                                $background = 'background-image:';
                                ?>

                                <div class="image-picker">
                                    <div class="image previewImage" id="frontServicePreviewImage"
                                    <?php echo e($style); ?>"<?php echo e($background); ?> url(<?php echo e(asset('web_front/images/services/medicine.png')); ?>

                                    ">
                                        <span class="picker-edit rounded-circle text-gray-500 fs-small" title="<?php echo e(__('messages.icon')); ?>">
                                            <label>
                                            <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                                <?php echo e(Form::file('icon',['id'=>'frontServiceIcon','class' => 'image-upload d-none document-file'])); ?>

                                                <input type="hidden" name="avatar_remove"/>
                                            </label>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer pt-0">
                <?php echo e(Form::button(__('messages.common.save'), ['type' => 'submit','class' => 'btn btn-primary m-0','id' => 'frontServiceSave','data-loading-text' => "<span class='spinner-border spinner-border-sm'></span> Processing..."])); ?>

                <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal"><?php echo e(__('messages.common.cancel')); ?></button>
            </div>
            <?php echo e(Form::close()); ?>

        </div>
    </div>
</div>
<?php /**PATH /home/iankim/public_html/resources/views/front_settings/front_services/add_modal.blade.php ENDPATH**/ ?>