<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="title" content="<?php echo e(config('app.name')); ?>">

    <meta name="keywords" content="<?php echo e(getCompanyName()); ?>"/>

    <meta name="description" content="<?php echo e(getAppName()); ?>"/>
    <meta name="author" content="<?php echo e(getCompanyName()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php
        $settingValue = getSettingValue();
        App::setLocale(checkLanguageSession());
    ?>
    <link rel="icon" href="<?php echo e($settingValue['favicon']['value']); ?>" type="image/png">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Email Verification | <?php echo e(config('app.name')); ?></title>
    <link rel="stylesheet" href="<?php echo e(mix('web_front/css/bootstrap.css')); ?>">
    <?php echo $__env->yieldContent('page_css'); ?>
</head>
<body>
    <div class="container con-404 vh-100 d-flex justify-content-center">
        <div class="row justify-content-md-center d-block">
            <div class="col-md-12 mt-5">
                <img src="<?php echo e(asset('web/img/verification.png')); ?>" class="img-fluid img-404 mx-auto d-block">
            </div>
            <div class="col-md-12 text-center mt-5">
                <h2><?php echo e(__('messages.verification.verify_your_email_address')); ?></h2>
                <p class="not-found-subtitle">
                    <?php echo e(__('messages.verification.verify_message')); ?>

                </p>
                
                <form class="d-inline" method="POST" action="<?php echo e(route('verification.resend')); ?>">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-primary mt-3">
                        <?php echo e(__('messages.verification.another_verify_request')); ?>

                    </button>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/niconorg/allaboutali.nicon.org.pk/resources/views/auth/verify.blade.php ENDPATH**/ ?>