<div>
    <div class="tab-content" id="myAmbulanceCallTabContent">
        <div class="tab-pane fade show active" id="ambulanceCallPoverview" role="tabpanel">
            <div class="card mb-5 mb-xl-10">
                <div class="card-header border-0">
                    <div class="card-title m-0">
                        <h3 class="fw-bolder m-0">{{__('messages.ambulance_call.ambulance_call_details')}}</h3>
                    </div>
                </div>
                <div>
                    <div class="card-body  border-top p-9">
                        <div class="row mb-7">
                            <div class="col-lg-3 d-flex flex-column">
                                <label class="fw-bold text-muted py-3">{{ __('messages.ambulance_call.patient').(':')  }}</label>
                                <span class="fw-bolder fs-6 text-gray-800">{{ $ambulanceCall->patient->user->full_name}}</span>
                            </div>
                            <div class="col-lg-3 d-flex flex-column">
                                <label class="fw-bold text-muted py-3">{{ __('messages.ambulance_call.vehicle_model').(':')  }}</label>
                                <span class="fw-bolder fs-6 text-gray-800">{{$ambulanceCall->ambulance->vehicle_model}}</span>
                            </div>
                            <div class="col-lg-3 d-flex flex-column">
                                <label class="fw-bold text-muted py-3">{{ __('messages.ambulance_call.date').(':')  }}</label>
                                <span class="fw-bolder fs-6 text-gray-800">{{ \Carbon\Carbon::parse($ambulanceCall->date)->format('jS M, Y') }}</span>
                            </div>
                            <div class="col-lg-3 d-flex flex-column">
                                <label class="fw-bold text-muted py-3">{{ __('messages.ambulance_call.driver_name').(':')  }}</label>
                                <span class="fw-bolder fs-6 text-gray-800">{{ $ambulanceCall->driver_name }}</span>
                            </div>
                            <div class="col-lg-3 d-flex flex-column">
                                <label class="fw-bold text-muted py-3">{{ __('messages.ambulance_call.amount').(':')  }}</label>
                                <p><span class="fw-bolder fs-6 text-gray-800"><b>{{ getCurrencySymbol() }}</b> {{ number_format($ambulanceCall->amount,2) }}</span>
                                </p>
                            </div>
                            <div class="col-lg-3 d-flex flex-column">
                                <label class="fw-bold text-muted py-3">{{ __('messages.common.created_at').(':')  }}</label>
                                <span class="fw-bolder fs-6 text-gray-800" data-placement="top"  data-bs-original-title="{{ date('jS M, Y', strtotime($ambulanceCall->created_at)) }}">{{ $ambulanceCall->created_at->diffForHumans() }}</span>
                            </div>
                            <div class="col-lg-3 d-flex flex-column">
                                <label class="fw-bold text-muted py-3">{{ __('messages.common.last_updated').(':')  }}</label>
                                <span class="fw-bolder fs-6 text-gray-800" data-placement="top"  data-bs-original-title="{{ date('jS M, Y', strtotime($ambulanceCall->updated_at)) }}">{{ $ambulanceCall->updated_at->diffForHumans() }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
