/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"ar.js":{"about_us_description_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0627\u0644\u0648\u0635\u0641 \u0627\u0644\u062e\u0627\u0635 \u0628\u0646\u0627 \u0639\u0644\u0649 \u0645\u0633\u0627\u062d\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","about_us_mission_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0627\u0644\u0645\u0647\u0645\u0629 \u0627\u0644\u062e\u0627\u0635 \u0628\u0646\u0627 \u0639\u0644\u0649 \u0645\u0633\u0627\u062d\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","about_us_title_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0627\u0644\u0639\u0646\u0648\u0627\u0646 \"\u0646\u0628\u0630\u0629 \u0639\u0646\u0627\" \u0639\u0644\u0649 \u0645\u0633\u0627\u062d\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","account":"\u062d\u0633\u0627\u0628","all_notification_read_successfully":"\u062a\u0645\u062a \u0642\u0631\u0627\u0621\u0629 \u0643\u0627\u0641\u0629 \u0627\u0644\u0625\u062e\u0637\u0627\u0631\u0627\u062a \u0628\u0646\u062c\u0627\u062d","allow_file_type":"\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627: png\u060c jpg\u060c jpeg.","amount":"\u0643\u0645\u064a\u0629","apply":"\u064a\u062a\u0642\u062f\u0645","appointment":"\u0645\u064a\u0639\u0627\u062f","apr":"\u0623\u0628\u0631\u064a\u0644","are_you_sure":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f\u061f","are_you_sure_want_to_cancel":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u063a\u0627\u0621","are_you_sure_want_to_change":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0627\u0644\u062a\u063a\u064a\u064a\u0631","are_you_sure_want_to_return_this_item":"\u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0623\u0646\u0643 \u062a\u0631\u064a\u062f \u0625\u0631\u062c\u0627\u0639 \u0647\u0630\u0627 \u0627\u0644\u0639\u0646\u0635\u0631","aug":"\u0623\u063a\u0633\u0637\u0633","available_quantity":"\u0627\u0644\u0643\u0645\u064a\u0629 \u0627\u0644\u0645\u062a\u0648\u0641\u0631\u0629","available_time_greater_than_zero":"\u0645\u062a\u0627\u062d \u0645\u0646 \u0627\u0644\u0648\u0642\u062a \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0627\u0644\u0635\u0641\u0631","available_time_less_than_hospital_schedule_time":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0648\u0642\u062a \u0627\u0644\u0645\u062a\u0627\u062d \u0623\u0642\u0644 \u0645\u0646 \u0648\u0642\u062a \u0627\u0644\u062c\u062f\u0648\u0644 \u0627\u0644\u0632\u0645\u0646\u064a \u0644\u0644\u0645\u0633\u062a\u0634\u0641\u0649","available_to_time_greater_than_zero":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0648\u0642\u062a \u0627\u0644\u0645\u062a\u0627\u062d \u0623\u0643\u0628\u0631 \u0645\u0646 \u0627\u0644\u0635\u0641\u0631","bed":"\u0633\u0631\u064a\u0631","break_time_greater_than_zero":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0648\u0642\u062a \u0627\u0644\u0627\u0633\u062a\u0631\u0627\u062d\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0627\u0644\u0635\u0641\u0631","break_to_time_greater_than_from_time":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0648\u0642\u062a \u0627\u0644\u0627\u0633\u062a\u0631\u0627\u062d\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0648\u0642\u062a \u0627\u0644\u0627\u0633\u062a\u0631\u0627\u062d\u0629.","break_to_time_greater_than_zero":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0648\u0642\u062a \u0627\u0644\u0627\u0633\u062a\u0631\u0627\u062d\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0627\u0644\u0635\u0641\u0631","cancel":"\u064a\u0644\u063a\u064a","canceled":"\u0623\u0644\u063a\u064a\u062a","case":"\u0642\u0636\u064a\u0629","case_id":"ID \u0627\u0644\u0642\u0636\u064a\u0629","change_status":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0648\u0636\u0639","changed_appointment":"\u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0645\u0648\u0639\u062f","charge":"\u062a\u0643\u0644\u0641\u0629","choose":"\u064a\u062e\u062a\u0627\u0631","complete_this_payment":"\u062a\u0631\u064a\u062f \u0625\u062a\u0645\u0627\u0645 \u0647\u0630\u0647 \u0627\u0644\u062f\u0641\u0639\u0629!!","custom":"\u0645\u062e\u0635\u0635","date_required":"\u062d\u0642\u0644 \u0627\u0644\u062a\u0627\u0631\u064a\u062e \u0645\u0637\u0644\u0648\u0628.","dec":"\u062f\u064a\u0633\u0645\u0628\u0631","delete_medicine":"\u0647\u0630\u0627 \u0627\u0644\u062f\u0648\u0627\u0621 \u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0627\u0644\u0641\u0639\u0644 \u0641\u064a \u0641\u0648\u0627\u062a\u064a\u0631 \u0627\u0644\u0623\u062f\u0648\u064a\u0629\u060c \u0647\u0644 \u0623\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0631\u063a\u0628\u062a\u0643 \u0641\u064a \u062d\u0630\u0641\u0647\u061f","department":"\u0642\u0633\u0645","disconnect_or_reconnect":"\u064a\u0631\u062c\u0649 \u0642\u0637\u0639 \u0627\u0644\u0627\u062a\u0635\u0627\u0644 \u0648\u0625\u0639\u0627\u062f\u0629 \u062a\u0648\u0635\u064a\u0644 \u062a\u0642\u0648\u064a\u0645 Google \u0627\u0644\u062e\u0627\u0635 \u0628\u0643","doctor_schedule_not_available_on_this_date":"\u062c\u062f\u0648\u0644 \u0627\u0644\u0637\u0628\u064a\u0628 \u063a\u064a\u0631 \u0645\u062a\u0627\u062d \u0647\u0630\u0627 \u0627\u0644\u062a\u0627\u0631\u064a\u062e.","document_error":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0633\u062a\u0646\u062f \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: jpeg\u060c jpg\u060c png\u060c pdf\u060c doc\u060c docx.","employee":"\u0645\u0648\u0638\u0641","employee_payroll_deduction":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0627\u0633\u062a\u0642\u0637\u0627\u0639\u0627\u062a \u0623\u0643\u0628\u0631 \u0645\u0646 \u0627\u0644\u0631\u0627\u062a\u0628 \u0627\u0644\u0623\u0633\u0627\u0633\u064a + \u0627\u0644\u0639\u0644\u0627\u0648\u0629","expenses":"\u0646\u0641\u0642\u0627\u062a","feb":"\u0634\u0647\u0631 \u0641\u0628\u0631\u0627\u064a\u0631","field_required":"\u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628.","flutterwave_public_key":"\u0627\u0644\u0645\u0641\u062a\u0627\u062d \u0627\u0644\u0639\u0627\u0645 Flutterwave","flutterwave_secret_key":"\u0645\u0641\u062a\u0627\u062d Flutterwave \u0627\u0644\u0633\u0631\u064a","fri":"\u0627\u0644\u062c\u0645\u0639\u0629","from":"\u0645\u0646","google_meet":"\u062c\u0648\u062c\u0644 \u0645\u064a\u062a","has_been_cancelled":"\u062a\u0645 \u0625\u0644\u063a\u0627\u0621.","has_been_changed":"\u062a\u063a\u064a\u0631.","has_been_deleted":"\u0642\u062f \u062a\u0645 \u062d\u0630\u0641.","holiday":"\u0639\u0637\u0644\u0629","home_page_box_descriptions_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0623\u0648\u0635\u0627\u0641 \u0645\u0631\u0628\u0639 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u062d\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_box_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0639\u0646\u0648\u0627\u0646 \u0645\u0631\u0628\u0639 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_certified_box_title_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0645\u0631\u0628\u0639 \u0627\u0644\u0645\u0639\u062a\u0645\u062f \u0644\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_certified_description_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0627\u0644\u0648\u0635\u0641 \u0627\u0644\u0645\u0639\u062a\u0645\u062f \u0627\u0644\u0645\u0639\u062a\u0645\u062f \u0639\u0644\u0649 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_certified_doctor_description_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0648\u0635\u0641 \u0627\u0644\u0637\u0628\u064a\u0628 \u0627\u0644\u0645\u0639\u062a\u0645\u062f \u0641\u064a \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u062d\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_certified_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0627\u0644\u062d\u0642\u0644 \u0627\u0644\u0646\u0635\u064a \u0644\u0644\u0637\u0628\u064a\u0628 \u0627\u0644\u0645\u0639\u062a\u0645\u062f \u0641\u064a \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_certified_title_required":"\u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u062d\u0642\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0637\u0628\u064a\u0628 \u0627\u0644\u0645\u0639\u062a\u0645\u062f \u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_description_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0648\u0635\u0641 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_experience_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u062a\u062c\u0631\u0628\u0629 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u062d\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_step_description_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0648\u0635\u0641 \u0627\u0644\u062e\u0637\u0648\u0629 1 \u0641\u064a \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_step_four_description_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0648\u0635\u0641 \u0627\u0644\u062e\u0637\u0648\u0629 4 \u0641\u064a \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_step_four_title_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u062e\u0637\u0648\u0629 4 \u0641\u064a \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_step_three_description_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0648\u0635\u0641 \u0627\u0644\u062e\u0637\u0648\u0629 3 \u0641\u064a \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_step_three_title_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u062e\u0637\u0648\u0629 3 \u0641\u064a \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_step_title_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u062e\u0637\u0648\u0629 1 \u0641\u064a \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_step_two_description_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0648\u0635\u0641 \u0627\u0644\u062e\u0637\u0648\u0629 2 \u0641\u064a \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_step_two_title_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u062e\u0637\u0648\u0629 2 \u0641\u064a \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","home_page_title_required":"\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u062d\u0642\u0644 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0635\u0641\u062d\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u0639\u0644\u0649 \u0645\u0633\u0627\u0641\u0629 \u0628\u064a\u0636\u0627\u0621 \u0641\u0642\u0637","income":"\u062f\u062e\u0644","invalid_country_code":"\u0631\u0645\u0632 \u0627\u0644\u0628\u0644\u062f \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","invalid_number":"\u0631\u0642\u0645 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d","ipd_operation":"\u0639\u0645\u0644\u064a\u0629 IPD","ipd_patient":"\u0645\u0631\u064a\u0636 IPD","item":"\u063a\u0631\u0636","item_name":"\u0627\u0633\u0645 \u0627\u0644\u0639\u0646\u0635\u0631","item_returned":"\u0639\u0627\u062f","jan":"\u064a\u0646\u0627\u064a\u0631","july":"\u064a\u0648\u0644\u064a\u0648","jun":"\u064a\u0648\u0646\u064a\u0648","last_30_days":"\u0622\u062e\u0631 30 \u064a\u0648\u0645\u064b\u0627","last_7_days":"\u0627\u062e\u0631 7 \u0627\u064a\u0627\u0645","last_month":"\u0627\u0644\u0634\u0647\u0631 \u0627\u0644\u0645\u0627\u0636\u064a","lot_number":"\u0623\u062f\u062e\u0644 \u0631\u0642\u0645 \u0627\u0644\u0642\u0637\u0639\u0629","lunch_break":"\u0627\u0633\u062a\u0631\u0627\u062d\u0629","make_payment":"\u0642\u0645 \u0628\u0627\u0644\u062f\u0641\u0639","mar":"\u064a\u0645\u0634\u064a","may":"\u064a\u0645\u0643\u0646","medicine_bill":"\u0641\u0627\u062a\u0648\u0631\u0629 \u0627\u0644\u0637\u0628","medicine_category":"\u0641\u0626\u0629 \u0627\u0644\u0637\u0628","medicine_required":"\u0645\u0637\u0644\u0648\u0628 \u0645\u062c\u0627\u0644 \u0627\u0644\u0637\u0628.","message_not_greater_than_160_characters":"\u0644\u0627 \u064a\u062c\u0648\u0632 \u0623\u0646 \u062a\u0632\u064a\u062f \u0627\u0644\u0631\u0633\u0627\u0644\u0629 \u0639\u0646 160 \u062d\u0631\u0641\u064b\u0627.","mon":"\u0645\u0648\u0646","month":"\u0634\u0647\u0631","n\/a":"\u0644\u0627 \u064a\u0648\u062c\u062f","net_amount_not_empty":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0635\u0627\u0641\u064a \u0641\u0627\u0631\u063a\u064b\u0627.","net_amount_not_zero":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0635\u0627\u0641\u064a \u0635\u0641\u0631\u0627\u064b.","no":"\u0644\u0627","notification_read_successfully":"\u062a\u0645\u062a \u0642\u0631\u0627\u0621\u0629 \u0627\u0644\u0625\u0634\u0639\u0627\u0631 \u0628\u0646\u062c\u0627\u062d","nov":"\u0634\u0647\u0631 \u0646\u0648\u0641\u0645\u0628\u0631","oct":"\u0627\u0643\u062a\u0648\u0628\u0631","ok":"\u0646\u0639\u0645","password_and_confirm_password_not_match":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0648\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u063a\u064a\u0631 \u0645\u062a\u0637\u0627\u0628\u0642\u064a\u0646.","patient_id_card_template":"\u0642\u0648\u0627\u0644\u0628 \u0628\u0637\u0627\u0642\u0629 \u0627\u0644\u0645\u0631\u064a\u0636 \u0627\u0644\u0630\u0643\u064a\u0629","patient_not_exists_or_status_is_not_active":"\u0627\u0644\u0645\u0631\u064a\u0636 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f \u0623\u0648 \u0627\u0644\u062d\u0627\u0644\u0629 \u063a\u064a\u0631 \u0646\u0634\u0637\u0629.","patient_required":"\u062d\u0642\u0644 \u0627\u0644\u0645\u0631\u064a\u0636 \u0645\u0637\u0644\u0648\u0628","payment_status_must_be_active":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u062d\u0627\u0644\u0629 \u0627\u0644\u062f\u0641\u0639 \u0646\u0634\u0637\u0629.","paypal_client_id":"\u0645\u0639\u0631\u0641 \u0639\u0645\u064a\u0644 \u0628\u0627\u064a \u0628\u0627\u0644","paypal_mode":"\u0648\u0636\u0639 \u0628\u0627\u064a \u0628\u0627\u0644","paypal_secret":"\u0633\u0631 \u0628\u0627\u064a \u0628\u0627\u0644","paystack_key":"\u0645\u0641\u062a\u0627\u062d Paystack","paystack_secret_key":"\u0645\u0641\u062a\u0627\u062d Paystack \u0627\u0644\u0633\u0631\u064a","please_fill_all_the_required_fields":"\u064a\u0631\u062c\u0649 \u0645\u0644\u0621 \u0643\u0627\u0641\u0629 \u0627\u0644\u062d\u0642\u0648\u0644 \u0627\u0644\u0645\u0637\u0644\u0648\u0628\u0629.","please_select_appointment_time_slot":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u0641\u062a\u0631\u0629 \u0627\u0644\u0632\u0645\u0646\u064a\u0629 \u0644\u0644\u0645\u0648\u0639\u062f","please_select_doctor":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0627\u062e\u062a\u064a\u0627\u0631 \u0627\u0644\u0637\u0628\u064a\u0628","please_select_doctor_department":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0627\u062e\u062a\u064a\u0627\u0631 \u0642\u0633\u0645 \u0627\u0644\u0637\u0628\u064a\u0628","price":"\u0633\u0639\u0631","privacy_policy":"\u0633\u064a\u0627\u0633\u0629 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629","purchase_medicine":"\u0634\u0631\u0627\u0621 \u0627\u0644\u0637\u0628","purchase_price":"\u0623\u062f\u062e\u0644 \u0633\u0639\u0631 \u0627\u0644\u0634\u0631\u0627\u0621","qty":"\u0627\u0644\u0643\u0645\u064a\u0629","quantity_cannot_be_zero":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0635\u0641\u0631\u064b\u0627 \u0623\u0648 \u0641\u0627\u0631\u063a\u0629.","quantity_must_be_less_than_available_quantity":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0623\u0642\u0644 \u0645\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0627\u0644\u0645\u062a\u0648\u0641\u0631\u0629.","quantity_required":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0627\u0644\u0643\u0645\u064a\u0629.","razorpay_key":"\u0645\u0641\u062a\u0627\u062d \u0631\u0627\u0632\u0648\u0631\u0628\u0627\u064a","razorpay_secret":"\u0633\u0631 \u0627\u0644\u062d\u0644\u0627\u0642\u0629","sale_price":"\u0633\u0639\u0631 \u0627\u0644\u0628\u064a\u0639","sat":"\u0642\u0639\u062f","saved_successfully":"\u062d\u0641\u0638 \u0628\u0646\u062c\u0627\u062d","schedule_time":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0648\u0642\u062a \u0627\u0644\u0645\u062a\u0627\u062d \u0623\u0643\u0628\u0631 \u0645\u0646 \u0648\u0642\u062a \u062c\u062f\u0648\u0644 \u0627\u0644\u0645\u0633\u062a\u0634\u0641\u0649","schedule_time_select":"\u064a\u0631\u062c\u0649 \u0627\u0644\u062a\u062d\u062f\u064a\u062f \u0644\u0643\u0644 \u0645\u0631\u064a\u0636","search":"\u064a\u0628\u062d\u062b","select_bed_type":"\u062d\u062f\u062f \u0646\u0648\u0639 \u0627\u0644\u0633\u0631\u064a\u0631","select_calendar":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u0627\u0644\u062a\u0642\u0648\u064a\u0645.","select_category":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0641\u0626\u0629","select_charge_category":"\u062d\u062f\u062f \u0641\u0626\u0629 \u0627\u0644\u0634\u062d\u0646","select_doctor":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0637\u0628\u064a\u0628","select_medicine":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0637\u0628","select_parameter_name":"\u062d\u062f\u062f \u0627\u0633\u0645 \u0627\u0644\u0645\u0639\u0644\u0645\u0629","select_patient":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0645\u0631\u064a\u0636","select_user":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645","sep":"\u0633\u0628\u062a\u0645\u0628\u0631","status":"\u062d\u0627\u0644\u0629","stripe_key":"\u0645\u0641\u062a\u0627\u062d \u0627\u0644\u0634\u0631\u064a\u0637","stripe_secret":"\u0633\u0631 \u0627\u0644\u0634\u0631\u064a\u0637","sun":"\u0634\u0645\u0633","tax_amount_not_zero_or_empty":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0628\u0644\u063a \u0627\u0644\u0636\u0631\u064a\u0628\u0629 \u0635\u0641\u0631\u064b\u0627 \u0623\u0648 \u0641\u0627\u0631\u063a\u064b\u0627.","terms_conditions":"\u0627\u0644\u0628\u0646\u0648\u062f \u0648 \u0627\u0644\u0638\u0631\u0648\u0641","the_privacy_policy_is_required":"\u0633\u064a\u0627\u0633\u0629 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629 \u0645\u0637\u0644\u0648\u0628\u0629.","the_terms_conditions_is_required":"\u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645 \u0645\u0637\u0644\u0648\u0628\u0629.","this_month":"\u0647\u0630\u0627 \u0627\u0644\u0634\u0647\u0631","this_week":"\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0628\u0648\u0639","thu":"\u0627\u0644\u062e\u0645\u064a\u0633","to":"\u0644","today":"\u0627\u0644\u064a\u0648\u0645","too_long":"\u0637\u0648\u064a\u0644 \u062c\u062f\u0627","too_short":"\u0642\u0635\u064a\u0631 \u062c\u062f\u0627","tue":"\u0627\u0644\u062b\u0644\u0627\u062b\u0627\u0621","type_number":"\u0646\u0648\u0639 \u0627\u0644\u0631\u0642\u0645","update_quantity":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0643\u0645\u064a\u0629 \u0627\u0644\u062a\u062d\u062f\u064a\u062b \u0623\u0642\u0644 \u0645\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0627\u0644\u0633\u0627\u0628\u0642\u0629.","user":"\u0645\u0633\u062a\u062e\u062f\u0645","validate_discount":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u062e\u0635\u0645 \u0623\u0642\u0644 \u0645\u0646 \u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0625\u062c\u0645\u0627\u0644\u064a","validate_doc_type":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u0645\u0633\u062a\u0646\u062f \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: jpeg\u060c jpg\u060c png\u060c pdf\u060c doc\u060c docx\u060c webp","validate_facebook_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0641\u064a\u0633\u0628\u0648\u0643","validate_from_title":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646 \u0645\u0646 \u0645\u0637\u0644\u0648\u0628","validate_image_size":"\u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062d\u062c\u0645 \u0627\u0644\u0645\u0633\u062a\u0646\u062f \u0623\u0642\u0644 \u0645\u0646 10 \u0645\u064a\u063a\u0627\u0628\u0627\u064a\u062a","validate_image_type":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: jpg\u060c jpeg\u060c png.","validate_instagram_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 Instagram","validate_linkedin_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 Linkedin","validate_quantity":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0643\u0645\u064a\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 0.","validate_tax":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0636\u0631\u0627\u0626\u0628 \u0623\u0642\u0644 \u0645\u0646 100%.","validate_to_title":"\u0627\u0644\u0639\u0646\u0648\u0627\u0646 \u0625\u0644\u0649 \u0645\u0637\u0644\u0648\u0628.","validate_twitter_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u062a\u0648\u064a\u062a\u0631","value_must_be_greter_then":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0642\u064a\u0645\u0629 \u0623\u0643\u0628\u0631 \u0645\u0646 1","wed":"\u062a\u0632\u0648\u062c","yearly_income_expense_chart":"\u0645\u062e\u0637\u0637 \u0646\u0641\u0642\u0627\u062a \u0627\u0644\u062f\u062e\u0644 \u0627\u0644\u0633\u0646\u0648\u064a","yes":"\u0646\u0639\u0645","yesterday":"\u0623\u0645\u0633","zoom":"\u062a\u0643\u0628\u064a\u0631"},"de.js":{"about_us_description_required":"Das Beschreibungsfeld \u201e\u00dcber uns\u201c enth\u00e4lt nicht nur Leerzeichen","about_us_mission_required":"Das Missionsfeld \u201e\u00dcber uns\u201c enth\u00e4lt nicht nur Leerzeichen","about_us_title_required":"Das Titelfeld \u201e\u00dcber uns\u201c enth\u00e4lt nicht nur Leerzeichen","account":"Konto","all_notification_read_successfully":"Alle Benachrichtigungen wurden erfolgreich gelesen","allow_file_type":"Zul\u00e4ssige Dateitypen: PNG, JPG, JPEG.","amount":"Menge","apply":"Anwenden","appointment":"Termin","apr":"April","are_you_sure":"Bist du sicher?","are_you_sure_want_to_cancel":"Sind Sie sicher, dass sie abbrechen wollen","are_you_sure_want_to_change":"M\u00f6chten Sie wirklich etwas \u00e4ndern?","are_you_sure_want_to_return_this_item":"M\u00f6chten Sie diesen Artikel wirklich zur\u00fcckgeben?","aug":"August","available_quantity":"verf\u00fcgbare Anzahl","available_time_greater_than_zero":"Die Zeit \u201eVerf\u00fcgbar ab\u201c muss gr\u00f6\u00dfer als Null sein","available_time_less_than_hospital_schedule_time":"Die Zeit \u201eVerf\u00fcgbar bis\u201c muss k\u00fcrzer sein als die im Krankenhaus geplante Zeit","available_to_time_greater_than_zero":"Die Zeit \u201eVerf\u00fcgbar bis\u201c muss gr\u00f6\u00dfer als Null sein","bed":"Bett","break_time_greater_than_zero":"Die Pausenzeit muss gr\u00f6\u00dfer als Null sein","break_to_time_greater_than_from_time":"Die Pause-bis-Zeit muss gr\u00f6\u00dfer sein als die Pause-von-Zeit.","break_to_time_greater_than_zero":"Die Pausenzeit muss gr\u00f6\u00dfer als Null sein","cancel":"Stornieren","canceled":"Abgesagt","case":"Fall","case_id":"Fall-ID","change_status":"Status \u00e4ndern","changed_appointment":"Ge\u00e4nderter Termin","charge":"Aufladung","choose":"W\u00e4hlen","complete_this_payment":"Sie m\u00f6chten diese Zahlung abschlie\u00dfen!!","custom":"Brauch","date_required":"Das Datumsfeld ist erforderlich.","dec":"Dezember","delete_medicine":"Dieses Arzneimittel wird bereits in Arzneimittelrechnungen verwendet. M\u00f6chten Sie es wirklich l\u00f6schen?","department":"Abteilung","disconnect_or_reconnect":"Bitte trennen Sie die Verbindung zu Ihrem Google-Kalender und verbinden Sie ihn erneut","doctor_schedule_not_available_on_this_date":"Der Arztterminplan ist an diesem Datum nicht verf\u00fcgbar.","document_error":"Das Dokument muss eine Datei des folgenden Typs sein: jpeg, jpg, png, pdf, doc, docx.","employee":"Mitarbeiter","employee_payroll_deduction":"Die Abz\u00fcge d\u00fcrfen nicht h\u00f6her sein als das Grundgehalt + Zulage","expenses":"Kosten","feb":"Februar","field_required":"Feld ist erforderlich.","flutterwave_public_key":"\u00d6ffentlicher Flutterwave-Schl\u00fcssel","flutterwave_secret_key":"Geheimer Flutterwave-Schl\u00fcssel","fri":"FR","from":"Aus","google_meet":"Google Meet","has_been_cancelled":"wurde abgebrochen.","has_been_changed":"wurde ge\u00e4ndert.","has_been_deleted":"wurde gel\u00f6scht.","holiday":"Holiday","home_page_box_descriptions_required":"Das Feld \u201eBeschreibungen des Startseitenfelds\u201c enth\u00e4lt nicht nur Leerzeichen","home_page_box_required":"Das Titelfeld der Homepage-Box enth\u00e4lt nicht nur Leerzeichen","home_page_certified_box_title_required":"Das Titelfeld der zertifizierten Homepage-Box enth\u00e4lt nicht nur Leerzeichen","home_page_certified_description_required":"Das zertifizierte Beschreibungsfeld der Startseite enth\u00e4lt nicht nur Leerzeichen","home_page_certified_doctor_description_required":"Das Beschreibungsfeld des zertifizierten Arztes auf der Homepage enth\u00e4lt nicht nur Leerzeichen","home_page_certified_required":"Das Textfeld \u201eZertifizierter Arzt\u201c auf der Homepage enth\u00e4lt nicht nur Leerzeichen","home_page_certified_title_required":"Das Titelfeld der Homepage des zertifizierten Arztes enth\u00e4lt nicht nur Leerzeichen","home_page_description_required":"Das Beschreibungsfeld der Homepage enth\u00e4lt nicht nur Leerzeichen","home_page_experience_required":"Das Erlebnisfeld der Homepage enth\u00e4lt nicht nur Leerzeichen","home_page_step_description_required":"Das Beschreibungsfeld f\u00fcr Schritt 1 der Startseite enth\u00e4lt nicht nur Leerzeichen","home_page_step_four_description_required":"Das Beschreibungsfeld der Startseite in Schritt 4 enth\u00e4lt nicht nur Leerzeichen","home_page_step_four_title_required":"Das Titelfeld von Schritt 4 der Startseite enth\u00e4lt nicht nur Leerzeichen","home_page_step_three_description_required":"Das Beschreibungsfeld der Startseite in Schritt 3 enth\u00e4lt nicht nur Leerzeichen","home_page_step_three_title_required":"Das Titelfeld von Schritt 3 der Startseite enth\u00e4lt nicht nur Leerzeichen","home_page_step_title_required":"Das Titelfeld von Schritt 1 der Startseite enth\u00e4lt nicht nur Leerzeichen","home_page_step_two_description_required":"Das Beschreibungsfeld der Startseite in Schritt 2 enth\u00e4lt nicht nur Leerzeichen","home_page_step_two_title_required":"Das Titelfeld von Schritt 2 der Startseite enth\u00e4lt nicht nur Leerzeichen","home_page_title_required":"Das Titelfeld der Homepage enth\u00e4lt nicht nur Leerzeichen","income":"Einkommen","invalid_country_code":"Ung\u00fcltiger L\u00e4ndercode","invalid_number":"Ung\u00fcltige Nummer","ipd_operation":"IPD-Betrieb","ipd_patient":"IPD-Patient","item":"Artikel","item_name":"Artikelname","item_returned":"Ist zur\u00fcckgekommen","jan":"Januar","july":"Juli","jun":"Juni","last_30_days":"Letzte 30 Tage","last_7_days":"Letzten 7 Tage","last_month":"Im vergangenen Monat","lot_number":"Geben Sie die Chargennummer ein","lunch_break":"Brechen","make_payment":"Zahlung durchf\u00fchren","mar":"Marsch","may":"Mai","medicine_bill":"Medizingesetz","medicine_category":"Kategorie Medizin","medicine_required":"Fachrichtung Medizin ist erforderlich.","message_not_greater_than_160_characters":"Die Nachricht darf nicht l\u00e4nger als 160 Zeichen sein.","mon":"MO","month":"Monat","n\/a":"N\/A","net_amount_not_empty":"Der Nettobetrag darf nicht leer sein.","net_amount_not_zero":"Der Nettobetrag darf nicht Null sein.","no":"NEIN","notification_read_successfully":"Benachrichtigung erfolgreich gelesen","nov":"November","oct":"Oktober","ok":"OK","password_and_confirm_password_not_match":"Passwort und Passwort best\u00e4tigen stimmen nicht \u00fcberein.","patient_id_card_template":"Vorlagen f\u00fcr intelligente Patientenkarten","patient_not_exists_or_status_is_not_active":"Der Patient existiert nicht oder der Status ist nicht aktiv.","patient_required":"Patientenfeld ist erforderlich","payment_status_must_be_active":"Der Zahlungsstatus muss aktiv sein.","paypal_client_id":"PayPal-Kunden-ID","paypal_mode":"PayPal-Modus","paypal_secret":"PayPal-Geheimnis","paystack_key":"Paystack-Schl\u00fcssel","paystack_secret_key":"Geheimer Paystack-Schl\u00fcssel","please_fill_all_the_required_fields":"Bitte f\u00fcllen Sie alle erforderlichen Felder aus.","please_select_appointment_time_slot":"Bitte w\u00e4hlen Sie den Termintermin aus","please_select_doctor":"Bitte w\u00e4hlen Sie Arzt aus","please_select_doctor_department":"Bitte w\u00e4hlen Sie die Arztabteilung aus","price":"Preis","privacy_policy":"Datenschutzrichtlinie","purchase_medicine":"Kaufen Sie Medikamente","purchase_price":"Kaufpreis eingeben","qty":"Menge","quantity_cannot_be_zero":"Die Menge darf nicht Null oder leer sein.","quantity_must_be_less_than_available_quantity":"Die Menge muss kleiner sein als die verf\u00fcgbare Menge.","quantity_required":"Bitte Menge eingeben.","razorpay_key":"Razorpay-Schl\u00fcssel","razorpay_secret":"Razorpay-Geheimnis","sale_price":"Verkaufspreis","sat":"SA","saved_successfully":"Erfolgreich gespeichert","schedule_time":"Die Zeit \u201eVerf\u00fcgbar ab\u201c muss gr\u00f6\u00dfer sein als die Zeit im Krankenhausplan","schedule_time_select":"Bitte pro Patientenzeit ausw\u00e4hlen","search":"Suchen","select_bed_type":"W\u00e4hlen Sie den Betttyp aus","select_calendar":"Bitte w\u00e4hlen Sie einen Kalender aus.","select_category":"Kategorie w\u00e4hlen","select_charge_category":"W\u00e4hlen Sie die Geb\u00fchrenkategorie aus","select_doctor":"W\u00e4hlen Sie Arzt","select_medicine":"W\u00e4hlen Sie Medizin","select_parameter_name":"W\u00e4hlen Sie Parametername","select_patient":"W\u00e4hlen Sie Patient aus","select_user":"Nutzer w\u00e4hlen","sep":"September","status":"Status","stripe_key":"Streifenschl\u00fcssel","stripe_secret":"Streifengeheimnis","sun":"SONNE","tax_amount_not_zero_or_empty":"Der Steuerbetrag darf nicht Null oder leer sein.","terms_conditions":"Terms & amp; Bedingungen","the_privacy_policy_is_required":"Die Datenschutzerkl\u00e4rung ist erforderlich.","the_terms_conditions_is_required":"Die Allgemeinen Gesch\u00e4ftsbedingungen sind erforderlich.","this_month":"Diesen Monat","this_week":"Diese Woche","thu":"DO","to":"Zu","today":"Heute","too_long":"Zu lang","too_short":"Zu kurz","tue":"DI","type_number":"Nummer eingeben","update_quantity":"Die Aktualisierungsmenge sollte geringer sein als die vorherige Menge.","user":"Benutzer","validate_discount":"Der Rabatt sollte geringer sein als der Gesamtbetrag","validate_doc_type":"Das Dokument muss eine Datei des folgenden Typs sein: jpeg, jpg, png, pdf, doc, docx, webp","validate_facebook_url":"Bitte geben Sie eine g\u00fcltige Facebook-URL ein","validate_from_title":"Der From-Titel ist erforderlich","validate_image_size":"Das Dokument muss weniger als 10 MB gro\u00df sein","validate_image_type":"Das Bild muss eine Datei des folgenden Typs sein: jpg, jpeg, png.","validate_instagram_url":"Bitte geben Sie eine g\u00fcltige Instagram-URL ein","validate_linkedin_url":"Bitte geben Sie eine g\u00fcltige Linkedin-URL ein","validate_quantity":"Die Menge sollte gr\u00f6\u00dfer als 0 sein.","validate_tax":"Die Steuern sollten weniger als 100 % betragen.","validate_to_title":"Der Titel to ist erforderlich.","validate_twitter_url":"Bitte geben Sie eine g\u00fcltige Twitter-URL ein","value_must_be_greter_then":"Wert muss gr\u00f6\u00dfer als 1 sein","wed":"HEIRATEN","yearly_income_expense_chart":"J\u00e4hrliches Einnahmen-Ausgaben-Diagramm","yes":"Ja","yesterday":"Gestern","zoom":"Zoomen"},"en.js":{"about_us_description_required":"About us description field is not contain only white space","about_us_mission_required":"About us mission field is not contain only white space","about_us_title_required":"About us title field is not contain only white space","account":"Account","all_notification_read_successfully":"All Notification Read successfully","allow_file_type":"Allowed file types: png, jpg, jpeg.","amount":"Amount","apply":"Apply","appointment":"Appointment","apr":"April","are_you_sure":"Are you sure?","are_you_sure_want_to_cancel":"Are you sure want to cancel","are_you_sure_want_to_change":"Are you sure want to change ","are_you_sure_want_to_return_this_item":"Are you sure want to return this item","aug":"August","available_quantity":"Available Quantity","available_time_greater_than_zero":"Available From time must be greater than Zero","available_time_less_than_hospital_schedule_time":"Available To time must be less than hospital schedule time","available_to_time_greater_than_zero":"Available To time must be greater than Zero","bed":"Bed","break_time_greater_than_zero":"Break From time must be greater than Zero","break_to_time_greater_than_from_time":"Break To time must be greater than Break From time.","break_to_time_greater_than_zero":"Break To time must be greater than Zero","cancel":"Cancel","canceled":"Canceled","case":"Case","case_id":"Case ID","change_status":"Change status","changed_appointment":"Changed Appointment","charge":"Charge","choose":"Choose","complete_this_payment":"You want to complete this Payment!!","custom":"Custom","date_required":"Date field is Required.","dec":"December","delete_medicine":"This medicine is already used in medicine bills, are you sure want to delete it?","department":"Department","disconnect_or_reconnect":"Please disconnect and reconnect your google calendar","doctor_schedule_not_available_on_this_date":"Doctor Schedule not available this date.","document_error":"The document must be a file of type: jpeg, jpg, png, pdf, doc, docx.","employee":"Employee","employee_payroll_deduction":"Deductions cannot be greater than Basic salary + Allowance","expenses":"Expenses","feb":"February","field_required":"field is Required.","flutterwave_public_key":"Flutterwave Public Key","flutterwave_secret_key":"Flutterwave Secret Key","fri":"FRI","from":"From","google_meet":"Google Meet","has_been_cancelled":"has been Cancelled.","has_been_changed":"has been Changed.","has_been_deleted":"has been deleted.","holiday":"Holiday","home_page_box_descriptions_required":"Home page box descriptions field is not contain only white space","home_page_box_required":"Home page box title field is not contain only white space","home_page_certified_box_title_required":"Home page certified box title field is not contain only white space","home_page_certified_description_required":"Home page certified certified description field is not contain only white space","home_page_certified_doctor_description_required":"Home page certified doctor description field is not contain only white space","home_page_certified_required":"Home page certified doctor text field is not contain only white space","home_page_certified_title_required":"home page certified doctor Title field is not contain only white space","home_page_description_required":"Home page description field is not contain only white space","home_page_experience_required":"Home page experience field is not contain only white space","home_page_step_description_required":"Home page step 1 description field is not contain only white space","home_page_step_four_description_required":"Home page step 4 description field is not contain only white space","home_page_step_four_title_required":"Home page step 4 title field is not contain only white space","home_page_step_three_description_required":"Home page step 3 description field is not contain only white space","home_page_step_three_title_required":"Home page step 3 title field is not contain only white space","home_page_step_title_required":"Home page step 1 title field is not contain only white space","home_page_step_two_description_required":"Home page step 2 description field is not contain only white space","home_page_step_two_title_required":"Home page step 2 title field is not contain only white space","home_page_title_required":"Home page title field is not contain only white space","income":"Income","invalid_country_code":"Invalid country code","invalid_number":"Invalid number","ipd_operation":"IPD operation","ipd_patient":"IPD Patient","item":"Item","item_name":"Item Name","item_returned":"Returned","jan":"January","july":"July","jun":"June","last_30_days":"Last 30 days","last_7_days":"Last 7 days","last_month":"Last month","lot_number":"Enter lot number","lunch_break":"Break","make_payment":"Make Payment","mar":"March","may":"May","medicine_bill":"Medicine Bill","medicine_category":"Medicine Category","medicine_required":"Medicine field is required.","message_not_greater_than_160_characters":"The message may not be greater than 160 characters.","mon":"MON","month":"Month","n\/a":"N\/A","net_amount_not_empty":"Net amount can not be empty.","net_amount_not_zero":"Net amount can not be zero.","no":"No","notification_read_successfully":"Notification Read successfully","nov":"November","oct":"October","ok":"Ok","password_and_confirm_password_not_match":"Password and Confirm password not match.","patient_id_card_template":"Smart Patient Card Templates","patient_not_exists_or_status_is_not_active":"Patient not exists or status is not active.","patient_required":"Patient field is required","payment_status_must_be_active":"Payment Status must be active.","paypal_client_id":"PayPal Client ID","paypal_mode":"PayPal Mode","paypal_secret":"PayPal Secret","paystack_key":"Paystack Key","paystack_secret_key":"Paystack Secret Key","please_fill_all_the_required_fields":"Please fill all the required fields.","please_select_appointment_time_slot":"Please select appointment time slot","please_select_doctor":"Please select Doctor","please_select_doctor_department":"Please select Doctor Department","price":"Price","privacy_policy":"Privacy Policy","purchase_medicine":"Purchase Medicine","purchase_price":"Enter purchase price","qty":"Qty","quantity_cannot_be_zero":"Quantity cannot be zero or empty.","quantity_must_be_less_than_available_quantity":"Quantity must be less than Available quantity.","quantity_required":"Please enter quantity.","razorpay_key":"Razorpay Key","razorpay_secret":"Razorpay Secret","sale_price":"Sale Price","sat":"SAT","saved_successfully":"saved successfully","schedule_time":"Available From time must be greater than hospital schedule time","schedule_time_select":"Please select per patient time","search":"Search","select_bed_type":"Select Bed Type","select_calendar":"Please select a calendar.","select_category":"Select Category","select_charge_category":"Select Charge Category","select_doctor":"Select Doctor","select_medicine":"Select Medicine","select_parameter_name":"Select Parameter Name","select_patient":"Select Patient","select_user":"Select User","sep":"September","status":"Status","stripe_key":"Stripe Key","stripe_secret":"Stripe Secret","sun":"SUN","tax_amount_not_zero_or_empty":"The tax amount can not be zero or empty.","terms_conditions":"Terms & Conditions","the_privacy_policy_is_required":"The Privacy Policy is required.","the_terms_conditions_is_required":"The Terms & Conditions is required.","this_month":"This month","this_week":"This Week","thu":"THU","to":"To","today":"Today","too_long":"Too long","too_short":"Too short","tue":"TUE","type_number":"Type Number","update_quantity":"Update quantity should be less than previous quantity.","user":"User","validate_discount":"The discount should be less than the total amount","validate_doc_type":"The document must be a file of type: jpeg, jpg, png, pdf, doc, docx, webp","validate_facebook_url":"Please enter a valid Facebook URL","validate_from_title":"The from title is required","validate_image_size":"The document must be less than 10 mb","validate_image_type":"The image must be a file of type: jpg, jpeg, png.","validate_instagram_url":"Please enter a valid Instagram URL","validate_linkedin_url":"Please enter a valid Linkedin URL","validate_quantity":"Quantity should be greater than 0.","validate_tax":"Taxes should be less than 100%.","validate_to_title":"The to title is required.","validate_twitter_url":"Please enter a valid Twitter URL","value_must_be_greter_then":"Value must be greter then 1","wed":"WED","yearly_income_expense_chart":"Yearly Income Expense Chart","yes":"Yes","yesterday":"Yesterday","zoom":"Zoom"},"es.js":{"about_us_description_required":"El campo de descripci\u00f3n Acerca de nosotros no contiene solo espacios en blanco","about_us_mission_required":"Acerca de nosotros el campo misionero no contiene solo espacios en blanco","about_us_title_required":"El campo de t\u00edtulo Acerca de nosotros no contiene solo espacios en blanco","account":"Cuenta","all_notification_read_successfully":"Todas las notificaciones le\u00eddas correctamente","allow_file_type":"Tipos de archivos permitidos: png, jpg, jpeg.","amount":"Cantidad","apply":"Aplicar","appointment":"Cita","apr":"Abril","are_you_sure":"Estas seguro","are_you_sure_want_to_cancel":"Seguro que quieres cancelar","are_you_sure_want_to_change":"Estas seguro de querer cambiar ","are_you_sure_want_to_return_this_item":"\u00bfEst\u00e1s seguro de que quieres devolver este art\u00edculo?","aug":"Agosto","available_quantity":"Cantidad disponible","available_time_greater_than_zero":"El tiempo disponible desde debe ser mayor que cero","available_time_less_than_hospital_schedule_time":"El tiempo disponible para debe ser menor que el tiempo programado del hospital.","available_to_time_greater_than_zero":"El tiempo disponible para debe ser mayor que cero.","bed":"Cama","break_time_greater_than_zero":"El tiempo de ruptura debe ser mayor que cero","break_to_time_greater_than_from_time":"El tiempo de interrupci\u00f3n hasta debe ser mayor que el tiempo de interrupci\u00f3n desde.","break_to_time_greater_than_zero":"El tiempo de descanso debe ser mayor que cero.","cancel":"Cancelar","canceled":"Canceled","case":"Caso","case_id":"Identificaci\u00f3n del caso","change_status":"Cambiar Estado","changed_appointment":"Cita cambiada","charge":"Cargar","choose":"Elegir","complete_this_payment":"\u00a1\u00a1Quieres completar este Pago!!","custom":"Costumbre","date_required":"El campo de fecha es obligatorio.","dec":"Diciembre","delete_medicine":"Este medicamento ya se utiliza en las facturas de medicamentos, \u00bfseguro que deseas eliminarlo?","department":"Departamento","disconnect_or_reconnect":"Desconecta y vuelve a conectar tu calendario de Google.","doctor_schedule_not_available_on_this_date":"Horario m\u00e9dico no disponible esta fecha.","document_error":"El documento debe ser un archivo de tipo: jpeg, jpg, png, pdf, doc, docx.","employee":"Empleado","employee_payroll_deduction":"Las deducciones no pueden ser mayores que Salario b\u00e1sico + Asignaci\u00f3n","expenses":"Gastos","feb":"Febrero","field_required":"Se requiere campo.","flutterwave_public_key":"Clave p\u00fablica de Flutterwave","flutterwave_secret_key":"Flutterwave Secret Key","fri":"VIE","from":"De","google_meet":"Reuni\u00f3n de Google","has_been_cancelled":"ha sido cancelado.","has_been_changed":"Ha sido cambiado.","has_been_deleted":"ha sido eliminado.","holiday":"D\u00eda festivo","home_page_box_descriptions_required":"El campo de descripciones del cuadro de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_box_required":"El campo de t\u00edtulo del cuadro de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_certified_box_title_required":"El campo de t\u00edtulo del cuadro certificado de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_certified_description_required":"El campo de descripci\u00f3n certificado certificado de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_certified_doctor_description_required":"El campo de descripci\u00f3n del m\u00e9dico certificado de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_certified_required":"El campo de texto del m\u00e9dico certificado de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_certified_title_required":"p\u00e1gina de inicio m\u00e9dico certificado El campo de t\u00edtulo no contiene solo espacios en blanco","home_page_description_required":"El campo de descripci\u00f3n de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_experience_required":"El campo de experiencia de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_step_description_required":"El campo de descripci\u00f3n del paso 1 de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_step_four_description_required":"El campo de descripci\u00f3n del paso 4 de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_step_four_title_required":"El campo de t\u00edtulo del paso 4 de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_step_three_description_required":"El campo de descripci\u00f3n del paso 3 de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_step_three_title_required":"El campo de t\u00edtulo del paso 3 de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_step_title_required":"El campo de t\u00edtulo del paso 1 de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_step_two_description_required":"El campo de descripci\u00f3n del paso 2 de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_step_two_title_required":"El campo de t\u00edtulo del paso 2 de la p\u00e1gina de inicio no contiene solo espacios en blanco","home_page_title_required":"El campo de t\u00edtulo de la p\u00e1gina de inicio no contiene solo espacios en blanco","income":"Ingreso","invalid_country_code":"C\u00f3digo de pa\u00eds no v\u00e1lido","invalid_number":"N\u00famero invalido","ipd_operation":"operaci\u00f3n IPD","ipd_patient":"Paciente con ENI","item":"Art\u00edculo","item_name":"Nombre del \u00e1rticulo","item_returned":"Devuelto","jan":"Enero","july":"Julio","jun":"Junio","last_30_days":"\u00faltimos 30 d\u00edas","last_7_days":"Los \u00faltimos 7 d\u00edas","last_month":"El mes pasado","lot_number":"Introduzca el n\u00famero de lote","lunch_break":"Romper","make_payment":"Hacer el pago","mar":"Marzo","may":"Puede","medicine_bill":"Proyecto de ley de medicamentos","medicine_category":"Categor\u00eda de medicina","medicine_required":"Se requiere campo de medicina.","message_not_greater_than_160_characters":"El mensaje no podr\u00e1 tener m\u00e1s de 160 caracteres.","mon":"LUN","month":"Mes","n\/a":"N\/A","net_amount_not_empty":"El importe neto no puede estar vac\u00edo.","net_amount_not_zero":"El importe neto no puede ser cero.","no":"No","notification_read_successfully":"Notificaci\u00f3n le\u00edda con \u00e9xito","nov":"Noviembre","oct":"Octubre","ok":"De acuerdo","password_and_confirm_password_not_match":"Contrase\u00f1a y Confirmar contrase\u00f1a no coinciden.","patient_id_card_template":"Plantillas de tarjetas inteligentes para pacientes","patient_not_exists_or_status_is_not_active":"El paciente no existe o el estado no est\u00e1 activo.","patient_required":"El campo del paciente es obligatorio","payment_status_must_be_active":"El estado de pago debe estar activo.","paypal_client_id":"ID de cliente de PayPal","paypal_mode":"Modo PayPal","paypal_secret":"Secreto de PayPal","paystack_key":"Clave de pila de pago","paystack_secret_key":"Clave secreta de la pila de pago","please_fill_all_the_required_fields":"Por favor complete todos los campos requeridos.","please_select_appointment_time_slot":"Por favor seleccione el horario de la cita","please_select_doctor":"Por favor seleccione Doctor","please_select_doctor_department":"Por favor seleccione Departamento M\u00e9dico","price":"Precio","privacy_policy":"pol\u00edtica de privacidad","purchase_medicine":"Comprar Medicina","purchase_price":"Introduzca el precio de compra","qty":"Cantidad","quantity_cannot_be_zero":"La cantidad no puede ser cero ni estar vac\u00eda.","quantity_must_be_less_than_available_quantity":"La cantidad debe ser menor que la cantidad disponible.","quantity_required":"Por favor ingrese la cantidad.","razorpay_key":"Clave de pago de Razor","razorpay_secret":"Secreto de Razorpay","sale_price":"Precio de venta","sat":"SAT","saved_successfully":"saved successfully","schedule_time":"El tiempo disponible desde debe ser mayor que el horario del hospital","schedule_time_select":"Seleccione el tiempo por paciente","search":"Buscar","select_bed_type":"Seleccione tipo de cama","select_calendar":"Por favor seleccione un calendario.","select_category":"selecciona una categor\u00eda","select_charge_category":"Seleccionar categor\u00eda de cargo","select_doctor":"Seleccionar doctor","select_medicine":"Seleccionar Medicina","select_parameter_name":"Seleccione el nombre del par\u00e1metro","select_patient":"Seleccionar Paciente","select_user":"Seleccionar usuario","sep":"Septiembre","status":"Estado","stripe_key":"Clave de rayas","stripe_secret":"Secreto de rayas","sun":"SOL","tax_amount_not_zero_or_empty":"El monto del impuesto no puede ser cero ni estar vac\u00edo.","terms_conditions":"T\u00e9rminos y condiciones","the_privacy_policy_is_required":"La Pol\u00edtica de Privacidad es obligatoria.","the_terms_conditions_is_required":"Los T\u00e9rminos y condiciones son obligatorios.","this_month":"Este mes","this_week":"Esta semana","thu":"JUE","to":"A","today":"Hoy","too_long":"Demasiado largo","too_short":"Demasiado corta","tue":"MAR","type_number":"Teclea un n\u00famero","update_quantity":"La cantidad de actualizaci\u00f3n debe ser menor que la cantidad anterior.","user":"Usuaria","validate_discount":"El descuento debe ser menor que el monto total.","validate_doc_type":"El documento debe ser un archivo de tipo: jpeg, jpg, png, pdf, doc, docx, webp","validate_facebook_url":"Por favor ingresa una URL v\u00e1lida de Facebook","validate_from_title":"El t\u00edtulo de origen es obligatorio.","validate_image_size":"El documento debe tener menos de 10 mb.","validate_image_type":"La imagen debe ser un archivo de tipo: jpg, jpeg, png.","validate_instagram_url":"Por favor ingresa una URL de Instagram v\u00e1lida","validate_linkedin_url":"Por favor introduce una URL de Linkedin v\u00e1lida","validate_quantity":"La cantidad debe ser mayor que 0.","validate_tax":"Los impuestos deben ser inferiores al 100%.","validate_to_title":"El t\u00edtulo es obligatorio.","validate_twitter_url":"Por favor ingresa una URL de Twitter v\u00e1lida","value_must_be_greter_then":"Value must be greter then 1","wed":"CASARSE","yearly_income_expense_chart":"Cuadro de gastos de ingresos anuales","yes":"S\u00ed","yesterday":"Ayer","zoom":"Zoom"},"fr.js":{"about_us_description_required":"Le champ de description \u00c0 propos de nous ne contient pas uniquement des espaces blancs","about_us_mission_required":"\u00c0 propos de nous, le champ de mission ne contient pas uniquement des espaces blancs","about_us_title_required":"Le champ de titre \u00c0 propos de nous ne contient pas uniquement des espaces blancs","account":"Compte","all_notification_read_successfully":"Toutes les notifications ont \u00e9t\u00e9 lues avec succ\u00e8s","allow_file_type":"Types de fichiers autoris\u00e9s\u00a0: png, jpg, jpeg.","amount":"Montant","apply":"Appliquer","appointment":"Rendez-vous","apr":"Avril","are_you_sure":"Es-tu s\u00fbr?","are_you_sure_want_to_cancel":"\u00cates-vous s\u00fbr de vouloir annuler","are_you_sure_want_to_change":"\u00cates-vous s\u00fbr de vouloir changer","are_you_sure_want_to_return_this_item":"\u00cates-vous s\u00fbr de vouloir retourner cet article","aug":"Ao\u00fbt","available_quantity":"quantit\u00e9 disponible","available_time_greater_than_zero":"Le temps disponible \u00e0 partir de doit \u00eatre sup\u00e9rieur \u00e0 z\u00e9ro","available_time_less_than_hospital_schedule_time":"Le temps de disponibilit\u00e9 doit \u00eatre inf\u00e9rieur au temps pr\u00e9vu par l'h\u00f4pital.","available_to_time_greater_than_zero":"Le temps Disponible jusqu\u2019\u00e0 doit \u00eatre sup\u00e9rieur \u00e0 z\u00e9ro","bed":"Lit","break_time_greater_than_zero":"Le temps de rupture doit \u00eatre sup\u00e9rieur \u00e0 z\u00e9ro","break_to_time_greater_than_from_time":"Le temps de pause jusqu'\u00e0 doit \u00eatre sup\u00e9rieur au temps de pause depuis.","break_to_time_greater_than_zero":"Le temps de pause doit \u00eatre sup\u00e9rieur \u00e0 z\u00e9ro","cancel":"Annuler","canceled":"Annul\u00e9","case":"Cas","case_id":"Num\u00e9ro de cas","change_status":"Changer de statut","changed_appointment":"Rendez-vous modifi\u00e9","charge":"Charge","choose":"Choisir","complete_this_payment":"Vous souhaitez finaliser ce paiement !!","custom":"Coutume","date_required":"Le champ Date est obligatoire.","dec":"D\u00e9cembre","delete_medicine":"Ce m\u00e9dicament est d\u00e9j\u00e0 utilis\u00e9 dans les factures de m\u00e9dicaments, \u00eates-vous s\u00fbr de vouloir le supprimer\u00a0?","department":"D\u00e9partement","disconnect_or_reconnect":"Veuillez d\u00e9connecter et reconnecter votre agenda Google","doctor_schedule_not_available_on_this_date":"L'horaire du m\u00e9decin n'est pas disponible \u00e0 cette date.","document_error":"Le document doit \u00eatre un fichier de type : jpeg, jpg, png, pdf, doc, docx.","employee":"Employ\u00e9","employee_payroll_deduction":"Les retenues ne peuvent pas \u00eatre sup\u00e9rieures au Salaire de base + Allocation","expenses":"D\u00e9penses","feb":"F\u00e9vrier","field_required":"Champ requis.","flutterwave_public_key":"Cl\u00e9 publique Flutterwave","flutterwave_secret_key":"Cl\u00e9 secr\u00e8te Flutterwave","fri":"VEN","from":"Depuis","google_meet":"Google Rencontre","has_been_cancelled":"a \u00e9t\u00e9 annul\u00e9.","has_been_changed":"a \u00e9t\u00e9 modifi\u00e9.","has_been_deleted":"a \u00e9t\u00e9 supprim\u00e9.","holiday":"Holiday","home_page_box_descriptions_required":"Le champ de description des zones de la page d'accueil ne contient pas uniquement des espaces blancs.","home_page_box_required":"Le champ de titre de la zone de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_certified_box_title_required":"Le champ de titre de la bo\u00eete certifi\u00e9e de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_certified_description_required":"Le champ de description certifi\u00e9 certifi\u00e9 de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_certified_doctor_description_required":"Le champ de description du m\u00e9decin certifi\u00e9 de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_certified_required":"Le champ de texte du m\u00e9decin certifi\u00e9 de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_certified_title_required":"page d'accueil m\u00e9decin certifi\u00e9 Le champ du titre ne contient pas uniquement des espaces blancs","home_page_description_required":"Le champ de description de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_experience_required":"Le champ d'exp\u00e9rience de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_step_description_required":"Le champ de description de l'\u00e9tape 1 de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_step_four_description_required":"Le champ de description de l'\u00e9tape 4 de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_step_four_title_required":"Le champ de titre de l'\u00e9tape 4 de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_step_three_description_required":"Le champ de description de l'\u00e9tape 3 de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_step_three_title_required":"Le champ de titre de l'\u00e9tape 3 de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_step_title_required":"Le champ de titre de l'\u00e9tape 1 de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_step_two_description_required":"Le champ de description de l'\u00e9tape 2 de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_step_two_title_required":"Le champ de titre de l'\u00e9tape 2 de la page d'accueil ne contient pas uniquement des espaces blancs","home_page_title_required":"Le champ de titre de la page d'accueil ne contient pas uniquement des espaces blancs","income":"Revenu","invalid_country_code":"Code de pays invalide","invalid_number":"Num\u00e9ro invalide","ipd_operation":"Fonctionnement IPD","ipd_patient":"Patient IIP","item":"Article","item_name":"Nom de l'article","item_returned":"Revenu","jan":"Janvier","july":"Juillet","jun":"Juin","last_30_days":"Les 30 derniers jours","last_7_days":"Les 7 derniers jours","last_month":"Le mois dernier","lot_number":"Entrez le num\u00e9ro de lot","lunch_break":"Casser","make_payment":"Effectuer le paiement","mar":"Mars","may":"Peut","medicine_bill":"Facture de m\u00e9decine","medicine_category":"Cat\u00e9gorie de m\u00e9decine","medicine_required":"Le domaine m\u00e9decine est obligatoire.","message_not_greater_than_160_characters":"Le message ne peut pas d\u00e9passer 160 caract\u00e8res.","mon":"LUN","month":"Mois","n\/a":"N\/A","net_amount_not_empty":"Le montant net ne peut pas \u00eatre vide.","net_amount_not_zero":"Le montant net ne peut \u00eatre nul.","no":"Non","notification_read_successfully":"Notification lu avec succ\u00e8s","nov":"Novembre","oct":"Octobre","ok":"D'accord","password_and_confirm_password_not_match":"Le mot de passe et la confirmation du mot de passe ne correspondent pas.","patient_id_card_template":"Mod\u00e8les de cartes patient intelligentes","patient_not_exists_or_status_is_not_active":"Le patient n\u2019existe pas ou le statut n\u2019est pas actif.","patient_required":"Le champ Patient est obligatoire","payment_status_must_be_active":"Le statut de paiement doit \u00eatre actif.","paypal_client_id":"Identifiant client PayPal","paypal_mode":"Mode PayPal","paypal_secret":"Secret PayPal","paystack_key":"Cl\u00e9 de paie","paystack_secret_key":"Cl\u00e9 secr\u00e8te de la pile de paie","please_fill_all_the_required_fields":"Veuillez remplir tous les champs obligatoires.","please_select_appointment_time_slot":"Veuillez s\u00e9lectionner le cr\u00e9neau horaire du rendez-vous","please_select_doctor":"Veuillez s\u00e9lectionner Docteur","please_select_doctor_department":"Veuillez s\u00e9lectionner le d\u00e9partement du m\u00e9decin","price":"Prix","privacy_policy":"politique de confidentialit\u00e9","purchase_medicine":"Acheter des m\u00e9dicaments","purchase_price":"Entrez le prix d'achat","qty":"Qt\u00e9","quantity_cannot_be_zero":"La quantit\u00e9 ne peut pas \u00eatre nulle ou vide.","quantity_must_be_less_than_available_quantity":"La quantit\u00e9 doit \u00eatre inf\u00e9rieure \u00e0 la quantit\u00e9 disponible.","quantity_required":"Veuillez entrer la quantit\u00e9.","razorpay_key":"Cl\u00e9 Razorpay","razorpay_secret":"Secret de Razorpay","sale_price":"Prix \u200b\u200bde vente","sat":"ASSIS","saved_successfully":"enregistr\u00e9 avec succ\u00e8s","schedule_time":"L\u2019heure de disponibilit\u00e9 doit \u00eatre sup\u00e9rieure \u00e0 l\u2019heure pr\u00e9vue par l\u2019h\u00f4pital.","schedule_time_select":"Veuillez s\u00e9lectionner par temps de patient","search":"Recherche","select_bed_type":"S\u00e9lectionnez le type de lit","select_calendar":"Veuillez s\u00e9lectionner un calendrier.","select_category":"Choisir une cat\u00e9gorie","select_charge_category":"S\u00e9lectionnez la cat\u00e9gorie de frais","select_doctor":"S\u00e9lectionnez un m\u00e9decin","select_medicine":"S\u00e9lectionnez un m\u00e9dicament","select_parameter_name":"S\u00e9lectionnez le nom du param\u00e8tre","select_patient":"S\u00e9lectionner un patient","select_user":"S\u00e9lectionnez un utilisateur","sep":"Septembre","status":"Statut","stripe_key":"Cl\u00e9 \u00e0 rayures","stripe_secret":"Rayure secr\u00e8te","sun":"SOLEIL","tax_amount_not_zero_or_empty":"Le montant de la taxe ne peut pas \u00eatre nul ou vide.","terms_conditions":"termes et conditions","the_privacy_policy_is_required":"La politique de confidentialit\u00e9 est requise.","the_terms_conditions_is_required":"Les conditions g\u00e9n\u00e9rales sont requises.","this_month":"Ce mois-ci","this_week":"Cette semaine","thu":"JEU","to":"\u00c0","today":"Aujourd'hui","too_long":"Trop long","too_short":"Trop court","tue":"MAR","type_number":"Num\u00e9ro de type","update_quantity":"La quantit\u00e9 mise \u00e0 jour doit \u00eatre inf\u00e9rieure \u00e0 la quantit\u00e9 pr\u00e9c\u00e9dente.","user":"Utilisateur","validate_discount":"La remise doit \u00eatre inf\u00e9rieure au montant total","validate_doc_type":"Le document doit \u00eatre un fichier de type : jpeg, jpg, png, pdf, doc, docx, webp","validate_facebook_url":"Veuillez saisir une URL Facebook valide","validate_from_title":"Le titre de est requis","validate_image_size":"Le document doit faire moins de 10 Mo","validate_image_type":"L'image doit \u00eatre un fichier de type : jpg, jpeg, png.","validate_instagram_url":"Veuillez saisir une URL Instagram valide","validate_linkedin_url":"Veuillez saisir une URL Linkedin valide","validate_quantity":"La quantit\u00e9 doit \u00eatre sup\u00e9rieure \u00e0 0.","validate_tax":"Les taxes devraient \u00eatre inf\u00e9rieures \u00e0 100\u00a0%.","validate_to_title":"Le titre est obligatoire.","validate_twitter_url":"Veuillez saisir une URL Twitter valide","value_must_be_greter_then":"El valor debe ser mayor que 1","wed":"\u00c9POUSER","yearly_income_expense_chart":"Tableau des revenus et d\u00e9penses annuels","yes":"Oui","yesterday":"Hier","zoom":"Zoom"},"pt.js":{"about_us_description_required":"O campo de descri\u00e7\u00e3o sobre n\u00f3s n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","about_us_mission_required":"Sobre n\u00f3s, o campo mission\u00e1rio n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","about_us_title_required":"O campo de t\u00edtulo Sobre n\u00f3s n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","account":"Conta","all_notification_read_successfully":"Todas as notifica\u00e7\u00f5es lidas com sucesso","allow_file_type":"Tipos de arquivos permitidos: png, jpg, jpeg.","amount":"Quantia","apply":"Aplicar","appointment":"Encontro","apr":"abril","are_you_sure":"Tem certeza?","are_you_sure_want_to_cancel":"Tem certeza de que deseja cancelar","are_you_sure_want_to_change":"Tem certeza que deseja mudar ","are_you_sure_want_to_return_this_item":"Tem certeza de que deseja devolver este item","aug":"Agosto","available_quantity":"Quantidade dispon\u00edvel","available_time_greater_than_zero":"O tempo dispon\u00edvel desde deve ser maior que zero","available_time_less_than_hospital_schedule_time":"O tempo dispon\u00edvel para deve ser menor que o hor\u00e1rio programado no hospital","available_to_time_greater_than_zero":"O tempo dispon\u00edvel para deve ser maior que zero","bed":"Cama","break_time_greater_than_zero":"O tempo de intervalo deve ser maior que zero","break_to_time_greater_than_from_time":"O tempo Break To deve ser maior que o tempo Break From.","break_to_time_greater_than_zero":"O tempo de interrup\u00e7\u00e3o deve ser maior que zero","cancel":"Cancelar","canceled":"Cancelado","case":"Caso","case_id":"ID do caso","change_status":"Alterar status","changed_appointment":"Compromisso alterado","charge":"Cobrar","choose":"Escolher","complete_this_payment":"Voc\u00ea deseja concluir este pagamento!!","custom":"Personalizado","date_required":"O campo Data \u00e9 obrigat\u00f3rio.","dec":"dezembro","delete_medicine":"Este medicamento j\u00e1 \u00e9 utilizado nas faturas de medicamentos. Tem certeza de que deseja exclu\u00ed-lo?","department":"Departamento","disconnect_or_reconnect":"Desconecte e reconecte seu Google Agenda","doctor_schedule_not_available_on_this_date":"Agenda M\u00e9dica n\u00e3o dispon\u00edvel nesta data.","document_error":"O documento deve ser um arquivo do tipo: jpeg, jpg, png, pdf, doc, docx.","employee":"Funcion\u00e1rio","employee_payroll_deduction":"As dedu\u00e7\u00f5es n\u00e3o podem ser superiores ao sal\u00e1rio base + abono","expenses":"Despesas","feb":"Fevereiro","field_required":"campo \u00e9 obrigat\u00f3rio.","flutterwave_public_key":"Chave p\u00fablica Flutterwave","flutterwave_secret_key":"Chave secreta Flutterwave","fri":"SEX","from":"De","google_meet":"Google Meet","has_been_cancelled":"foi cancelado.","has_been_changed":"foi mudado.","has_been_deleted":"foi deletado.","holiday":"Holiday","home_page_box_descriptions_required":"O campo de descri\u00e7\u00f5es da caixa da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_box_required":"O campo do t\u00edtulo da caixa da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_certified_box_title_required":"O campo de t\u00edtulo da caixa certificada da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_certified_description_required":"O campo de descri\u00e7\u00e3o certificada da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_certified_doctor_description_required":"O campo de descri\u00e7\u00e3o do m\u00e9dico certificado na p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_certified_required":"O campo de texto do m\u00e9dico certificado na p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_certified_title_required":"m\u00e9dico certificado da p\u00e1gina inicial O campo do t\u00edtulo n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_description_required":"O campo de descri\u00e7\u00e3o da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_experience_required":"O campo de experi\u00eancia da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_step_description_required":"O campo de descri\u00e7\u00e3o da etapa 1 da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_step_four_description_required":"O campo de descri\u00e7\u00e3o da etapa 4 da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_step_four_title_required":"O campo de t\u00edtulo da etapa 4 da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_step_three_description_required":"O campo de descri\u00e7\u00e3o da etapa 3 da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_step_three_title_required":"O campo de t\u00edtulo da etapa 3 da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_step_title_required":"O campo de t\u00edtulo da etapa 1 da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_step_two_description_required":"O campo de descri\u00e7\u00e3o da etapa 2 da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_step_two_title_required":"O campo de t\u00edtulo da etapa 2 da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","home_page_title_required":"O campo do t\u00edtulo da p\u00e1gina inicial n\u00e3o cont\u00e9m apenas espa\u00e7os em branco","income":"Renda","invalid_country_code":"C\u00f3digo de pa\u00eds inv\u00e1lido","invalid_number":"N\u00famero inv\u00e1lido","ipd_operation":"Opera\u00e7\u00e3o IPD","ipd_patient":"Paciente com DPI","item":"Item","item_name":"Nome do item","item_returned":"Devolvido","jan":"Janeiro","july":"Julho","jun":"Junho","last_30_days":"\u00daltimos 30 dias","last_7_days":"\u00daltimos 7 dias","last_month":"M\u00eas passado","lot_number":"Insira o n\u00famero do lote","lunch_break":"Quebrar","make_payment":"Fa\u00e7a o pagamento","mar":"Marchar","may":"Poderia","medicine_bill":"Projeto de Lei de Medicamentos","medicine_category":"Categoria de Medicamentos","medicine_required":"A \u00e1rea de medicina \u00e9 obrigat\u00f3ria.","message_not_greater_than_160_characters":"A mensagem n\u00e3o pode ter mais de 160 caracteres.","mon":"SEG","month":"M\u00eas","n\/a":"N\/A","net_amount_not_empty":"O valor l\u00edquido n\u00e3o pode estar vazio.","net_amount_not_zero":"O valor l\u00edquido n\u00e3o pode ser zero.","no":"N\u00e3o","notification_read_successfully":"Notifica\u00e7\u00e3o lida com sucesso","nov":"novembro","oct":"Outubro","ok":"OK","password_and_confirm_password_not_match":"Senha e Confirmar senha n\u00e3o correspondem.","patient_id_card_template":"Modelos inteligentes de cart\u00e3o de paciente","patient_not_exists_or_status_is_not_active":"O paciente n\u00e3o existe ou o status n\u00e3o est\u00e1 ativo.","patient_required":"O campo paciente \u00e9 obrigat\u00f3rio","payment_status_must_be_active":"O status do pagamento deve estar ativo.","paypal_client_id":"ID do cliente PayPal","paypal_mode":"Modo PayPal","paypal_secret":"Segredo do PayPal","paystack_key":"Chave da pilha de pagamento","paystack_secret_key":"Chave secreta da pilha de pagamento","please_fill_all_the_required_fields":"Por favor preencha todos os campos obrigat\u00f3rios.","please_select_appointment_time_slot":"Selecione o hor\u00e1rio do agendamento","please_select_doctor":"Por favor selecione M\u00e9dico","please_select_doctor_department":"Por favor selecione Departamento M\u00e9dico","price":"Pre\u00e7o","privacy_policy":"pol\u00edtica de Privacidade","purchase_medicine":"Comprar rem\u00e9dio","purchase_price":"Insira o pre\u00e7o de compra","qty":"Quantidade","quantity_cannot_be_zero":"A quantidade n\u00e3o pode ser zero ou vazia.","quantity_must_be_less_than_available_quantity":"A quantidade deve ser menor que a quantidade dispon\u00edvel.","quantity_required":"Por favor insira a quantidade.","razorpay_key":"Chave Razorpay","razorpay_secret":"Segredo Razorpay","sale_price":"Pre\u00e7o de venda","sat":"SENTADO","saved_successfully":"Salvo com sucesso","schedule_time":"O hor\u00e1rio dispon\u00edvel desde deve ser maior que o hor\u00e1rio agendado no hospital","schedule_time_select":"Selecione o tempo por paciente","search":"Procurar","select_bed_type":"Selecione o tipo de cama","select_calendar":"Selecione um calend\u00e1rio.","select_category":"Selecione a Categoria","select_charge_category":"Selecione a categoria de cobran\u00e7a","select_doctor":"Selecione M\u00e9dico","select_medicine":"Selecione o medicamento","select_parameter_name":"Selecione o nome do par\u00e2metro","select_patient":"Selecione Paciente","select_user":"Selecione o usu\u00e1rio","sep":"Setembro","status":"Status","stripe_key":"Chave de listra","stripe_secret":"Segredo de listra","sun":"SOL","tax_amount_not_zero_or_empty":"O valor do imposto n\u00e3o pode ser zero ou vazio.","terms_conditions":"termos e Condi\u00e7\u00f5es","the_privacy_policy_is_required":"A Pol\u00edtica de Privacidade \u00e9 obrigat\u00f3ria.","the_terms_conditions_is_required":"Os Termos e Condi\u00e7\u00f5es s\u00e3o obrigat\u00f3rios.","this_month":"Este m\u00eas","this_week":"Essa semana","thu":"QUI","to":"Para","today":"Hoje","too_long":"Demasiado longo","too_short":"Muito curto","tue":"TER","type_number":"Digite N\u00famero","update_quantity":"A quantidade atualizada deve ser menor que a quantidade anterior.","user":"Do utilizador","validate_discount":"O desconto deve ser menor que o valor total","validate_doc_type":"O documento deve ser um arquivo do tipo: jpeg, jpg, png, pdf, doc, docx, webp","validate_facebook_url":"Insira um URL v\u00e1lido do Facebook","validate_from_title":"O t\u00edtulo from \u00e9 obrigat\u00f3rio","validate_image_size":"O documento deve ter menos de 10 MB","validate_image_type":"A imagem deve ser um arquivo do tipo: jpg, jpeg, png.","validate_instagram_url":"Insira um URL v\u00e1lido do Instagram","validate_linkedin_url":"Por favor insira um URL v\u00e1lido do Linkedin","validate_quantity":"A quantidade deve ser maior que 0.","validate_tax":"Os impostos devem ser inferiores a 100%.","validate_to_title":"O t\u00edtulo to \u00e9 obrigat\u00f3rio.","validate_twitter_url":"Insira um URL v\u00e1lido do Twitter","value_must_be_greter_then":"O valor deve ser maior que 1","wed":"QUA","yearly_income_expense_chart":"Gr\u00e1fico de despesas de renda anual","yes":"Sim","yesterday":"Ontem","zoom":"Amplia\u00e7\u00e3o"},"ru.js":{"about_us_description_required":"\u041f\u043e\u043b\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u00ab\u041e \u043d\u0430\u0441\u00bb \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","about_us_mission_required":"\u041e \u043d\u0430\u0441 \u041f\u043e\u043b\u0435 \u043c\u0438\u0441\u0441\u0438\u0438 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432","about_us_title_required":"\u041f\u043e\u043b\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u00ab\u041e \u043d\u0430\u0441\u00bb \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","account":"\u0421\u0447\u0435\u0442","all_notification_read_successfully":"\u0412\u0441\u0435 \u0443\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u044b","allow_file_type":"\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0435 \u0442\u0438\u043f\u044b \u0444\u0430\u0439\u043b\u043e\u0432: png, jpg, jpeg.","amount":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e","apply":"\u041f\u0440\u0438\u043c\u0435\u043d\u044f\u0442\u044c","appointment":"\u0412\u0441\u0442\u0440\u0435\u0447\u0430","apr":"\u0430\u043f\u0440\u0435\u043b\u044c","are_you_sure":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b?","are_you_sure_want_to_cancel":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c?","are_you_sure_want_to_change":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c ","are_you_sure_want_to_return_this_item":"\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0432\u0435\u0440\u043d\u0443\u0442\u044c \u044d\u0442\u043e\u0442 \u0442\u043e\u0432\u0430\u0440?","aug":"\u0410\u0432\u0433\u0443\u0441\u0442","available_quantity":"\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e","available_time_greater_than_zero":"\u0412\u0440\u0435\u043c\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u0438 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f.","available_time_less_than_hospital_schedule_time":"\u0412\u0440\u0435\u043c\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u0438 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0431\u043e\u043b\u044c\u043d\u0438\u0446\u044b.","available_to_time_greater_than_zero":"\u0412\u0440\u0435\u043c\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u0438 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f.","bed":"\u041a\u0440\u043e\u0432\u0430\u0442\u044c","break_time_greater_than_zero":"\u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0440\u0435\u0440\u044b\u0432\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f.","break_to_time_greater_than_from_time":"\u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0440\u0435\u0440\u044b\u0432\u0430 \u0434\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043f\u0435\u0440\u0435\u0440\u044b\u0432\u0430.","break_to_time_greater_than_zero":"\u0412\u0440\u0435\u043c\u044f \u043f\u0435\u0440\u0435\u0440\u044b\u0432\u0430 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f.","cancel":"\u041e\u0442\u043c\u0435\u043d\u0430","canceled":"\u041e\u0442\u043c\u0435\u043d\u0435\u043d\u043e","case":"\u0421\u043b\u0443\u0447\u0430\u0439","case_id":"\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u0435\u043b\u0430","change_status":"\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441","changed_appointment":"\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u043e \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435","charge":"\u0417\u0430\u0440\u044f\u0436\u0430\u0442\u044c","choose":"\u0412\u044b\u0431\u0438\u0440\u0430\u0442\u044c","complete_this_payment":"\u0412\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u043f\u043b\u0430\u0442\u0435\u0436!!","custom":"\u041e\u0431\u044b\u0447\u0430\u0439","date_required":"\u041f\u043e\u043b\u0435 \u0434\u0430\u0442\u044b \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","dec":"\u0414\u0435\u043a\u0430\u0431\u0440\u044c","delete_medicine":"\u042d\u0442\u043e \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0441\u0447\u0435\u0442\u0430\u0445 \u0437\u0430 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430. \u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0435\u0433\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c?","department":"\u041e\u0442\u0434\u0435\u043b\u0435\u043d\u0438\u0435","disconnect_or_reconnect":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u0438 \u0441\u043d\u043e\u0432\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c Google.","doctor_schedule_not_available_on_this_date":"\u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432\u0440\u0430\u0447\u0435\u0439 \u043d\u0430 \u044d\u0442\u0443 \u0434\u0430\u0442\u0443 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e.","document_error":"\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c \u0441\u043e\u0431\u043e\u0439 \u0444\u0430\u0439\u043b \u0442\u0438\u043f\u0430: jpeg, jpg, png, pdf, doc, docx.","employee":"\u0421\u043e\u0442\u0440\u0443\u0434\u043d\u0438\u043a","employee_payroll_deduction":"\u0412\u044b\u0447\u0435\u0442\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c \u0431\u0430\u0437\u043e\u0432\u0443\u044e \u0437\u0430\u0440\u043f\u043b\u0430\u0442\u0443 + \u043d\u0430\u0434\u0431\u0430\u0432\u043a\u0443.","expenses":"\u0417\u0430\u0442\u0440\u0430\u0442\u044b","feb":"\u0444\u0435\u0432\u0440\u0430\u043b\u044c","field_required":"\u041f\u043e\u043b\u0435, \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.","flutterwave_public_key":"\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u043a\u043b\u044e\u0447 \u0424\u043b\u0430\u0442\u0442\u0435\u0440\u0432\u0435\u0439\u0432\u0430","flutterwave_secret_key":"\u0421\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0424\u043b\u0430\u0442\u0442\u0435\u0440\u0432\u0435\u0439\u0432\u0430","fri":"\u041f\u0422","from":"\u041e\u0442","google_meet":"Google \u0412\u0441\u0442\u0440\u0435\u0447\u0430","has_been_cancelled":"\u0431\u044b\u043b \u043e\u0442\u043c\u0435\u043d\u0435\u043d.","has_been_changed":"\u0431\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0435\u043d.","has_been_deleted":"\u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d.","holiday":"\u041f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u044b\u0439 \u0434\u0435\u043d\u044c","home_page_box_descriptions_required":"\u041f\u043e\u043b\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043f\u043e\u043b\u044f \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","home_page_box_required":"\u041f\u043e\u043b\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u043e\u043a\u043d\u0430 \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432","home_page_certified_box_title_required":"\u041f\u043e\u043b\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044f \u043d\u0430 \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","home_page_certified_description_required":"\u041f\u043e\u043b\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043d\u0430 \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","home_page_certified_doctor_description_required":"\u041f\u043e\u043b\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0432\u0440\u0430\u0447\u0430 \u043d\u0430 \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","home_page_certified_required":"\u0422\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0435 \u043f\u043e\u043b\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0432\u0440\u0430\u0447\u0430 \u043d\u0430 \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","home_page_certified_title_required":"\u0434\u043e\u043c\u0430\u0448\u043d\u044f\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0432\u0440\u0430\u0447 \u041f\u043e\u043b\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432","home_page_description_required":"\u041f\u043e\u043b\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432","home_page_experience_required":"\u041f\u043e\u043b\u0435 \u043e\u043f\u044b\u0442\u0430 \u043d\u0430 \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432","home_page_step_description_required":"\u041f\u043e\u043b\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0448\u0430\u0433\u0430\u00a01 \u043d\u0430 \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","home_page_step_four_description_required":"\u041f\u043e\u043b\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0448\u0430\u0433\u0430\u00a04 \u043d\u0430 \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","home_page_step_four_title_required":"\u041f\u043e\u043b\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u0448\u0430\u0433\u0430\u00a04 \u043d\u0430 \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","home_page_step_three_description_required":"\u041f\u043e\u043b\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0448\u0430\u0433\u0430\u00a03 \u043d\u0430 \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","home_page_step_three_title_required":"\u041f\u043e\u043b\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u0448\u0430\u0433\u0430\u00a03 \u043d\u0430 \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","home_page_step_title_required":"\u041f\u043e\u043b\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u0448\u0430\u0433\u0430 1 \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432","home_page_step_two_description_required":"\u041f\u043e\u043b\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0448\u0430\u0433\u0430\u00a02 \u043d\u0430 \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","home_page_step_two_title_required":"\u041f\u043e\u043b\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u0448\u0430\u0433\u0430\u00a02 \u043d\u0430 \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432.","home_page_title_required":"\u041f\u043e\u043b\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 \u0434\u043e\u043c\u0430\u0448\u043d\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u0432","income":"\u0414\u043e\u0445\u043e\u0434","invalid_country_code":"\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b","invalid_number":"\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440","ipd_operation":"\u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0418\u041f\u0414","ipd_patient":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442 \u0418\u041f\u0417","item":"\u042d\u043b\u0435\u043c\u0435\u043d\u0442","item_name":"\u0418\u043c\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430","item_returned":"\u0412\u0435\u0440\u043d\u0443\u043b\u0441\u044f","jan":"\u044f\u043d\u0432\u0430\u0440\u044c","july":"\u0418\u044e\u043b\u044c","jun":"\u0418\u044e\u043d\u044c","last_30_days":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 30 \u0434\u043d\u0435\u0439","last_7_days":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 7\u00a0\u0434\u043d\u0435\u0439","last_month":"\u041f\u0440\u043e\u0448\u043b\u044b\u0439 \u043c\u0435\u0441\u044f\u0446","lot_number":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 \u043b\u043e\u0442\u0430","lunch_break":"\u041f\u0435\u0440\u0435\u0440\u044b\u0432","make_payment":"\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u043e\u043f\u043b\u0430\u0442\u0443","mar":"\u041c\u0430\u0440\u0448\u0438\u0440\u043e\u0432\u0430\u0442\u044c","may":"\u041c\u043e\u0436\u0435\u0442","medicine_bill":"\u0421\u0447\u0435\u0442 \u0437\u0430 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u0430","medicine_category":"\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043c\u0435\u0434\u0438\u0446\u0438\u043d\u044b","medicine_required":"\u041c\u0435\u0434\u0438\u0446\u0438\u043d\u0441\u043a\u043e\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e.","message_not_greater_than_160_characters":"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c 160 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432.","mon":"\u041f\u041d","month":"\u041c\u0435\u0441\u044f\u0446","n\/a":"\u041d\/\u0414","net_amount_not_empty":"\u0427\u0438\u0441\u0442\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.","net_amount_not_zero":"\u0427\u0438\u0441\u0442\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u043e\u0439.","no":"\u041d\u0435\u0442","notification_read_successfully":"\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e","nov":"\u043d\u043e\u044f\u0431\u0440\u044c","oct":"\u041e\u043a\u0442\u044f\u0431\u0440\u044c","ok":"\u0425\u043e\u0440\u043e\u0448\u043e","password_and_confirm_password_not_match":"\u041f\u0430\u0440\u043e\u043b\u044c \u0438 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u043e\u043b\u044f \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442.","patient_id_card_template":"\u0428\u0430\u0431\u043b\u043e\u043d\u044b \u0441\u043c\u0430\u0440\u0442-\u043a\u0430\u0440\u0442\u043e\u0447\u0435\u043a \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u043e\u0432","patient_not_exists_or_status_is_not_active":"\u041f\u0430\u0446\u0438\u0435\u043d\u0442 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043b\u0438 \u0441\u0442\u0430\u0442\u0443\u0441 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0435\u043d.","patient_required":"\u041f\u043e\u043b\u0435 \u00ab\u041f\u0430\u0446\u0438\u0435\u043d\u0442\u00bb \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e","payment_status_must_be_active":"\u0421\u0442\u0430\u0442\u0443\u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c.","paypal_client_id":"\u041f\u043e\u043b\u043e\u0441\u0430 \u0421\u0435\u043a\u0440\u0435\u0442","paypal_mode":"\u0420\u0435\u0436\u0438\u043c PayPal","paypal_secret":"\u0421\u0435\u043a\u0440\u0435\u0442 PayPal","paystack_key":"\u041a\u043b\u044e\u0447 \u0441\u0442\u0435\u043a\u0430 \u0432\u044b\u043f\u043b\u0430\u0442","paystack_secret_key":"\u0421\u0435\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 Paystack","please_fill_all_the_required_fields":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0432\u0441\u0435 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u043e\u043b\u044f.","please_select_appointment_time_slot":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0432\u0441\u0442\u0440\u0435\u0447\u0438","please_select_doctor":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0414\u043e\u043a\u0442\u043e\u0440","please_select_doctor_department":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0442\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0432\u0440\u0430\u0447\u0430","price":"\u0426\u0435\u043d\u0430","privacy_policy":"\u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0434\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438","purchase_medicine":"\u041a\u0443\u043f\u0438\u0442\u044c \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e","purchase_price":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0446\u0435\u043d\u0443 \u043f\u043e\u043a\u0443\u043f\u043a\u0438","qty":"\u041a\u043e\u043b-\u0432\u043e","quantity_cannot_be_zero":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u044b\u043c \u0438\u043b\u0438 \u043f\u0443\u0441\u0442\u044b\u043c.","quantity_must_be_less_than_available_quantity":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0433\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430.","quantity_required":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e.","razorpay_key":"\u041a\u043b\u044e\u0447 \u0411\u0440\u0438\u0442\u0432\u044b","razorpay_secret":"\u0421\u0435\u043a\u0440\u0435\u0442 Razorpay","sale_price":"\u0426\u0435\u043d\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0438","sat":"\u0421\u0418\u0414\u0415\u041b","saved_successfully":"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e","schedule_time":"\u0412\u0440\u0435\u043c\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u0438 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435, \u0447\u0435\u043c \u0432\u0440\u0435\u043c\u044f \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0431\u043e\u043b\u044c\u043d\u0438\u0446\u044b.","schedule_time_select":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0440\u0435\u043c\u044f \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","search":"\u041f\u043e\u0438\u0441\u043a","select_bed_type":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043a\u0440\u043e\u0432\u0430\u0442\u0438","select_calendar":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c.","select_category":"\u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e","select_charge_category":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u0437\u0430\u0440\u044f\u0434\u0430","select_doctor":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0440\u0430\u0447\u0430","select_medicine":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043b\u0435\u043a\u0430\u0440\u0441\u0442\u0432\u043e","select_parameter_name":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u043c\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430","select_patient":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u0446\u0438\u0435\u043d\u0442\u0430","select_user":"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f","sep":"\u0421\u0435\u043d\u0442\u044f\u0431\u0440\u044c","status":"\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u0435\u043b","stripe_key":"\u041f\u043e\u043b\u043e\u0441\u0430\u0442\u044b\u0439 \u043a\u043b\u044e\u0447","stripe_secret":"\u041f\u043e\u043b\u043e\u0441\u0430 \u0421\u0435\u043a\u0440\u0435\u0442","sun":"\u0421\u041e\u041b\u041d\u0426\u0415","tax_amount_not_zero_or_empty":"\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u043e\u0433\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0438\u043b\u0438 \u043f\u0443\u0441\u0442\u043e\u0439.","terms_conditions":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f","the_privacy_policy_is_required":"\u041f\u043e\u043b\u0438\u0442\u0438\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0434\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u0430.","the_terms_conditions_is_required":"\u0423\u0441\u043b\u043e\u0432\u0438\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044f\u0432\u043b\u044f\u044e\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.","this_month":"\u042d\u0442\u043e\u0442 \u043c\u0435\u0441\u044f\u0446","this_week":"\u041d\u0430 \u044d\u0442\u043e\u0439 \u043d\u0435\u0434\u0435\u043b\u0435","thu":"\u0427\u0422","to":"\u041a","today":"\u0421\u0435\u0433\u043e\u0434\u043d\u044f","too_long":"Too long","too_short":"\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439","tue":"\u0412\u0422","type_number":"\u0422\u0438\u043f \u041d\u043e\u043c\u0435\u0440","update_quantity":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0439 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e.","user":"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c","validate_discount":"\u0421\u043a\u0438\u0434\u043a\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u043e\u0431\u0449\u0435\u0439 \u0441\u0443\u043c\u043c\u044b.","validate_doc_type":"\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c \u0441\u043e\u0431\u043e\u0439 \u0444\u0430\u0439\u043b \u0442\u0438\u043f\u0430: jpeg, jpg, png, pdf, doc, docx, webp.","validate_facebook_url":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL-\u0430\u0434\u0440\u0435\u0441 Facebook","validate_from_title":"\u0421\u0435\u043a\u0440\u0435\u0442 Razorpay","validate_image_size":"\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 10 \u041c\u0411.","validate_image_type":"\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0444\u0430\u0439\u043b\u043e\u043c \u0442\u0438\u043f\u0430: jpg, jpeg, png.","validate_instagram_url":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL-\u0430\u0434\u0440\u0435\u0441 Instagram","validate_linkedin_url":"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL-\u0430\u0434\u0440\u0435\u0441 Linkedin.","validate_quantity":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 0.","validate_tax":"\u041d\u0430\u043b\u043e\u0433\u0438 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 100%.","validate_to_title":"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a.","validate_twitter_url":"\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 URL-\u0430\u0434\u0440\u0435\u0441 Twitter","value_must_be_greter_then":"\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 1","wed":"\u041e\u0411\u0412\u0415\u041d\u0427\u0410\u041b\u0418\u0421\u042c","yearly_income_expense_chart":"\u0413\u043e\u0434\u043e\u0432\u043e\u0439 \u0433\u0440\u0430\u0444\u0438\u043a \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0438 \u0440\u0430\u0441\u0445\u043e\u0434\u043e\u0432","yes":"\u0414\u0430","yesterday":"\u0412\u0447\u0435\u0440\u0430","zoom":"\u0423\u0432\u0435\u043b\u0438\u0447\u0438\u0442\u044c"},"tr.js":{"about_us_description_required":"Hakk\u0131m\u0131zda a\u00e7\u0131klama alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermemektedir","about_us_mission_required":"Hakk\u0131m\u0131zda g\u00f6rev alan\u0131 sadece bo\u015fluklardan ibaret de\u011fildir","about_us_title_required":"Hakk\u0131m\u0131zda ba\u015fl\u0131k alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermemektedir","account":"Hesap","all_notification_read_successfully":"T\u00fcm Bildirimler ba\u015far\u0131yla okundu","allow_file_type":"\u0130zin verilen dosya t\u00fcrleri: png, jpg, jpeg.","amount":"Miktar","apply":"Uygula","appointment":"Randevu","apr":"Nisan","are_you_sure":"Emin misin?","are_you_sure_want_to_cancel":"\u0130ptal etmek istedi\u011fine emin misin","are_you_sure_want_to_change":"De\u011fi\u015ftirmek istedi\u011finden emin misin ","are_you_sure_want_to_return_this_item":"Bu \u00fcr\u00fcn\u00fc iade etmek istedi\u011finizden emin misiniz?","aug":"A\u011fustos","available_quantity":"Mevcut Miktar\u0131","available_time_greater_than_zero":"Kullan\u0131labilir Ba\u015flang\u0131\u00e7 \u200b\u200bZaman\u0131 S\u0131f\u0131rdan b\u00fcy\u00fck olmal\u0131d\u0131r","available_time_less_than_hospital_schedule_time":"Uygunluk s\u00fcresi hastanenin program s\u00fcresinden daha az olmal\u0131d\u0131r","available_to_time_greater_than_zero":"Kullan\u0131labilirlik s\u00fcresi S\u0131f\u0131rdan b\u00fcy\u00fck olmal\u0131d\u0131r","bed":"Yatak","break_time_greater_than_zero":"Break From zaman\u0131 S\u0131f\u0131rdan b\u00fcy\u00fck olmal\u0131d\u0131r","break_to_time_greater_than_from_time":"Mola zaman\u0131, Break From zaman\u0131ndan b\u00fcy\u00fck olmal\u0131d\u0131r.","break_to_time_greater_than_zero":"Mola S\u00fcresi S\u0131f\u0131rdan b\u00fcy\u00fck olmal\u0131d\u0131r","cancel":"\u0130ptal etmek","canceled":"\u0130ptal edildi","case":"Dava","case_id":"dava numaras\u0131","change_status":"Durum de\u011fi\u015ftirmek","changed_appointment":"Randevu De\u011fi\u015ftirildi","charge":"\u015earj","choose":"Se\u00e7mek","complete_this_payment":"Bu \u00d6demeyi tamamlamak istiyorsunuz!!","custom":"Gelenek","date_required":"Tarih alan\u0131 zorunludur.","dec":"Aral\u0131k","delete_medicine":"Bu ila\u00e7 zaten ila\u00e7 faturalar\u0131nda kullan\u0131l\u0131yor, silmek istedi\u011finizden emin misiniz?","department":"Departman","disconnect_or_reconnect":"L\u00fctfen Google takviminizin ba\u011flant\u0131s\u0131n\u0131 kesin ve yeniden ba\u011flay\u0131n","doctor_schedule_not_available_on_this_date":"Doktor Program\u0131 bu tarihte mevcut de\u011fil.","document_error":"Belge \u015fu t\u00fcrde bir dosya olmal\u0131d\u0131r: jpeg, jpg, png, pdf, doc, docx.","employee":"\u00c7al\u0131\u015fan","employee_payroll_deduction":"Kesintiler Temel maa\u015f + Har\u00e7l\u0131k tutar\u0131ndan fazla olamaz","expenses":"Masraflar","feb":"\u015eubat","field_required":"alan gereklidir.","flutterwave_public_key":"Flutterwave Genel Anahtar\u0131","flutterwave_secret_key":"Flutterwave Gizli Anahtar\u0131","fri":"Cuma","from":"\u0130tibaren","google_meet":"Google Meet","has_been_cancelled":"iptal edildi.","has_been_changed":"de\u011fi\u015ftirildi.","has_been_deleted":"silindi.","holiday":"Tatil","home_page_box_descriptions_required":"Ana sayfa kutusu a\u00e7\u0131klamalar\u0131 alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_box_required":"Ana sayfa kutusu ba\u015fl\u0131k alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_certified_box_title_required":"Ana sayfa sertifikal\u0131 kutu ba\u015fl\u0131k alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_certified_description_required":"Ana sayfa sertifikal\u0131 sertifikal\u0131 a\u00e7\u0131klama alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_certified_doctor_description_required":"Ana sayfa sertifikal\u0131 doktor a\u00e7\u0131klama alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermemektedir","home_page_certified_required":"Ana sayfa sertifikal\u0131 doktor metin alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermemektedir","home_page_certified_title_required":"ana sayfa sertifikal\u0131 doktor Unvan alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermemektedir","home_page_description_required":"Ana sayfa a\u00e7\u0131klama alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_experience_required":"Ana sayfa deneyim alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_step_description_required":"Ana sayfa ad\u0131m 1 a\u00e7\u0131klama alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_step_four_description_required":"Ana sayfa ad\u0131m 4 a\u00e7\u0131klama alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_step_four_title_required":"Ana sayfa ad\u0131m 4 ba\u015fl\u0131k alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_step_three_description_required":"Ana sayfa 3. ad\u0131m a\u00e7\u0131klama alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_step_three_title_required":"Ana sayfa ad\u0131m 3 ba\u015fl\u0131k alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_step_title_required":"Ana sayfa ad\u0131m 1 ba\u015fl\u0131k alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_step_two_description_required":"Ana sayfa ad\u0131m 2 a\u00e7\u0131klama alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_step_two_title_required":"Ana sayfa ad\u0131m 2 ba\u015fl\u0131k alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","home_page_title_required":"Ana sayfa ba\u015fl\u0131k alan\u0131 yaln\u0131zca bo\u015fluk i\u00e7ermiyor","income":"Gelir","invalid_country_code":"Ge\u00e7ersiz \u00fclke kodu","invalid_number":"Ge\u00e7ersiz numara","ipd_operation":"IPD i\u015flemi","ipd_patient":"IPD Hastas\u0131","item":"\u00d6\u011fe","item_name":"\u00d6\u011fe ad\u0131","item_returned":"\u0130ade","jan":"Ocak","july":"Temmuz","jun":"Haziran","last_30_days":"Son 30 g\u00fcn","last_7_days":"Son 7 g\u00fcn","last_month":"Ge\u00e7en ay","lot_number":"Lot numaras\u0131n\u0131 girin","lunch_break":"K\u0131rmak","make_payment":"\u00d6deme yapmak","mar":"Mart","may":"May\u0131s","medicine_bill":"\u0130la\u00e7 Yasas\u0131","medicine_category":"\u0130la\u00e7 Kategorisi","medicine_required":"T\u0131p alan\u0131 zorunludur.","message_not_greater_than_160_characters":"Mesaj 160 karakterden uzun olamaz.","mon":"PZT","month":"Ay","n\/a":"Yok","net_amount_not_empty":"Net tutar bo\u015f olamaz.","net_amount_not_zero":"Net tutar s\u0131f\u0131r olamaz.","no":"HAYIR","notification_read_successfully":"Bildirim ba\u015far\u0131yla okundu","nov":"Kas\u0131m","oct":"Ekim","ok":"Tamam","password_and_confirm_password_not_match":"\u015eifre ve \u015eifreyi onayla e\u015fle\u015fmiyor.","patient_id_card_template":"Ak\u0131ll\u0131 Hasta Kart\u0131 \u015eablonlar\u0131","patient_not_exists_or_status_is_not_active":"Hasta mevcut de\u011fil veya durumu aktif de\u011fil.","patient_required":"Hasta alan\u0131 zorunludur","payment_status_must_be_active":"\u00d6deme Durumu aktif olmal\u0131d\u0131r.","paypal_client_id":"PayPal M\u00fc\u015fteri Kimli\u011fi","paypal_mode":"PayPal Modu","paypal_secret":"PayPal S\u0131rr\u0131","paystack_key":"Paystack Anahtar\u0131","paystack_secret_key":"Paystack Gizli Anahtar\u0131","please_fill_all_the_required_fields":"L\u00fctfen gerekli t\u00fcm alanlar\u0131 doldurun.","please_select_appointment_time_slot":"L\u00fctfen randevu saat aral\u0131\u011f\u0131n\u0131 se\u00e7in","please_select_doctor":"L\u00fctfen Doktor se\u00e7iniz","please_select_doctor_department":"L\u00fctfen Doktor B\u00f6l\u00fcm\u00fcn\u00fc se\u00e7iniz","price":"Fiyat","privacy_policy":"Gizlilik Politikas\u0131","purchase_medicine":"\u0130la\u00e7 Sat\u0131n Al\u0131n","purchase_price":"Sat\u0131n alma fiyat\u0131n\u0131 girin","qty":"Adet","quantity_cannot_be_zero":"Miktar s\u0131f\u0131r veya bo\u015f olamaz.","quantity_must_be_less_than_available_quantity":"Miktar, Mevcut miktardan az olmal\u0131d\u0131r.","quantity_required":"L\u00fctfen miktar\u0131 giriniz.","razorpay_key":"Razorpay Anahtar\u0131","razorpay_secret":"Razorpay S\u0131rr\u0131","sale_price":"Sat\u0131\u015f \u00fccreti","sat":"DOYGUNLUK","saved_successfully":"Ba\u015far\u0131yla kaydedildi","schedule_time":"Uygun Ba\u015flang\u0131\u00e7 \u200b\u200bzaman\u0131 hastanenin program zaman\u0131ndan daha b\u00fcy\u00fck olmal\u0131d\u0131r","schedule_time_select":"L\u00fctfen hasta zaman\u0131na g\u00f6re se\u00e7in","search":"Aramak","select_bed_type":"Yatak Tipini Se\u00e7in","select_calendar":"L\u00fctfen bir takvim se\u00e7in.","select_category":"Kategori se\u00e7","select_charge_category":"\u00dccret Kategorisini Se\u00e7in","select_doctor":"Doktor Se\u00e7in","select_medicine":"T\u0131p Se\u00e7iniz","select_parameter_name":"Parametre Ad\u0131n\u0131 Se\u00e7in","select_patient":"Hasta Se\u00e7","select_user":"Kullan\u0131c\u0131 se\u00e7","sep":"Eyl\u00fcl","status":"Durum","stripe_key":"\u015eerit Anahtar\u0131","stripe_secret":"\u015eerit S\u0131rr\u0131","sun":"G\u00dcNE\u015e","tax_amount_not_zero_or_empty":"Vergi tutar\u0131 s\u0131f\u0131r veya bo\u015f olamaz.","terms_conditions":"\u015fartlar ve ko\u015fullar","the_privacy_policy_is_required":"Gizlilik Politikas\u0131 gereklidir.","the_terms_conditions_is_required":"\u015eartlar ve Ko\u015fullar gereklidir.","this_month":"Bu ay","this_week":"Bu hafta","thu":"per\u015f","to":"\u0130le","today":"Bug\u00fcn","too_long":"\u00c7ok uzun","too_short":"\u00c7ok k\u0131sa","tue":"SALI","type_number":"Numara giriniz","update_quantity":"G\u00fcncelleme miktar\u0131 \u00f6nceki miktardan az olmal\u0131d\u0131r.","user":"Kullan\u0131c\u0131","validate_discount":"The discount should be less than the total amount","validate_doc_type":"Belge \u015fu t\u00fcrde bir dosya olmal\u0131d\u0131r: jpeg, jpg, png, pdf, doc, docx, webp","validate_facebook_url":"L\u00fctfen ge\u00e7erli bir Facebook URL'si girin","validate_from_title":"G\u00f6nderen ba\u015fl\u0131\u011f\u0131 gerekli","validate_image_size":"Belge 10 mb'den k\u00fc\u00e7\u00fck olmal\u0131d\u0131r","validate_image_type":"Resim \u015fu t\u00fcrde bir dosya olmal\u0131d\u0131r: jpg, jpeg, png.","validate_instagram_url":"L\u00fctfen ge\u00e7erli bir Instagram URL'si girin","validate_linkedin_url":"L\u00fctfen ge\u00e7erli bir Linkedin URL'si girin","validate_quantity":"Miktar 0'dan b\u00fcy\u00fck olmal\u0131d\u0131r.","validate_tax":"Vergiler %100'den az olmal\u0131d\u0131r.","validate_to_title":"to ba\u015fl\u0131\u011f\u0131 gereklidir.","validate_twitter_url":"L\u00fctfen ge\u00e7erli bir Twitter URL'si girin","value_must_be_greter_then":"De\u011fer 1'den b\u00fcy\u00fck olmal\u0131d\u0131r","wed":"EVLENMEK","yearly_income_expense_chart":"Y\u0131ll\u0131k Gelir Gider Tablosu","yes":"Evet","yesterday":"D\u00fcn","zoom":"Yak\u0131nla\u015ft\u0131r"},"zh.js":{"about_us_description_required":"\u95dc\u65bc\u6211\u5011\u7684\u63cf\u8ff0\u6b04\u4f4d\u4e0d\u50c5\u5305\u542b\u7a7a\u683c","about_us_mission_required":"\u95dc\u65bc\u6211\u5011 \u4efb\u52d9\u6b04\u4f4d\u4e0d\u50c5\u50c5\u5305\u542b\u7a7a\u767d","about_us_title_required":"\u95dc\u65bc\u6211\u5011\u6a19\u984c\u6b04\u4f4d\u4e0d\u50c5\u50c5\u5305\u542b\u7a7a\u683c","account":"\u5e33\u6236","all_notification_read_successfully":"\u6240\u6709\u901a\u77e5\u8b80\u53d6\u6210\u529f","allow_file_type":"\u5141\u8a31\u7684\u6a94\u6848\u985e\u578b\uff1apng\u3001jpg\u3001jpeg\u3002","amount":"\u6578\u91cf","apply":"\u7533\u8acb","appointment":"\u9810\u7d04","apr":"\u56db\u6708","are_you_sure":"\u4f60\u78ba\u5b9a\u55ce\uff1f","are_you_sure_want_to_cancel":"\u60a8\u78ba\u5b9a\u8981\u53d6\u6d88\u55ce","are_you_sure_want_to_change":"\u4f60\u78ba\u5b9a\u8981\u6539\u8b8a\u55ce","are_you_sure_want_to_return_this_item":"\u60a8\u78ba\u5b9a\u8981\u9000\u56de\u8a72\u5546\u54c1\u55ce","aug":"\u516b\u6708","available_quantity":"\u53ef\u7528\u6578\u91cf","available_time_greater_than_zero":"\u53ef\u7528\u8d77\u59cb\u6642\u9593\u5fc5\u9808\u5927\u65bc\u96f6","available_time_less_than_hospital_schedule_time":"\u53ef\u7528\u6642\u9593\u5fc5\u9808\u5c0f\u65bc\u91ab\u9662\u5b89\u6392\u6642\u9593","available_to_time_greater_than_zero":"\u53ef\u7528\u6642\u9593\u5fc5\u9808\u5927\u65bc\u96f6","bed":"\u5e8a","break_time_greater_than_zero":"\u4e2d\u65b7\u6642\u9593\u5fc5\u9808\u5927\u65bc\u96f6","break_to_time_greater_than_from_time":"Break To \u6642\u9593\u5fc5\u9808\u5927\u65bc Break From \u6642\u9593","break_to_time_greater_than_zero":"Break To \u6642\u9593\u5fc5\u9808\u5927\u65bc\u96f6","cancel":"\u53d6\u6d88","canceled":"\u53d6\u6d88","case":"\u6848\u4ef6","case_id":"\u6848\u4f8bID","change_status":"\u66f4\u6539\u72c0\u614b","changed_appointment":"\u66f4\u6539\u9810\u7d04","charge":"\u6536\u8cbb","choose":"\u9078\u64c7","complete_this_payment":"\u60a8\u60f3\u5b8c\u6210\u6b64\u4ed8\u6b3e\uff01\uff01","custom":"\u98a8\u4fd7","date_required":"\u65e5\u671f\u6b04\u4f4d\u70ba\u5fc5\u586b\u9805\u3002","dec":"\u5341\u4e8c\u6708","delete_medicine":"\u8a72\u85e5\u5df2\u5728\u91ab\u85e5\u5e33\u55ae\u4e2d\u4f7f\u7528\uff0c\u60a8\u78ba\u5b9a\u8981\u522a\u9664\u55ce\uff1f","department":"\u90e8\u9580","disconnect_or_reconnect":"\u8acb\u4e2d\u65b7\u4e26\u91cd\u65b0\u9023\u63a5\u60a8\u7684 Google \u65e5\u66c6","doctor_schedule_not_available_on_this_date":"\u8a72\u65e5\u671f\u6c92\u6709\u91ab\u751f\u6642\u9593\u8868\u3002","document_error":"\u8a72\u6587\u4ef6\u5fc5\u9808\u662f\u4ee5\u4e0b\u985e\u578b\u7684\u6587\u4ef6\uff1ajpeg\u3001jpg\u3001png\u3001pdf\u3001doc\u3001docx\u3002","employee":"\u54e1\u5de5","employee_payroll_deduction":"\u6263\u9664\u984d\u4e0d\u80fd\u5927\u65bc\u57fa\u672c\u5de5\u8cc7+\u6d25\u8cbc","expenses":"\u82b1\u8cbb","feb":"\u4e8c\u6708","field_required":"\u6b04\u4f4d\u70ba\u5fc5\u586b\u6b04\u4f4d\u3002","flutterwave_public_key":"Flutterwave \u516c\u94a5","flutterwave_secret_key":"Flutterwave \u79d8\u94a5","fri":"\u5f17\u745e","from":"\u5f9e","google_meet":"Google\u898b\u9762","has_been_cancelled":"\u5df2\u7d93\u53d6\u6d88\u3002","has_been_changed":"\u5df2\u7d93\u8b8a\u4e86\u3002","has_been_deleted":"\u5df2\u522a\u9664\u3002","holiday":"\u5047\u671f","home_page_box_descriptions_required":"\u4e3b\u9801\u6846\u63cf\u8ff0\u6b04\u4f4d\u4e0d\u50c5\u50c5\u5305\u542b\u7a7a\u683c","home_page_box_required":"\u4e3b\u9801\u6846\u6a19\u984c\u6b04\u4f4d\u4e0d\u53ea\u5305\u542b\u7a7a\u683c","home_page_certified_box_title_required":"\u4e3b\u9801\u8a8d\u8b49\u6846\u6a19\u984c\u6b04\u4f4d\u4e0d\u53ea\u5305\u542b\u7a7a\u683c","home_page_certified_description_required":"\u4e3b\u9801\u8a8d\u8b49\u8a8d\u8b49\u63cf\u8ff0\u6b04\u4f4d\u4e0d\u50c5\u50c5\u5305\u542b\u7a7a\u683c","home_page_certified_doctor_description_required":"\u4e3b\u9801\u8a8d\u8b49\u91ab\u751f\u63cf\u8ff0\u6b04\u4f4d\u4e0d\u50c5\u50c5\u5305\u542b\u7a7a\u683c","home_page_certified_required":"\u4e3b\u9801\u8a8d\u8b49\u91ab\u751f\u6587\u5b57\u6b04\u4f4d\u4e0d\u50c5\u50c5\u5305\u542b\u7a7a\u767d","home_page_certified_title_required":"\u4e3b\u9801\u8a8d\u8b49\u91ab\u751f\u6a19\u984c\u6b04\u4f4d\u4e0d\u53ea\u5305\u542b\u7a7a\u683c","home_page_description_required":"\u4e3b\u9801\u63cf\u8ff0\u6b04\u4f4d\u4e0d\u50c5\u50c5\u5305\u542b\u7a7a\u683c","home_page_experience_required":"\u4e3b\u9801\u9ad4\u9a57\u6b04\u4f4d\u4e0d\u53ea\u5305\u542b\u7a7a\u767d","home_page_step_description_required":"\u4e3b\u9801\u7b2c 1 \u6b65\u9a5f\u63cf\u8ff0\u6b04\u4f4d\u4e0d\u53ea\u5305\u542b\u7a7a\u683c","home_page_step_four_description_required":"\u4e3b\u9801\u7b2c 4 \u6b65\u9a5f\u63cf\u8ff0\u6b04\u4f4d\u4e0d\u53ea\u5305\u542b\u7a7a\u683c","home_page_step_four_title_required":"\u4e3b\u9801\u7b2c 4 \u6b65\u9a5f\u6a19\u984c\u6b04\u4f4d\u4e0d\u53ea\u5305\u542b\u7a7a\u683c","home_page_step_three_description_required":"\u4e3b\u9801\u7b2c 3 \u6b65\u9a5f\u63cf\u8ff0\u6b04\u4f4d\u4e0d\u53ea\u5305\u542b\u7a7a\u683c","home_page_step_three_title_required":"\u4e3b\u9801\u7b2c 3 \u6b65\u6a19\u984c\u6b04\u4f4d\u4e0d\u53ea\u5305\u542b\u7a7a\u683c","home_page_step_title_required":"\u4e3b\u9801\u7b2c 1 \u6b65\u6a19\u984c\u6b04\u4f4d\u4e0d\u53ea\u5305\u542b\u7a7a\u683c","home_page_step_two_description_required":"\u4e3b\u9801\u7b2c 2 \u6b65\u9a5f\u63cf\u8ff0\u6b04\u4f4d\u4e0d\u53ea\u5305\u542b\u7a7a\u683c","home_page_step_two_title_required":"\u4e3b\u9801\u7b2c 2 \u6b65\u6a19\u984c\u6b04\u4f4d\u4e0d\u53ea\u5305\u542b\u7a7a\u683c","home_page_title_required":"\u4e3b\u9801\u6a19\u984c\u6b04\u4f4d\u4e0d\u50c5\u50c5\u5305\u542b\u7a7a\u683c","income":"\u6536\u5165","invalid_country_code":"\u570b\u5bb6\u4ee3\u78bc\u7121\u6548","invalid_number":"\u7121\u6548\u865f\u78bc","ipd_operation":"IPD\u64cd\u4f5c","ipd_patient":"IPD \u60a3\u8005","item":"\u7269\u54c1","item_name":"\u5c08\u6848\u540d","item_returned":"\u56de","jan":"\u4e00\u6708","july":"\u4e03\u6708","jun":"\u516d\u6708","last_30_days":"\u904e\u53bb 30 \u5929","last_7_days":"\u904e\u53bb 7 \u5929","last_month":"\u4e0a\u500b\u6708","lot_number":"\u8f38\u5165\u6279\u865f","lunch_break":"\u4f11\u606f","make_payment":"\u4ed8\u6b3e","mar":"\u884c\u9032","may":"\u53ef\u80fd","medicine_bill":"\u91ab\u85e5\u6cd5\u6848","medicine_category":"\u85e5\u54c1\u985e\u5225","medicine_required":"\u9700\u8981\u91ab\u5b78\u9818\u57df\u3002","message_not_greater_than_160_characters":"\u8a72\u8a0a\u606f\u4e0d\u5f97\u8d85\u904e 160 \u500b\u5b57\u5143\u3002","mon":"\u9031\u4e00","month":"\u6708","n\/a":"\u4e0d\u9069\u7528","net_amount_not_empty":"\u6de8\u984d\u4e0d\u80fd\u70ba\u7a7a\u3002","net_amount_not_zero":"\u6de8\u984d\u4e0d\u80fd\u70ba\u96f6\u3002","no":"\u4e0d","notification_read_successfully":"\u901a\u77e5\u8b80\u53d6\u6210\u529f","nov":"\u5341\u4e00\u6708","oct":"\u5341\u6708","ok":"\u597d\u7684","password_and_confirm_password_not_match":"\u5bc6\u78bc\u548c\u78ba\u8a8d\u5bc6\u78bc\u4e0d\u7b26\u3002","patient_id_card_template":"\u667a\u6167\u578b\u75c5\u4eba\u5361\u6a21\u677f","patient_not_exists_or_status_is_not_active":"\u60a3\u8005\u4e0d\u5b58\u5728\u6216\u72c0\u614b\u4e0d\u6d3b\u8e8d\u3002","patient_required":"\u60a3\u8005\u6b04\u4f4d\u70ba\u5fc5\u586b\u9805","payment_status_must_be_active":"\u4ed8\u6b3e\u72b6\u6001\u5fc5\u987b\u5904\u4e8e\u6d3b\u52a8\u72b6\u6001\u3002","paypal_client_id":"\u8c9d\u5bf6\u5ba2\u6236 ID","paypal_mode":"\u8c9d\u5bf6\u6a21\u5f0f","paypal_secret":"\u8c9d\u5bf6\u79d8\u5bc6","paystack_key":"\u652f\u4ed8\u5b9d\u94a5\u5319","paystack_secret_key":"\u652f\u4ed8\u5b9d\u79d8\u5bc6\u5bc6\u94a5","please_fill_all_the_required_fields":"\u8acb\u586b\u5beb\u6240\u6709\u5fc5\u586b\u6b04\u4f4d\u3002","please_select_appointment_time_slot":"\u8acb\u9078\u64c7\u9810\u7d04\u6642\u6bb5","please_select_doctor":"\u8acb\u9078\u64c7\u91ab\u751f","please_select_doctor_department":"\u8acb\u9078\u64c7\u91ab\u751f\u79d1\u5ba4","price":"\u50f9\u683c","privacy_policy":"\u96b1\u79c1\u6b0a\u653f\u7b56","purchase_medicine":"\u8cfc\u8cb7\u85e5\u54c1","purchase_price":"\u8f38\u5165\u8cfc\u8cb7\u50f9\u683c","qty":"\u6578\u91cf","quantity_cannot_be_zero":"\u6578\u91cf\u4e0d\u80fd\u70ba\u96f6\u6216\u70ba\u7a7a\u3002","quantity_must_be_less_than_available_quantity":"\u6578\u91cf\u5fc5\u9808\u5c0f\u65bc\u53ef\u7528\u6578\u91cf\u3002","quantity_required":"\u8acb\u8f38\u5165\u6578\u91cf\u3002","razorpay_key":"Razorpay \u91d1\u9470","razorpay_secret":"Razorpay \u7684\u79d8\u5bc6","sale_price":"\u92b7\u552e\u50f9\u683c","sat":"SAT","saved_successfully":"\u4fdd\u5b58\u6210\u529f","schedule_time":"\u53ef\u7528\u958b\u59cb\u6642\u9593\u5fc5\u9808\u5927\u65bc\u91ab\u9662\u5b89\u6392\u6642\u9593","schedule_time_select":"\u8acb\u9078\u64c7\u6bcf\u4f4d\u60a3\u8005\u7684\u6642\u9593","search":"\u641c\u5c0b","select_bed_type":"\u9078\u64c7\u5e8a\u578b","select_calendar":"\u8acb\u9078\u64c7\u65e5\u66c6\u3002","select_category":"\u9078\u64c7\u985e\u5225","select_charge_category":"\u9078\u64c7\u6536\u8cbb\u985e\u5225","select_doctor":"\u9078\u64c7\u91ab\u751f","select_medicine":"\u9078\u64c7\u85e5\u7269","select_parameter_name":"\u9078\u64c7\u53c3\u6578\u540d\u7a31","select_patient":"\u9078\u64c7\u60a3\u8005","select_user":"\u9078\u64c7\u7528\u6236","sep":"\u4e5d\u6708","status":"\u5730\u4f4d","stripe_key":"\u689d\u7d0b\u9375","stripe_secret":"\u689d\u7d0b\u7684\u79d8\u5bc6","sun":"\u592a\u967d","tax_amount_not_zero_or_empty":"\u7a05\u984d\u4e0d\u80fd\u70ba\u96f6\u6216\u70ba\u7a7a\u3002","terms_conditions":"\u689d\u6b3e\u53ca\u689d\u4ef6","the_privacy_policy_is_required":"\u9700\u8981\u96b1\u79c1\u6b0a\u653f\u7b56\u3002","the_terms_conditions_is_required":"\u689d\u6b3e\u548c\u689d\u4ef6\u70ba\u5fc5\u586b\u9805\u3002","this_month":"\u9019\u500b\u6708","this_week":"\u672c\u661f\u671f","thu":"\u9031\u56db","to":"\u5230","today":"\u4eca\u5929","too_long":"\u592a\u9577","too_short":"\u904e\u77ed","tue":"\u6cbb\u7642\u8cbb\u7528","type_number":"\u578b\u865f \u7de8\u865f","update_quantity":"\u66f4\u65b0\u6578\u91cf\u61c9\u5c0f\u65bc\u4e4b\u524d\u7684\u6578\u91cf\u3002","user":"\u4f7f\u7528\u8005","validate_discount":"\u6298\u6263\u91d1\u984d\u61c9\u5c0f\u65bc\u7e3d\u91d1\u984d","validate_doc_type":"\u8a72\u6587\u4ef6\u5fc5\u9808\u662f\u4ee5\u4e0b\u985e\u578b\u7684\u6587\u4ef6\uff1ajpeg\u3001jpg\u3001png\u3001pdf\u3001doc\u3001docx\u3001webp","validate_facebook_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 Facebook \u7db2\u5740","validate_from_title":"\u5bc4\u4ef6\u8005\u6a19\u984c\u70ba\u5fc5\u586b\u9805","validate_image_size":"\u6587\u4ef6\u5fc5\u9808\u5c0f\u65bc 10 MB","validate_image_type":"\u5716\u50cf\u5fc5\u9808\u662f\u4ee5\u4e0b\u985e\u578b\u7684\u6a94\u6848\uff1ajpg\u3001jpeg\u3001png\u3002","validate_instagram_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 Instagram \u7db2\u5740","validate_linkedin_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 LinkedIn \u7db2\u5740","validate_quantity":"\u6578\u91cf\u61c9\u5927\u65bc 0\u3002","validate_tax":"\u7a05\u6536\u61c9\u4f4e\u65bc 100%\u3002","validate_to_title":"\u6a19\u984c\u70ba\u5fc5\u586b\u9805\u3002","validate_twitter_url":"\u8acb\u8f38\u5165\u6709\u6548\u7684 Twitter \u7db2\u5740","value_must_be_greter_then":"\u503c\u5fc5\u987b\u5927\u4e8e1","wed":"\u661f\u671f\u4e09","yearly_income_expense_chart":"\u5e74\u5ea6\u6536\u5165\u652f\u51fa\u8868","yes":"\u662f\u7684","yesterday":"\u6628\u5929","zoom":"\u98db\u6f32"}});
})();
