<?php

return [

    /*
    |--------------------------------------------------------------------------
    | All Titles and static string in blade files - Arabic Language
    |--------------------------------------------------------------------------
    |
    */
    //menu.blade keys
    'admin' => 'المشرفون',
    'admins' => 'مسؤل',
    'roles' => 'الأدوار',
    'doctor_departments' => 'أقسام الطبيب',
    'nurses' => 'الممرضات',
    'operations' => 'عمليات',
    'doctors' => 'الأطباء',
    'patients' => 'المرضى',
    'lab_technicians' => 'فنيو المختبرات',
    'receptionists' => 'الاستقبال',
    'pharmacists' => 'الصيادلة',
    'accountants' => 'المحاسبين',
    'appointments' => 'تعيينات',
    'insurances' => 'تأمين',
    'investigation_reports' => 'تقارير التحقيق',
    'death_reports' => 'تقارير الوفاة',
    'birth_reports' => 'تقارير الميلاد',
    'operation_reports' => 'تقارير التشغيل',
    'medicine_categories' => 'فئات الطب',
    'medicine_brands' => 'ماركات الطب',
    'medicines' => 'أدوية',
    'cases' => 'الحالات',
    'case_handlers' => 'معالجات الحالة',
    'bed_types' => 'أنواع السرير',
    'beds' => 'سرير',
    'bed_assigns' => 'تعيينات السرير',
    'packages' => 'الحزم',
    'schedules' => 'جداول',
    'schedule_label' => 'جدول',
    'services' => 'خدمات',
    'accounts' => 'حسابات',
    'payments' => 'المدفوعات',
    'bills' => 'فواتير',
    'employee_payrolls' => 'كشوف مرتبات الموظفين',
    'documents' => 'مستندات',
    'document_types' => 'أنواع المستندات',
    'notice_boards' => 'لافتات تنبيه',
    'settings' => 'الإعدادات',
    'doctors_list' => 'قائمة الأطباء',
    'my_payrolls' => 'رواتبي',
    'blood_banks' => 'بنوك الدم',
    'blood_donors' => 'المتبرعين بالدم',
    'invoices' => 'فواتير',
    'patients_cases' => 'حالات المرضى',
    'patients_case_details' => 'تفاصيل حالة المرضى',
    'account_manager' => 'إدارة حساب المستخدم',
    'bed_management' => 'إدارة السرير',
    'blood_bank' => 'بنك الدم',
    'billing' => 'الفواتير',
    'case_manager' => 'مدير الحالة',
    'cms' => 'CMS',
    'department' => 'قسم',
    'departments' => 'الأقسام',
    'hospital_activities' => 'أنشطة المستشفى',
    'advanced_payments' => 'دفعات مقدمة',
    'patient_admissions' => 'قبول المرضى',
    'appointment_calendar' => 'عيّن. التقويم',
    'bed_mgt' => 'إدارة السرير',
    'reports' => 'التقارير',
    'enquiries' => 'استفسارات',
    'mail' => 'بريد',
    'ambulances' => 'سيارات الإسعاف',
    'ambulance_calls' => 'مكالمات الإسعاف',
    'prescriptions' => 'الوصفات الطبية',
    'hospital_charges' => 'رسوم المستشفى',
    'charge_categories' => 'فئات الرسوم',
    'charges' => 'شحنة',
    'radiologies' => 'الأشعة',
    'radiology_categories' => 'فئة الأشعة',
    'pathologies' => 'علم الأمراض',
    'pathology_categories' => 'فئة علم الأمراض',
    'radiology_tests' => 'اختبارات الأشعة',
    'doctor_opd_charges' => 'رسوم طبيب OPD',
    'pathology_tests' => 'اختبارات علم الأمراض',
    'expenses' => 'نفقات',
    'income' => 'الإيرادات',
    'finance' => 'المالية',
    'inventory' => 'المخزون',
    'items_categories' => 'فئات العناصر',
    'items' => 'العناصر',
    'items_stocks' => 'مخزون البند',
    'issued_items' => 'العناصر المصدرة',
    'ipd_patients' => 'مرضى IPD',
    'ipd_opd' => 'IPD / العيادات الخارجية',
    'ipd_diagnosis' => 'التشخيص',
    'ipd_consultant_register' => 'تعليمات استشاري',
    'ipd_consultant_doctor' => 'طبيب استشاري',
    'ipd_charges' => 'شحنة',
    'ipd_prescription' => 'الوصفات الطبية',
    'ipd_timelines' => 'الجداول الزمنية',
    'ipd_payment' => 'دفع IPD',
    'opd_patients' => 'مرضى العيادات الخارجية',
    'opd_diagnosis' => 'تشخيص العيادات الخارجية',
    'opd_timeline' => 'الجدول الزمني للعيادات الخارجية',
    'call_logs' => 'سجلات المكالمات',
    'visitors' => 'الزائرين',
    'front_office' => 'مكتب الإستقبال',
    'postal_receive' => 'استلام بريدي',
    'postal_dispatch' => 'الإرسال البريدي',
    'general' => 'جنرال لواء',
    'sidebar_setting' => 'إعدادات الوحدات',
    'currency_setting' => 'العملات',
    'testimonials' => 'الشهادات - التوصيات',
    'blood_donations' => 'تبرع بالدم',
    'blood_issues' => 'مشاكل الدم',
    'live_consultations' => 'استشارات مباشرة',
    'vaccinations' => 'التطعيمات',
    'vaccinated_patients' => 'المرضى الذين تم تطعيمهم',
    'front_settings' => 'الإعدادات الأمامية',
    'front_service' => 'الخدمة الأمامية',
    'about_us' => 'معلومات عنا',
    'make_an_appointment' => 'إحجز موعد',
    'patient_appointment' => 'موعد المريض',
    'old_patient' => 'مريض قديم',
    'new_patient' => 'مريض جديد',
    'available_slot' => 'الفتحة المتاحة',
    'contact_us' => 'اتصل بنا',
    'users' => 'المستخدمون',
    'hospital_schedule' => 'جدول المستشفى',
    'front_cms' => 'الجبهة سم',
    'front_cms_services' => 'خدمات Front CMS',
    'facebook_url' => 'URL الفيسبوك',
    'twitter_url' => 'رابط تويتر',
    'instagram_url' => 'رابط انستغرام',
    'linkedIn_url' => 'رابط رابط',
    'live_meetings' => 'اجتماعات مباشرة',
    'live_meeting' => 'لقاء مباشر',
    'allow_file_type' => 'أنواع الملفات المسموح بها: png، jpg، jpeg.',
    'overview' => 'ملخص',
    'no_data_available' => 'لا توجد بيانات متوفرة في الجدول',
    'file_name' => 'اسم الملف',
    'icon' => 'أيقونة',
    'short_description' => 'وصف قصير',
    'valid' => 'صالح',
    'no_matching_records_found' => 'لم يتم العثور على سجلات مطابقة',
    'select_applied_date' => 'الرجاء تحديد تاريخ التطبيق',
    'select_instruction_date' => 'الرجاء تحديد تاريخ التعليمات',
    'report' => 'تقرير',
    'report_id' => 'معرف التقرير',
    'yearly_income_expense_chart' => 'مخطط نفقات الدخل السنوي',
    'sms_mail' => 'الرسائل القصيرة / البريد',
    'payment_gateways' => 'بوابات الدفع',
    'stripe_key' => 'مفتاح Stripe',
    'stripe_secret' => 'سر Stripe',
    'paypal' => 'باي بال',
    'paypal_client_id' => 'معرف عميل باي بال',
    'paypal_secret' => 'سر PayPal',
    'paypal_mode' => 'وضع باي بال',
    'razorpay' => 'ريزورباي',
    'razorpay_key' => 'مفتاح Razorpay',
    'razorpay_secret' => 'سر Razorpay',
    'cash' => 'نقدي',
    'cheque' => 'يفحص',
    'flutterwave' => 'موجة الرفرفة',
    'flutterwave_public_key' => 'المفتاح العام Flutterwave',
    'flutterwave_secret_key' => 'مفتاح Flutterwave السري',
    'phonepe' => 'هاتف بي',
    'paystack' => 'الراتب',
    'paystack_public_key' => 'مفتاح Paystack العام',
    'paystack_secret_key' => 'مفتاح Paystack السري',
    'phonepe_merchant_id' => 'معرف معاملة التاجر Phonepe',
    'phonepe_merchant_user_id' => 'معرف مستخدم تاجر Phonepe',
    'phonepe_env' => 'فونيب البيئة',
    'phonepe_salt_key' => 'مفتاح ملح الهاتف',
    'phonepe_salt_index' => 'مؤشر ملح الهاتف',
    'phonepe_merchant_transaction_id' => 'معرف معاملة التاجر Phonepe',

    'language' => [
        'Arabic' => 'عربي',
        'Chinese' => 'صينى',
        'English' => 'إنجليزي',
        'French' => 'فرنسي',
        'German' => 'ألمانية',
        'Portuguese' => 'البرتغالية',
        'Russian' => 'الروسية',
        'Spanish' => 'الأسبانية',
        'Turkish' => 'اللغة التركية',
    ],

    //roles
    'role' => [
        'new_role' => 'دور جديد',
        'edit_role' => 'تحرير الدور',
        'select_role' => 'حدد الدور',
    ],

    //user keys
    'user' => [
        'user' => 'المستخدم',
        'user_list' => 'قائمة المستخدمين',
        'first_name' => 'الاسم الاول',
        'last_name' => 'الكنية',
        'name' => 'اسم',
        'email' => 'البريد الإلكتروني',
        'phone' => 'هاتف',
        'designation' => 'تعيين',
        'gender' => 'جنس',
        'male' => 'الذكر',
        'female' => 'أنثى',
        'qualification' => 'المؤهل',
        'dob' => 'تاريخ الولادة',
        'blood_group' => 'فصيلة الدم',
        'select_blood_group' => 'حدد فصيلة الدم',
        'password' => 'كلمه السر',
        'password_confirmation' => 'تأكيد كلمة المرور',
        'address1' => 'العنوان 1',
        'address2' => 'العنوان 2',
        'city' => 'مدينة',
        'zip' => 'الرمز البريدي',
        'address_details' => 'تفاصيل العنوان',
        'address_not_found' => 'لم يتم العثور على تفاصيل العنوان',
        'education' => 'التعليم',
        'status' => 'الحالة',
        'edit_profile' => 'تعديل الملف الشخصي',
        'change_password' => 'تغيير كلمة السر',
        'logout' => 'تسجيل خروج',
        'new_user' => 'مستخدم جديد',
        'edit_user' => 'تحرير العضو',
        'user_details' => 'بيانات المستخدم',
        'email_verified_successfully' => 'تم التحقق من البريد الإلكتروني بنجاح.',
        'invalid_password' => 'كلمة المرور الحالية غير صحيحة.',
        'validate_confirm_password' => 'يجب أن تتطابق كلمة المرور مع تأكيد كلمة المرور.',
        'validate_min_character_password' => 'يجب أن تحتوي كلمة المرور على 6 أحرف على الأقل.',
        'validate_image_type' => 'يجب أن تكون الصورة من نوع: jpg، jpeg، png.',
        'validate_image_size' => 'يجب أن يكون حجم الملف أقل من 10 ميجابايت.',
        'validate_facebook_url' => 'الرجاء إدخال عنوان Facebook صحيح',
        'validate_twitter_url' => 'الرجاء إدخال عنوان Twitter صحيح',
        'validate_instagram_url' => 'الرجاء إدخال عنوان Instagram صحيح',
        'validate_linkedin_url' => 'الرجاء إدخال عنوان Linkedin صحيح',
        'phone_number_must_be_10_digits' => 'يجب أن يتكون رقم الهاتف من 10 أرقام',
        'valid_email' => 'الرجاء إدخال بريد إلكتروني صحيح',
    ],

    //common keys
    'common' => [
        'field_required' => 'الحقل مطلوب.',
        'change' => 'يتغير',
        'change_profile' => 'تغيير الصورة',
        'is' => 'يكون',
        'available_quantity_of' => 'الكمية المتوفرة من',
        'result' => 'نتيجة',
        'profile' => 'الملف الشخصي',
        'status' => 'الحالة',
        'action' => 'عمل',
        'save' => 'حفظ',
        'cancel' => 'إلغاء',
        'canceled' => 'إلغاء',
        'back' => 'عودة',
        'created_on' => 'تم إنشاؤها على',
        'last_updated' => 'آخر تحديث',
        'n/a' => 'لا يوجد',
        'new' => 'جديد',
        'total' => 'مجموع',
        'add' => 'أضف',
        'active' => 'نشيط',
        'name' => 'اسم',
        'edit' => 'تعديل',
        'detail' => 'تفاصيل',
        'delete' => 'حذف',
        'view' => 'رأي',
        'view_attachment' => 'عرض المرفقات',
        'de_active' => 'غير نشط',
        'description' => 'وصف',
        'created_at' => 'تم إنشاؤها على',
        'updated_at' => 'آخر تحديث',
        'is_available' => 'متاح',
        'choose' => 'أختر',
        'yes' => 'نعم',
        'no' => 'لا',
        'address' => 'عنوان',
        'export_to_excel' => 'تصدير الى اكسل',
        'reset' => 'إعادة ضبط',
        'actions' => 'أجراءات',
        'confirm' => 'يتأكد',
        'search' => 'يبحث',
        'status_updated_successfully' => 'تم تحديث الحالة بنجاح.',
        'saved_successfully' => 'حفظ بنجاح.',
        'updated_successfully' => 'تم التحديث بنجاح',
        'deleted_successfully' => 'حذف بنجاح',
        'filter_options' => 'خيارات التصفية',
        'are_you_sure_want_to_delete_this' => 'هل تريد بالتأكيد حذف هذا ',
        'deleted' => 'تم الحذف',
        'has_been_deleted' => 'قد تم حذف.',
        'cant_be_deleted' => 'لا يمكن حذفها',
        'custom' => 'العادة',
        'apply' => 'يتقدم',
        'from' => 'من',
        'to' => 'إلى',
        'invalid_number' => 'رقم غير صالح',
        'invalid_country_code' => 'رمز الدولة غير صحيح',
        'too_short' => 'قصير جدا',
        'too_long' => 'طويل جدا',
        'not_found' => 'لم يتم العثور على',
        'previous' => 'سابق',
        'next' => 'التالي',
        'ok' => 'موافق',
        'this_action_is_not_allowed_for_default_record' => 'هذا الإجراء غير مسموح به للسجل الافتراضي.',
        'show' => 'يعرض',
        'something_wen_wrong' => 'حدث خطأ ما',
        'cancelled_successfully' => 'تم الإلغاء بنجاح',
        'invalid_username_password' => 'اسم المستخدم أو كلمة المرور غير صحيحة',
        'logged_in_successfully' => 'تم تسجيل الدخول بنجاح',
        'logout_successfully' => 'تم تسجيل الخروج بنجاح',
        'we_cant_find_user' => 'لا يمكننا العثور على المستخدم بهذا البريد الإلكتروني',
        'we_have_your_password_resetk_link' => 'لقد قمنا بإرسال رابط إعادة تعيين كلمة المرور إلى بريدك الإلكتروني!',
        'this_password_reset_token_is_invalid' => 'رمز إعادة تعيين كلمة المرور هذا غير صالح',
        'password_reset_successfully' => 'تمت إعادة تعيين كلمة المرور بنجاح',
        'please_enter_correct_old_password' => 'يرجى إدخال كلمة المرور القديمة الصحيحة',
        'password_updated' => 'تم تحديث كلمة المرور',
        'doctor_scheduled' => 'تم جدولة الطبيب',
        'not_updated' => 'لم يتم التحديث',
        'patient_registered_successfully' => 'تم تسجيل المريض بنجاح',
        'appointment_confirmed_successfully' => 'تم تأكيد الموعد بنجاح',
        'bed_assigned_successfully' => 'تم تخصيص السرير بنجاح',
        'username_and_password_required' => 'اسم المستخدم وكلمة المرور مطلوبان',
        'meeting_finished_or_cancelled' => 'انتهت أو تم إلغاء هذا الاجتماع',
        'alreay_exists' => 'موجود بالفعل.',
        'appointment_transaction' => 'معاملة التعيين'
    ],

    'hospital_schedules' => [
        'exists_doctor_schedule' => 'حدد بعض الأطباء مواعيدهم في أيام محددة ، فهل أنت متأكد من رغبتك في إجراء هذه العملية؟',
        'schedule_not_available' => 'حاليًا غير مسموح للمستخدم بإنشاء جدول مستشفى إذا كان الجدول المستشفى غير متاح.',
        'this_day_hospital_is_closed' => 'هذا اليوم مستشفى مغلق.',
    ],

    'months' => [
        'jan' => 'يناير',
        'feb' => 'شهر فبراير',
        'mar' => 'يمشي',
        'apr' => 'أبريل',
        'may' => 'مايو',
        'jun' => 'يونيه',
        'july' => 'يوليو',
        'aug' => 'أغسطس',
        'sep' => 'سبتمبر',
        'oct' => 'اكتوبر',
        'nov' => 'شهر نوفمبر',
        'dec' => 'ديسمبر',
    ],

    'weekdays' => [
        'sun' => 'الشمس',
        'mon' => 'العالمية',
        'tue' => 'الثلاثاء',
        'wed' => 'الأربعاء',
        'thu' => 'الخميس',
        'fri' => 'جمهورية مقدونيا',
        'sat' => 'جلس',
    ],

    // receptionist keys
    'receptionist' => [
        'receptionist' => 'موظف الإستقبال',
        'receptionists' => 'موظف الإستقبال',
        'receptionist_details' => 'تفاصيل موظف الاستقبال',
        'new_receptionist' => 'موظف استقبال جديد',
        'edit_receptionist' => 'تحرير موظف استقبال',
        'profile_must_be_image' => 'يجب أن تكون صورة الملف الشخصي صورة',
    ],

    // insurance keys
    'insurance' => [
        'insurance' => 'تأمين',
        'insurances' => 'تأمين',
        'insurance_details' => 'تفاصيل التأمين',
        'new_insurance' => 'تأمين جديد',
        'edit_insurance' => 'تحرير التأمين',
        'service_tax' => 'ضريبة الخدمة',
        'insurance_no' => 'رقم التأمين',
        'insurance_code' => 'قانون التأمين',
        'hospital_rate' => 'معدل المستشفى',
        'discount' => 'خصم',
        'remark' => 'ملاحظة',
        'disease_details' => 'تفاصيل المرض',
        'diseases_name' => 'اسم الأمراض',
        'diseases_charge' => 'رسوم الأمراض',
        'total_amount' => 'المبلغ الإجمالي',
    ],

    //doctor department
    'doctor_department' => [
        'doctor_departments' => 'أقسام الطبيب',
        'doctor_department' => 'قسم الطبيب',
        'doctor_department_details' => 'تفاصيل قسم الطبيب',
        'new_doctor_department' => 'قسم الأطباء الجديد',
        'edit_doctor_department' => 'تعديل قسم الطبيب',
        'title' => 'عنوان',
        'description' => 'وصف',
        'doctor_field_required' => 'مطلوب مجال الطبيب'
    ],

    // investigation reports
    'investigation_report' => [
        'investigation_reports' => 'تقارير التحقيق',
        'investigation_report' => 'تقرير التحقيق',
        'new_investigation_report' => 'تقرير تحقيق جديد',
        'investigation_report_details' => 'تفاصيل تقرير التحقيق',
        'edit_investigation_report' => 'تحرير تقرير التحقيق',
        'patient' => 'صبور',
        'date' => 'تاريخ',
        'title' => 'عنوان',
        'doctor' => 'عنوان',
        'description' => 'وصف',
        'attachment' => 'المرفق',
        'birth_date_validation' => 'يجب ألا يكون تاريخ تقرير التحقيق أصغر من تاريخ ميلاد المريض.',
    ],

    // pharmacist keys
    'pharmacist' => [
        'new_pharmacist' => 'صيدلي جديد',
        'edit_pharmacist' => 'تحرير صيدلي',
        'pharmacists' => 'الصيادلة',
        'pharmacist_details' => 'تفاصيل الصيدلي',
    ],

    // death reports keys
    'death_report' => [
        'death_report' => 'تقرير الوفاة',
        'death_reports' => 'تقارير الوفاة',
        'new_death_report' => 'تقرير وفاة جديد',
        'edit_death_report' => 'تحرير تقرير الوفاة',
        'death_report_details' => 'تفاصيل تقرير الوفاة',
        'patient_name' => 'اسم المريض',
        'case_id' => 'ID القضية',
        'doctor_name' => 'اسم الطبيب',
        'date' => 'تاريخ',
        'description' => 'وصف',
        'cant_create_report_because_the_patient_has_been_dead' => 'لا يمكن إنشاء التقرير لأن المريض توفي.',
        'data_should_not_be_smaller_than_patient_birth_date' => 'يجب ألا تكون التاريخ أقل من تاريخ ميلاد المريض.',
    ],

    // birth reports keys
    'birth_report' => [
        'birth_report' => 'تقرير الميلاد',
        'birth_reports' => 'تقارير الميلاد',
        'birth_report_details' => 'تفاصيل تقرير الولادة',
        'new_birth_report' => 'تقرير الميلاد الجديد',
        'edit_birth_report' => 'تحرير تقرير الميلاد',
        'patient_name' => 'اسم المريض',
        'case_id' => 'ID القضية',
        'doctor_name' => 'اسم الطبيب',
        'date' => 'تاريخ',
        'description' => 'وصف',
        'data_should_not_be_smaller_than_patient_birth_date' => 'يجب ألا يكون التاريخ أصغر من تاريخ ميلاد المريض.',
        'patient_birth_date_not_found' => 'تاريخ ميلاد المريض غير موجود.',
    ],

    // accountant keys
    'accountant' => [
        'new_accountant' => 'محاسب جديد',
        'edit_accountant' => 'تحرير محاسب',
        'accountants' => 'المحاسبين',
        'accountant_details' => 'تفاصيل المحاسب',
    ],

    // employee payroll keys
    'employee_payroll' => [
        'employee_payroll' => 'كشوف مرتبات الموظفين',
        'employee_payrolls' => 'كشوف مرتبات الموظفين',
        'employee_payroll_details' => 'تفاصيل رواتب الموظفين',
        'new_employee_payroll' => 'رواتب الموظفين الجدد',
        'edit_employee_payroll' => 'تحرير رواتب الموظفين',
        'sr_no' => 'الأب رقم',
        'payroll_id' => 'معرف الرواتب',
        'month' => 'شهر',
        'year' => 'عام',
        'role' => 'وظيفة',
        'employee' => 'موظف',
        'basic_salary' => 'راتب اساسي',
        'allowance' => 'مخصص',
        'deductions' => 'الخصومات',
        'net_salary' => 'صافي الراتب',
        'paid' => 'دفع',
        'not_paid' => 'غير مدفوعة الأجر',
        'employee_name' => 'اسم الموظف',
        'employees_list_not_found' => 'لم يتم العثور على قائمة الموظفين',
        'employee_payroll_deduction' => 'الخصومات لا يمكن أن تكون أكبر من الراتب الأساسي + البدلات',
    ],

    // operation reports keys
    'operation_report' => [
        'operation_report' => 'تقرير العملية',
        'operation_reports' => 'تقارير التشغيل',
        'operation_report_details' => 'تفاصيل تقرير العملية',
        'new_operation_report' => 'تقرير العملية الجديد',
        'edit_operation_report' => 'تحرير تقرير العملية',
        'patient_name' => 'اسم المريض',
        'case_id' => 'ID القضية',
        'doctor_name' => 'اسم الطبيب',
        'date' => 'تاريخ',
        'description' => 'وصف',
        'data_should_not_be_smaller_than_patient_birth_date' => 'يجب ألا يكون التاريخ أصغر من تاريخ ميلاد المريض.',
    ],

    // accounts keys
    'account' => [
        'account' => 'الحساب',
        'accounts' => 'حسابات',
        'account_details' => 'تفاصيل الحساب',
        'new_account' => 'حساب جديد',
        'edit_account' => 'تحرير الحساب',
        'name' => 'اسم',
        'description' => 'وصف',
        'type' => 'اكتب',
        'status' => 'الحالة',
        'payments' => 'المدفوعات',
        'credit' => 'تنسب إليه',
        'debit' => 'مدين',
    ],

    // invoices keys
    'invoice' => [
        'invoice_id' => 'هوية صوتية',
        'invoice' => 'فاتورة',
        'invoices' => 'فواتير',
        'invoice_details' => 'تفاصيل الفاتورة',
        'new_invoice' => 'فاتورة جديدة',
        'edit_invoice' => 'تحرير الفاتورة',
        'patient' => 'صبور',
        'invoice_date' => 'تاريخ الفاتورة',
        'amount' => 'كمية',
        'patient_id' => 'رقم المريض',
        'discount' => 'خصم',
        'account_name' => 'أسم الحساب',
        'description' => 'وصف',
        'qty' => 'الكمية',
        'price' => 'السعر',
        'add' => 'أضف',
        'sub_total' => 'المجموع الفرعي',
        'total' => 'المبلغ الإجمالي',
        'edit' => 'تعديل',
        'hospital_address' => 'عنوان المستشفى',
        'paid' => 'دفع',
        'not_paid' => 'غير مدفوع',
        'print_invoice' => 'طباعة الفاتورة',
        'invoice_date_field_required' => 'حقل تاريخ الفاتورة مطلوب',
        'issue_for' => 'قضية ل',
        'issue_from' => 'إصدار من',
        'patient_overview' => 'نظرة عامة على المريض',
        'in_percentage' => 'في النسبة المئوية',
    ],

    //nurses
    'nurse' => [
        'nurse' => 'ممرضة',
        'new_nurse' => 'ممرضة جديدة',
        'edit_nurse' => 'تحرير ممرضة',
        'nurse_details' => 'تفاصيل الممرضة',
        'phone_no' => 'رقم الهاتف',
        'birth_date' => 'تاريخ الميلاد',
        'choose' => 'أختر',
    ],

    //patient
    'patient' => [
        'new_patient' => 'مريض جديد',
        'edit_patient' => 'تحرير المريض',
        'patient_details' => 'تفاصيل المريض',
        'total_cases' => 'إجمالي الحالات',
        'total_admissions' => 'إجمالي القبول',
        'total_appointments' => 'إجمالي المواعيد',
        'select_one_patient' => 'يرجى اختيار مريض واحد على الأقل',
        'patient_name_already_taken' => 'لقد تم بالفعل أخذ اسم المريض',
        'patient_field_required' => 'حقل المريض مطلوب',
    ],

    // payments keys
    'payment' => [
        'payment' => 'دفع',
        'payments' => 'المدفوعات',
        'payment_details' => 'بيانات الدفع',
        'new_payment' => 'دفع جديد',
        'edit_payment' => 'تحرير الدفع',
        'account_name' => 'أسم الحساب',
        'payment_date' => 'موعد الدفع',
        'pay_to' => 'دفع ل',
        'amount' => 'كمية',
        'account' => 'الحساب',
        'description' => 'وصف',
        'payment_reports' => 'تقارير الدفع',
        'your_payment_is_successfully_completed' => 'تمت عملية الدفع بنجاح',
        'payment_failed' => 'عذرًا! فشلت عملية الدفع، جرب مرة أخرى بعد فترة من الزمن',
        'flutterwave_not_support' => 'Flutterwave غير مدعوم بهذه العملة.',
        'phonepe_support_inr' => 'يدعم PhonePe عملة INR فقط.',
        'paystack_support_zar' => 'يدعم Paystack عملة "USD","GHS","NGN","ZAR","KES" فقط.',
        'paystack_token_expired' => 'انتهت صلاحية رمز paystack. يرجى تحديث الصفحة وحاول مرة أخرى.',
        'currency_not_supported_paypal' => 'هذه العملة غير مدعومة من قبل PayPal لإجراء الدفعات.',
    ],

    // advanced payments keys
    'advanced_payment' => [
        'advanced_payment' => 'دفعه مقدمه',
        'advanced_payments' => 'دفعات مقدمة',
        'advanced_payment_details' => 'تفاصيل الدفع المسبق',
        'new_advanced_payment' => 'دفعة مقدمة جديدة',
        'edit_advanced_payment' => 'تحرير الدفع المسبق',
        'patient' => 'صبور',
        'receipt_no' => 'رقم الإيصال',
        'amount' => 'كمية',
        'date' => 'تاريخ',
        'patient_name' => 'اسم المريض',
    ],

    // beds keys
    'bed' => [
        'bed' => 'سرير جديد',
        'beds' => 'سرير',
        'bed_details' => 'تفاصيل السرير',
        'new_bed' => 'سرير جديد',
        'edit_bed' => 'تحرير السرير',
        'new_bulk_bed' => 'سرير ضخم جديد',
        'name' => 'اسم',
        'bed_type' => 'نوع السرير',
        'charge' => 'الشحنة',
        'available' => 'متاح',
        'not_available' => 'غير متوفر',
        'description' => 'وصف',
        'add' => 'أضف',
        'bed_id' => 'معرف السرير',
        'select_bed_type' => 'حدد نوع السرير',
        'bed_charge' => 'رسوم السرير',
    ],

    // bed types keys
    'bed_type' => [
        'bed_type' => 'نوع السرير',
        'bed_types' => 'أنواع السرير',
        'bed_type_details' => 'تفاصيل نوع السرير',
        'new_bed_type' => 'نوع سرير جديد',
        'edit_bed_type' => 'تحرير نوع السرير',
        'title' => 'عنوان',
        'description' => 'وصف',
    ],

    'doctor' => [
        'new_doctor' => 'دكتور جديد',
        'edit_doctor' => 'تحرير الطبيب',
        'doctor_details' => 'تفاصيل الطبيب',
        'specialist' => 'متخصص',
        'doctor_name_already_taken' => 'لقد تم بالفعل أخذ اسم الطبيب',
        'appointment_charge' => 'رسوم التعيين',
    ],

    // bed assigns keys
    'bed_assign' => [
        'bed_assign' => 'تعيين السرير',
        'bed_assigns' => 'تعيينات السرير',
        'bed_assign_details' => 'تفاصيل تعيين السرير',
        'new_bed_assign' => 'تعيين سرير جديد',
        'edit_bed_assign' => 'تحرير تعيين السرير',
        'patient_name' => 'اسم المريض',
        'bed_name' => 'اسم السرير',
        'case_id' => 'ID القضية',
        'assign_date' => 'تعيين التاريخ',
        'discharge_date' => 'تاريخ التفريغ',
        'bed' => 'السرير',
        'description' => 'وصف',
        'assigned' => 'تعيين',
        'not_assigned' => 'غيرمعتمد',
        'ipd_patient_id' => 'معرف المريض IPD',
        'assign_date_should_not_be_smaller_than_patient_birth_date' => 'يجب ألا يكون تاريخ التعيين أصغر من تاريخ ميلاد المريض.',
        'ipd_patient_department_field_required' => 'حقل قسم مريض IPD مطلوب',
    ],

    // packages keys
    'package' => [
        'package' => 'صفقة',
        'packages' => 'الحزم',
        'package_details' => 'حزمة من التفاصيل',
        'new_package' => 'حزمة جديدة',
        'edit_package' => 'تحرير الحزمة',
        'name' => 'اسم',
        'description' => 'وصف',
        'discount' => 'خصم',
        'total_amount' => 'المبلغ الإجمالي',
        'service' => 'الخدمات',
        'qty' => 'الكمية',
        'rate' => 'معدل',
        'amount' => 'كمية',
        'select_service' => 'حدد الخدمة',
    ],

    // bills keys
    'bill' => [
        'print_bill' => 'طباعة الفاتورة',
        'bill_id' => 'معرف الفاتورة',
        'bill' => 'مشروع قانون',
        'bills' => 'فواتير',
        'bill_details' => 'تفاصيل الفاتورة',
        'new_bill' => 'مشروع قانون جديد',
        'edit_bill' => 'تحرير بيل',
        'patient' => 'صبور',
        'bill_date' => 'تاريخ الفاتورة',
        'amount' => 'كمية',
        'admission_id' => 'معرف القبول',
        'patient_name' => 'اسم المريض',
        'patient_email' => 'البريد الإلكتروني للمريض',
        'patient_cell_no' => 'رقم خلية المريض',
        'patient_gender' => 'جنس المريض',
        'patient_dob' => 'المريض DOB',
        'doctor_name' => 'اسم الطبيب',
        'admission_date' => 'تاريخ القبول',
        'discharge_date' => 'تاريخ التفريغ',
        'package_name' => 'اسم الحزمة',
        'insurance_name' => 'اسم التأمين',
        'total_days' => 'مجموع الأيام',
        'policy_no' => 'لا توجد سياسة',
        'item_name' => 'اسم العنصر',
        'qty' => 'الكمية',
        'price' => 'السعر',
        'add' => 'السعر',
        'total_amount' => 'المبلغ الإجمالي',
        'edit' => 'تعديل',
        'cell_no' => 'خلية لا',
        'bill_summary' => 'ملخص الفاتورة',
        'generate_bill' => 'توليد بيل',
        'update_bill' => 'تحديث الفاتورة',
        'calculate' => 'احسب',
        'manual_bill' => 'دفع الفواتير يدوياً',
        'transaction_date' => 'تاريخ الصفقة',
        'paymentrequest_sent' => 'تم إرسال طلب الدفع بنجاح',
        'manually' => 'يدويا',
        'stripe' => 'شريط',
        'approved' => 'موافقة',
        'rejected' => 'مرفوض',
        'are_you_sure' => 'هل أنت متأكد؟',
        'complete_this_payment' => 'تريد إكمال هذا الدفع يدويًا!!',
        'session_id_required' => 'معرف الجلسة مطلوب',
    ],

    // blood donors keys
    'blood_donor' => [
        'blood_donor' => 'متبرع بالدم',
        'blood_donors' => 'المتبرعين بالدم',
        'blood_donor_details' => 'تفاصيل المتبرعين بالدم',
        'new_blood_donor' => 'متبرع جديد بالدم',
        'edit_blood_donor' => 'تحرير متبرع بالدم',
        'name' => 'اسم',
        'age' => 'عمر',
        'gender' => 'جنس',
        'blood_group' => 'فصيلة الدم',
        'donation_date' => 'تاريخ التبرع',
        'last_donation_date' => 'تاريخ آخر تبرع',
    ],

    // blood banks keys
    'hospital_blood_bank' => [
        'blood_bank' => 'بنك الدم',
        'blood_banks' => 'بنوك الدم',
        'blood_bank_details' => 'تفاصيل بنك الدم',
        'new_blood_group' => 'فصيلة الدم الجديدة',
        'edit_blood_group' => 'تحرير فصيلة الدم',
        'blood_group' => 'فصيلة الدم',
        'remained_bags' => 'أكياس متبقية',
    ],

    //Case
    'case' => [
        'case' => 'قضية',
        'case_date' => 'تاريخ القضية',
        'new_case' => 'حالة جديدة',
        'edit_case' => 'تحرير الحالة',
        'case_details' => 'تفاصيل الحالة',
        'phone' => 'هاتف',
        'fee' => 'الرسوم',
        'patient' => 'صبور',
        'doctor' => 'طبيب',
        'case_id' => 'ID القضية',
        'date' => 'تاريخ',
        'description' => 'وصف',
        'case_date_should_not_be_smaller_than_patient_birth_date' => 'تاريخ الحالة يجب ألا يكون أقل من تاريخ ميلاد المريض',
    ],

    //services
    'service' => [
        'service' => 'خدمة',
        'new_service' => 'خدمة جديدة',
        'edit_service' => 'تحرير الخدمة',
        'service_details' => 'تفاصيل الخدمة',
        'quantity' => 'كمية',
        'rate' => 'معدل',
        'given' => 'معطى',
        'not_given' => 'غير معطى',
    ],

    //appointments
    'appointment' => [
        'new_appointment' => 'موعد جديد',
        'edit_appointment' => 'تحرير موعد',
        'appointment_details' => 'تفاصيل الموعد',
        'calendar_view' => 'عرض التقويم',
        'patient_name' => 'اسم المريض',
        'doctor_name' => 'اسم الطبيب',
        'department_name' => 'اسم القسم',
        'date' => 'تاريخ',
        'doctor_department' => 'قسم الطبيب',
        'doctor_department_name' => 'اسم قسم الطبيب',
        'doctor' => 'طبيب',
        'description' => 'وصف',
        'patient' => 'صبور',
        'appointment_calendar' => 'تقويم المواعيد',
        'appointment_list' => 'قائمة التعيين',
        'completed' => 'منجز',
        'pending' => 'قيد الانتظار',
        'available_slot' => 'الفتحة المتاحة',
        'no_available' => 'غير متاح',
        'today' => 'اليوم',
        'month' => 'شهر',
        'week' => 'أسبوع',
        'day' => 'يوم',
        'opd_date' => 'تاريخ Opd',
        'yesterday' => 'في الامس',
        'this_week' => 'هذا الاسبوع',
        'last_7_days' => 'اخر 7 ايام',
        'last_30_days' => 'آخر 30 يومًا',
        'this_month' => 'هذا الشهر',
        'last_month' => 'الشهر الماضي',
        'change_status' => 'تغيير الوضع',
        'are_you_sure_want_to_change' => 'هل أنت متأكد أنك تريد التغيير',
        'changed_appointment' => 'موعد تم تغييره',
        'has_been_changed' => 'تغير.',
        'are_you_sure_want_to_cancel' => 'هل أنت متأكد من أنك تريد الإلغاء',
        'has_been_cancelled' => 'تم إلغاء.',
        'please_select_doctor_department' => 'الرجاء تحديد قسم الطبيب',
        'please_select_doctor' => 'الرجاء تحديد دكتور',
        'doctor_schedule_not_available_on_this_date' => 'جدول الطبيب غير متوفر هذا التاريخ.',
        'please_select_appointment_time_slot' => 'الرجاء تحديد خانة وقت الموعد',
        'patient_not_exists_or_status_is_not_active' => 'المريض غير موجود أو الحالة غير نشطة.',
        'appointment_exists' => 'البريد الإلكتروني للمريض موجود بالفعل',
        'old_patient_email_exists' => 'البريد الإلكتروني موجود بالفعل ، يرجى تحديد المريض القديم.',
        'time' => 'وقت',
    ],

    'case_handler' => [
        'case_handler' => 'معالج الحالة',
        'new_case_handler' => 'معالج الحالة الجديد',
        'edit_case_handler' => 'تحرير معالج الحالة',
        'case_handler_detail' => 'تفاصيل معالج الحالة',
    ],

    'lab_tech' => [
        'lab_technician' => 'فني مختبر',
        'new_lab_tech' => 'فني مختبر جديد',
        'edit_lab_tech' => 'تحرير فني مختبر',
        'lab_tech_detail' => 'تفاصيل فني مختبر',
    ],

    'doc_type' => [
        'new_doc_type' => 'نوع مستند جديد',
        'edit_doc_type' => 'تحرير نوع المستند',
        'name' => 'اسم',
    ],

    'document' => [
        'document' => 'المستند',
        'new_document' => 'مستند جديد',
        'edit_document' => 'تحرير المستند',
        'title' => 'عنوان',
        'document_type' => 'نوع الوثيقة',
        'document_type_details' => 'تفاصيل نوع المستند',
        'patient' => 'صبور',
        'download' => 'تحميل',
        'select_patient' => 'حدد المريض',
        'select_document_type' => 'حدد نوع المستند',
        'document_detail' => 'تفاصيل الوثيقة',
        'notes' => 'ملاحظات',
        'attachment' => 'المرفق',
        'uploaded_by' => 'تم الرفع بواسطة',
        'document_detail' => 'تفاصيل المستند',
        'notes' => 'ملاحظات',
        'view' => 'عرض',
        'attachment' => 'المرفقات',
        'validate_doc_type' => 'يجب أن يكون المستند ملف من النوع: jpeg، jpg، png، pdf، doc، docx، webp',
        'select_attachment' => 'الرجاء تحديد المرفق.',
    ],

    'patient_admission' => [
        'patient_admission' => 'قبول المريض',
        'new_patient_admission' => 'قبول المريض الجديد',
        'edit_patient_admission' => 'تحرير قبول المريض',
        'details' => 'تفاصيل قبول المريض',
        'patient' => 'صبور',
        'patient_name' => 'اسم المريض',
        'doctor' => 'طبيب',
        'doctor_name' => 'اسم الطبيب',
        'admission_date' => 'تاريخ القبول',
        'discharge_date' => 'تاريخ التفريغ',
        'package' => 'صفقة',
        'package_name' => 'اسم الحزمة',
        'insurance' => 'تأمين',
        'insurance_name' => 'اسم التأمين',
        'policy_no' => 'لا توجد سياسة',
        'bed' => 'السرير',
        'agent_name' => 'اسم العميل',
        'guardian_name' => 'اسم الوصي',
        'guardian_relation' => 'علاقة الوصي',
        'guardian_contact' => 'جهة اتصال الوصي',
        'guardian_address' => 'عنوان ولي الأمر',
        'patient_admission_id' => 'معرف قبول المريض',
        'admission_date_should_not_be_smaller_than_patient_birth_date' => 'تاريخ القبول يجب ألا يكون أصغر من تاريخ ميلاد المريض',
        'Admission_field_required' => 'حقل معرف القبول مطلوب.'
    ],

    'setting' => [
        'app_name' => 'اسم التطبيق',
        'company_name' => 'اسم الشركة',
        'app_logo' => 'شعار التطبيق',
        'currency' => 'العملة الحالية',
        'address' => 'عنوان المستشفى',
        'hospital_email' => 'بريد المستشفى الإلكتروني',
        'hospital_phone' => 'هاتف المستشفى',
        'hospital_from_day' => 'من يوم المستشفى',
        'hospital_from_time' => 'من وقت المستشفى',
        'about_us' => 'معلومات عنا',
        'image_validation' => 'يجب أن يكون حجم الصورة 90 × 60 بيكسل.',
        'favicon' => 'رمز الموقع',
        'favicon_validation' => 'يجب أن يكون حجم الصورة 34 × 34 بيكسل.',
        'social_details' => 'تفاصيل الوسائط الاجتماعية',
        'country_code' => 'رمز الدولة',
        'default_language' => 'اللغة الافتراضية',
    ],

    'currency' => [
        'currency' => 'عملة',
        'new_currency' => 'عملة جديدة',
        'edit_currency' => 'تحرير العملة',
        'currency_name' => 'اسم العملة',
        'currency_code' => 'رمز العملة',
        'currency_icon' => 'رمز العملة',
        'add_currency_code_as_per_three_letter_iso_code' => 'أضف رمز العملة وفقًا لرمز ISO المكون من ثلاثة أحرف.',
        'you_can_find_out_here' => 'يمكنك ان تجد هنا',
        'currency_setting_not_found' => 'لم يتم العثور على إعدادات العملة',
    ],

    'schedule' => [
        'new' => 'جدول جديد',
        'edit' => 'تحرير الجدول',
        'details' => 'تفاصيل الجدول',
        'doctor_name' => 'اسم الطبيب',
        'select_doctor_name' => 'حدد اسم الطبيب',
        'per_patient_time' => 'لكل مريض',
        'serial_visibility' => 'الرؤية التسلسلية',
        'select_serial_visibility' => 'حدد الرؤية التسلسلية',
        'available_on' => 'متاح على',
        'available_from' => 'متاح من',
        'available_to' => 'متاحة لل',
        'sequential' => 'تسلسلي',
        'timestamp' => 'الطابع الزمني',
        'schedule_time_select' => 'الرجاء تحديد وقت لكل مريض',
        'schedule_time' => 'وقت البدء يجب أن يكون أكبر من وقت جدول المستشفى',
        'available_time_greater_than_zero' => 'وقت البدء يجب أن يكون أكبر من الصفر',
        'available_to_time_greater_than_zero' => 'وقت الانتهاء يجب أن يكون أكبر من الصفر',
        'available_time_less_than_hospital_schedule_time' => 'وقت الانتهاء يجب أن يكون أقل من وقت جدول المستشفى',

    ],

    'notice_board' => [
        'notice_board' => 'لوح الإعلانات',
        'new' => 'لوحة الإعلانات الجديدة',
        'edit' => 'تحرير لوحة الإعلانات',
        'details' => 'تفاصيل لوحة الإعلانات',
        'title' => 'عنوان',
        'description' => 'وصف',
        'created_at' => 'أنشئت في',
    ],

    'my_payroll' => [
        'my_payrolls' => 'رواتبي',
        'basic_salary' => 'راتب اساسي',
        'allowance' => 'Allowance',
        'deductions' => 'الخصومات',
        'net_salary' => 'صافي الراتب',
    ],

    'medicine' => [
        'medicine' => 'دواء',
        'medicine_category' => 'فئة الطب',
        'medicine_category_details' => 'تفاصيل فئة الدواء',
        'medicines' => 'أدوية',
        'medicine_details' => 'تفاصيل الدواء',
        'new_medicine' => 'الطب الجديد',
        'new_medicine_category' => 'فئة الطب الجديد',
        'edit_medicine_category' => 'تحرير فئة الدواء',
        'edit_medicine' => 'تحرير الطب',
        'name' => 'اسم',
        'brand' => 'العلامة التجارية',
        'selling_price' => 'سعر البيع',
        'buying_price' => 'سعر الشراء',
        'category' => 'فئة',
        'salt_composition' => 'تكوين الملح',
        'side_effects' => 'آثار جانبية',
        'description' => 'وصف',
        'category_id' => 'معرف الفئة',
        'brand_name' => 'اسم العلامة التجارية',
        'medicine_brands_details' => 'تفاصيل العلامة التجارية للأدوية',
        'new_brand' => 'العلامة التجارية الجديدة',
        'new_medicine_brand' => 'العلامة التجارية للطب الجديد',
        'edit_medicine_brand' => 'تعديل العلامة التجارية للطب',
        'medicine_brands' => 'ماركات الطب',
        'medicine_brands_details' => 'تفاصيل علامة الدواء',
        'new_brand' => 'علامة جديدة',
        'new_medicine_brand' => 'علامة دواء جديدة',
        'edit_medicine_brand' => 'تحرير علامة الدواء',
        'select_category' => 'اختر الفئة',
        'select_brand' => 'اختر العلامة',
        'is_active' => 'نشط',
        'delete_medicine' => 'هذا الدواء مستخدم بالفعل في فواتير الأدوية. هل أنت متأكد من رغبتك في حذفه؟',
        'category_field_required' => 'حقل الفئة مطلوب',
        'brand_field_required' => 'حقل العلامة التجارية مطلوب.',
    ],

    'profile' => [
        'change_language' => 'تغيير اللغة',
        'language' => 'لغة',
        'edit_profile' => 'تعديل الملف الشخصي',
        'first_name' => 'الاسم الأول',
        'last_name' => 'الكنية',
        'email' => 'بريد إلكتروني',
        'phone' => 'هاتف',
        'profile' => 'الملف الشخصي',
    ],

    'dashboard' => [
        'dashboard' => 'لوحة القيادة',
        'total_invoices' => 'المبلغ الإجمالي للفاتورة',
        'total_bills' => 'إجمالي مبلغ الفاتورة',
        'total_payments' => 'المبلغ الإجمالي للدفع',
        'total_advance_payments' => 'المبلغ الإجمالي للدفع المسبق',
        'notice_boards' => 'لافتات تنبيه',
        'title' => 'عنوان',
        'doctors' => 'الأطباء',
        'available_beds' => 'الأسرة المتاحة',
        'patients' => 'المرضى',
        'income_and_expense_report' => 'تقرير الدخل والمصروفات',
        'income_and_expense_reports' => 'تقارير الدخل والمصروفات',
        'no_enquiries_yet' => 'لا توجد استفسارات حتى الآن',
        'no_notice_yet' => 'لا إشعار حتى الآن',
        'total_appointment' => 'إجمالي التعيينات',
        'today_appointment' => 'اليوم موعد',
        'total_meeting' => 'إجمالي الاجتماعات',
        'sum_of_ipd' => 'مبلغ IPD المستحق',
        'recent_appointments' => 'المواعيد الأخيرة',
    ],

    // enquiries keys
    'enquiry' => [
        'name' => 'اسم',
        'email' => 'البريد الإلكتروني',
        'contact' => 'اتصل',
        'type' => 'اكتب',
        'message' => 'رسالة',
        'viewed_by' => 'تم عرضها بواسطة',
        'enquiry_details' => 'تفاصيل الإستفسار',
        'read' => 'اقرأ',
        'unread' => 'غير مقروء',
        'not_viewed' => 'لم يشاهد',
        'received_on' => 'وردت في',
        'send_enquiry' => 'أرسل إستفسار',
        'enquiry_send_successfully' => 'أرسل الاستفسار بنجاح',
    ],

    'email' => [
        'to' => 'إلى',
        'subject' => 'موضوع',
        'message' => 'رسالة',
        'attachment' => 'المرفقات',
    ],

    'verification' => [
        'verify_your_email_address' => 'تحقق من عنوان بريدك الإلكتروني.',
        'verify_message' => 'قبل المتابعة ، يرجى التحقق من بريدك الإلكتروني بحثًا عن رابط التحقق. إذا لم تستلم البريد الإلكتروني ،',
        'another_verify_request' => 'انقر هنا لطلب آخر',
        'click_button_for_verify_email' => 'الرجاء النقر فوق الزر أدناه للتحقق من عنوان بريدك الإلكتروني.',
        'further_action_required' => 'إذا لم تقم بإنشاء حساب، فلا يلزم اتخاذ أي إجراء آخر.',
        'verify_email_address' => 'التحقق من عنوان البريد الإلكتروني',
    ],

    // ambulances keys
    'ambulance' => [
        'ambulance' => 'سيارة إسعاف',
        'ambulances' => 'سيارات الإسعاف',
        'ambulance_details' => 'تفاصيل سيارة الإسعاف',
        'vehicle_number' => 'رقم المركبة',
        'vehicle_model' => 'موديل المركبة',
        'year_made' => 'سنة الصنع',
        'driver_name' => 'اسم السائق',
        'driver_license' => 'رخصة القيادة',
        'driver_contact' => 'الاتصال بالسائق',
        'note' => 'مذكرة',
        'vehicle_type' => 'نوع المركبة',
        'is_available' => 'متاح',
        'new_ambulance' => 'سيارة إسعاف جديدة',
        'edit_ambulance' => 'تحرير سيارة إسعاف',
    ],

    // ambulance calls keys
    'ambulance_call' => [
        'ambulance_call' => 'نداء إسعاف',
        'ambulance_calls' => 'مكالمات الإسعاف',
        'ambulance_call_details' => 'تفاصيل مكالمة سيارة إسعاف',
        'vehicle_model' => 'موديل المركبة',
        'patient' => 'صبور',
        'driver_name' => 'اسم السائق',
        'date' => 'تاريخ',
        'amount' => 'كمية',
        'new_ambulance_call' => 'مكالمة إسعاف جديدة',
        'edit_ambulance_call' => 'تحرير مكالمة الإسعاف',
    ],

    // prescription keys
    'prescription' => [
        'reference_id' => 'الرقم المرجعي',
        'prescription' => 'وصفة طبية',
        'prescriptions' => 'الوصفات الطبية',
        'prescription_details' => 'تفاصيل الوصفة الطبية',
        'new_prescription' => 'وصفة طبية جديدة',
        'edit_prescription' => 'تحرير الوصفة الطبية',
        'patient' => 'صبور',
        'food_allergies' => 'حساسية الطعام',
        'tendency_bleed' => 'تيار النزف',
        'heart_disease' => 'مرض القلب',
        'high_blood_pressure' => 'ضغط دم مرتفع',
        'diabetic' => 'مريض بالسكر',
        'surgery' => 'الجراحة',
        'accident' => 'حادث',
        'others' => 'الآخرين',
        'medical_history' => 'تمت الإضافة عند',
        'current_medication' => 'الدواء الحالي',
        'female_pregnancy' => 'الحمل الأنثوي',
        'breast_feeding' => 'الرضاعة الطبيعية',
        'health_insurance' => 'تأمين صحي',
        'low_income' => 'دخل منخفض',
        'reference' => 'مرجع',
        'physical_information' => 'المعلومات المادية',
        'new_medicine' => 'الطب الجديد',
        'plus_rate' => 'معدل نبض',
        'temperature' => 'درجة الحرارة',
        'problem_description' => 'وصف المشكلة',
        'test' => 'اختبار',
        'advice' => 'النصيحة',
        'next_visit' => 'في المرة القادمة',
        'time' => 'زمن',
        'comment' => 'تعليق',
        'problem' => 'مشكلة',
        'rx' => 'آر إكس',
        'medicine_name' => 'اسم_الطب',
        'duration' => 'مدة',
        'year' => 'عام',
        'month' => 'شهر',
        'after_meal' => 'بعد الوجبة',
        'before_meal' => 'قبل الوجبة',
        'no_data_available' => 'لاتوجد بيانات',
    ],

    'charge_category' => [
        'charge_categories' => 'فئات الرسوم',
        'new_charge_category' => 'فئة الشحن الجديدة',
        'edit_charge_category' => 'تحرير فئة الرسوم',
        'charge_type' => 'نوع التهمة',
        'charge_category_details' => 'تفاصيل فئة الشحن',
    ],

    'charge' => [
        'new_charge' => 'تهمة جديدة',
        'edit_charge' => 'تحرير المسؤول',
        'charge_details' => 'تفاصيل الرسوم',
        'charge_category' => 'فئة الشحن',
        'standard_charge' => 'المسؤول القياسي',
        'code' => 'الشفرة',
    ],

    // radiology keys
    'radiology_category' => [
        'name' => 'اسم',
        'radiology_categories' => 'فئات الأشعة',
        'new_radiology_category' => 'فئة الأشعة الجديدة',
        'edit_radiology_category' => 'تحرير فئة الأشعة',
    ],

    // pathology keys
    'pathology_category' => [
        'pathology_categories' => 'فئات علم الأمراض',
        'new_pathology_category' => 'فئة علم الأمراض الجديدة',
        'edit_pathology_category' => 'تحرير فئة علم الأمراض',
        'name' => 'اسم',
        'select_charge_category' => 'حدد فئة الشحن',
    ],

    // radiology test keys
    'radiology_test' => [
        'radiology_tests' => 'اختبارات الأشعة',
        'new_radiology_test' => 'اختبار أشعة جديد',
        'edit_radiology_test' => 'تحرير اختبار الأشعة',
        'radiology_test_details' => 'تفاصيل اختبار الأشعة',
        'test_name' => 'اسم الاختبار',
        'short_name' => 'اسم قصير',
        'test_type' => 'نوع الاختبار',
        'category_name' => 'اسم التصنيف',
        'subcategory' => 'تصنيف فرعي',
        'report_days' => 'أيام التقرير',
        'charge_category' => 'فئة الشحن',
        'code' => 'شفرة',
        'standard_charge' => 'المسؤول القياسي',
    ],

    //doctor opd charge keys
    'doctor_opd_charge' => [
        'doctor_opd_charge' => 'طبيب العيادات الخارجية المسؤول',
        'new_doctor_opd_charge' => 'طبيب جديد رسوم OPD',
        'edit_doctor_opd_charge' => 'تحرير تهمة طبيب OPD',
        'doctor_name' => 'اسم الطبيب',
        'standard_charge' => 'المسؤول القياسي',
        'doctor' => 'طبيب',
    ],

    // pathology test keys
    'pathology_test' => [
        'pathology_tests' => 'اختبارات علم الأمراض',
        'new_pathology_test' => 'اختبار باثولوجي جديد',
        'edit_pathology_test' => 'تحرير اختبار علم الأمراض',
        'pathology_test_details' => 'تفاصيل اختبار علم الأمراض',
        'test_name' => 'اسم الاختبار',
        'short_name' => 'اسم قصير',
        'test_type' => 'نوع الاختبار',
        'category_name' => 'اسم التصنيف',
        'unit' => 'وحدة',
        'subcategory' => 'تصنيف فرعي',
        'method' => 'طريقة',
        'report_days' => 'أيام التقرير',
        'charge_category' => 'فئة الشحن',
        'standard_charge' => 'المسؤول القياسي',
    ],

    //expenses keys
    'expense' => [
        'expense' => 'مصروف',
        'new_expense' => 'نفقة جديدة',
        'edit_expense' => 'تحرير المصاريف',
        'expense_head' => 'رئيس المصاريف',
        'name' => 'اسم',
        'date' => 'تاريخ',
        'invoice_number' => 'رقم الفاتورة',
        'amount' => 'كمية',
        'attachment' => 'المرفق',
        'description' => 'وصف',
        'choose' => 'أختر',
        'download' => 'تحميل',
        'select_expense_head' => 'حدد رأس النفقات',
        'expense_details' => 'تفاصيل المصاريف',
        'document_error' => 'يجب أن تكون الوثيقة من نوع: jpeg، jpg، png، pdf، doc، docx.',
    ],

    //income keys
    'incomes' => [
        'incomes' => 'الدخل',
        'new_income' => 'دخل جديد',
        'edit_income' => 'تحرير الدخل',
        'income_head' => 'رئيس الدخل',
        'name' => 'اسم',
        'date' => 'تاريخ',
        'invoice_number' => 'رقم الفاتورة',
        'amount' => 'كمية',
        'attachment' => 'المرفق',
        'description' => 'وصف',
        'choose' => 'أختر',
        'download' => 'تحميل',
        'select_income_head' => 'حدد رأس الدخل',
        'income_details' => 'تفاصيل الدخل',
        'document_error' => 'يجب أن تكون الوثيقة من نوع: jpeg، jpg، png، pdf، doc، docx.',
    ],

    'bed_status' => [
        'bed_status' => 'حالة السرير',
        'assigned_beds' => 'أسرة مخصصة',
        'available_beds' => 'الأسرة المتاحة',
        'bed_name' => 'اسم السرير',
        'patient_name' => 'اسم المريض',
        'phone' => 'هاتف',
        'admission_date' => 'تاريخ القبول',
        'gender' => 'جنس',
    ],

    //Messages keys
    'message' => [
        'message' => 'رسالة',
        'messages' => 'الرسائل',
        'send_to' => 'ارسل إلى',
        'subject' => 'موضوع',
        'new_message' => 'رسالة جديدة',
        'messages_details' => 'تفاصيل الرسالة',
        'sender_name' => 'اسم المرسل',
        'date' => 'تاريخ',
        'select_user' => 'اختر المستخدم',
    ],

    //SMS keys
    'sms' => [
        'sms' => 'سامس',
        'new_sms' => 'رسائل جديدة',
        'send_to' => 'ارسل إلى',
        'phone_number' => 'رقم الهاتف',
        'send_by' => 'أرسل بواسطة',
        'message' => 'رسالة',
        'sms_details' => 'تفاصيل الرسائل القصيرة',
        'date' => 'تاريخ',
        'send' => 'إرسال',
        'role' => 'وظيفة',
        'send_sms_by_number_directly' => 'إرسال الرسائل القصيرة بالرقم مباشرة',
        'only_user_with_registered_phone_will_display' => '(سيتم عرض المستخدمين الذين لديهم هاتف مسجل فقط.)',
        'message_not_greater_than_160_characters' => 'الرسالة يجب أن لا تزيد عن 160 حرفًا.',
        'set_credential' => 'الرجاء تعيين بيانات الاعتماد الخاصة بك',
    ],

    //Patient Diagnosis Test
    'patient_diagnosis_test' => [
        'diagnosis' => 'التشخيص',
        'diagnosis_test' => 'اختبارات التشخيص',
        'patient_diagnosis_test' => 'اختبارات تشخيص المرضى',
        'report_number' => 'رقم التقرير',
        'patient' => 'صبور',
        'doctor' => 'طبيب',
        'created_at' => 'أنشئت في',
        'action' => 'عمل',
        'new_patient_diagnosis_test' => 'اختبار تشخيص المريض الجديد',
        'edit_patient_diagnosis_test' => 'تحرير اختبار تشخيص المريض',
        'create_patient_diagnosis_test' => 'إنشاء اختبار تشخيص المريض',
        'patient_diagnosis_test_details' => 'تفاصيل اختبار تشخيص المريض',
        'diagnosis_category' => 'فئة التشخيص',
        'add_other_diagnosis_property' => 'أضف خاصية تشخيص أخرى',
        'other_diagnosis_property' => 'خاصية التشخيص الأخرى',
        'diagnosis_property_name' => 'اسم خاصية التشخيص',
        'diagnosis_property_value' => 'تشخيص قيمة العقار',
        'patient_name' => 'اسم المريض',
        'doctor_name' => 'اسم الطبيب',
        'age' => 'سن',
        'height' => 'ارتفاع',
        'weight' => 'وزن',
        'average_glucose' => 'متوسط الجلوكوز',
        'fasting_blood_sugar' => 'سكر الدم الصائم',
        'urine_sugar' => 'سكر البول',
        'blood_pressure' => 'ضغط الدم',
        'diabetes' => 'السكري',
        'cholesterol' => 'الكوليسترول',
        'print_diagnosis_test' => 'اختبار تشخيص الطباعة',
    ],

    //Diagnosis Category
    'diagnosis_category' => [
        'diagnosis_category' => 'فئة التشخيص',
        'diagnosis_categories' => 'فئة التشخيص',
        'new_diagnosis_category' => 'فئة التشخيص الجديدة',
        'description' => 'وصف',
        'category_name' => 'اسم التصنيف',
        'diagnosis_category_details' => 'تفاصيل فئة التشخيص',
        'edit_diagnosis_category' => 'تحرير فئة التشخيص',
    ],

    // Operation Category
    'operation_category' => [
        'operation_category' => 'فئة العملية',
        'operation_categories' => 'فئات العملية',
        'new_operation_category' => 'فئة عملية جديدة',
        'edit_operation_category' => 'تحرير فئة العملية',
        'operation_category_field_required' => 'حقل فئة العملية مطلوب.',
    ],

    // Operation
    'operation' => [
        'operation' => 'عملية',
        'operation_field_required' => 'مجال التشغيل مطلوب.',
        'select_operation_date' => 'الرجاء تحديد تاريخ العملية.',
        'operation_date' => 'تاريخ العملية',
        'operation_name' => 'اسم العملية',
        'operation_category_name' => 'اسم فئة العملية',
        'ot_technician' => 'فني تكنولوجيا المعلومات',
        'ot_assistant' => 'مساعد أو تي',
    ],

    // Inventory Management keys
    'item_category' => [
        'item_category' => 'العنصر فئة',
        'item_categories' => 'فئات العناصر',
        'new_item_category' => 'فئة عنصر جديد',
        'edit_item_category' => 'تحرير فئة العنصر',
        'name' => 'اسم',
    ],

    'item' => [
        'item' => 'بند',
        'items' => 'العناصر',
        'new_item' => 'عنصر جديد',
        'edit_item' => 'تعديل عنصر',
        'item_details' => 'تفاصيل العنصر',
        'name' => 'اسم',
        'item_category' => 'العنصر فئة',
        'unit' => 'وحدة',
        'description' => 'وصف',
        'available_quantity' => 'الكمية المتوفرة',
    ],

    'item_stock' => [
        'item_stock' => 'عنصر المخزون',
        'item_stocks' => 'مخزون البند',
        'new_item_stock' => 'مخزون عنصر جديد',
        'edit_item_stock' => 'تحرير مخزون العنصر',
        'item_stock_details' => 'تفاصيل مخزون العنصر',
        'item_category' => 'العنصر فئة',
        'item' => 'بند',
        'supplier_name' => 'اسم المورد',
        'store_name' => 'اسم المتجر',
        'quantity' => 'كمية',
        'purchase_price' => 'سعر الشراء',
        'description' => 'وصف',
        'attachment' => 'المرفق',
    ],

    'issued_item' => [
        'issued_item' => 'البند المصدر',
        'issued_items' => 'العناصر المصدرة',
        'new_issued_item' => 'عنصر جديد صادر',
        'edit_issued_item' => 'تحرير العنصر الذي تم إصداره',
        'issued_item_details' => 'تفاصيل الأصناف المصدرة',
        'department_id' => 'نوع المستخدم',
        'user_id' => 'إصدار ل',
        'issued_by' => 'إصدار بواسطة',
        'issued_date' => 'تاريخ الاصدار',
        'return_date' => 'تاريخ العودة',
        'item_category' => 'العنصر فئة',
        'item' => 'بند',
        'quantity' => 'كمية',
        'description' => 'وصف',
        'available_quantity' => 'الكمية المتوفرة',
        'item_return' => 'إرجاع البند',
        'item_returned' => 'عاد',
        'are_you_sure_want_to_return_this_item' => 'هل أنت متأكد من أنك تريد إرجاع هذا العنصر',
        'quantity_cannot_be_zero' => 'الكمية لا يمكن أن تكون صفراً.',
        'quantity_must_be_less_than_available_quantity' => 'يجب أن تكون الكمية أقل من الكمية المتاحة.',
    ],

    'ipd_patient' => [
        'ipd_patient_in' => 'IPD - المريض في',
        'ipd_patient' => 'مريض IPD',
        'ipd_patients' => 'مرضى IPD',
        'new_ipd_patient' => 'مريض IPD الجديد',
        'edit_ipd_patient' => 'تحرير المريض IPD',
        'ipd_patient_details' => 'تفاصيل المريض IPD',
        'patient_id' => 'صبور',
        'ipd_number' => 'IPD لا',
        'height' => 'ارتفاع',
        'weight' => 'وزن',
        'bp' => 'ضغط الدم',
        'symptoms' => 'الأعراض',
        'notes' => 'ملاحظات',
        'admission_date' => 'تاريخ القبول',
        'case_id' => 'قضية',
        'is_old_patient' => 'مريض قديم',
        'doctor_id' => 'طبيب',
        'bed_type_id' => 'نوع السرير',
        'bed_id' => 'السرير',
        'bill_status' => 'حالة الفاتورة',
        'the_case_field_is_required' => 'حقل الحالة مطلوب.',
        'the_bed_field_is_required' => 'حقل السرير مطلوب.',
        'the_bed_field_has_a_duplicate_value' => 'يحتوي حقل السرير على قيمة مكررة',
        'the_bed_already_taken' => 'السرير: تم أخذ الإدخال بالفعل',
        'the_bed_type_is_required' => 'حقل نوع السرير مطلوب.',
        'charge_required' => 'حقل الشحن مطلوب.',
        'discharge' => 'تسريح',
        'net_amount' => 'كمية الشبكة',
        'discharged' => 'خرج',
        'not_dischared' => 'لم يتم تفريغها',
        'discharge_slip' => 'زلة التفريغ',
        'print_discharge_slip' => 'طباعة قسيمة التفريغ',
    ],

    'ipd_patient_diagnosis' => [
        'new_ipd_diagnosis' => 'أضف التشخيص',
        'edit_ipd_diagnosis' => 'تحرير التشخيص',
        'report_type' => 'نوع التقرير',
        'report_date' => 'تاريخ التقرير',
        'document' => 'وثيقة',
        'description' => 'وصف',
    ],

    'ipd_patient_consultant_register' => [
        'consultant_instruction' => 'تعليمات استشاري',
        'consultant_doctor' => 'طبيب استشاري',
        'new_consultant_register' => 'أضف تعليمات استشاري',
        'edit_consultant_register' => 'تحرير تعليمات المستشار',
        'applied_date' => 'تاريخ التطبيق',
        'doctor_id' => 'طبيب',
        'instruction' => 'تعليمات',
        'instruction_date' => 'تاريخ التعليمات',
        'applied_date_or_Instruction_date_can_not_be_null' => 'لا يمكن أن يكون تاريخ التنفيذ أو تاريخ التطبيق فارغاً',
        'assistant_consultant_1' => 'مستشار مساعد 1',
        'assistant_consultant_2' => 'مستشار مساعد 2',
        'anesthetist' => 'طبيب التخدير',
        'anesthesia_type' => 'نوع التخدير',
        'instruction_field_is_required' => 'حقل التعليمات مطلوب.',
    ],

    'ipd_patient_charges' => [
        'new_charge' => 'أضف الرسوم',
        'edit_charge' => 'تحرير الرسوم',
        'date' => 'تاريخ',
        'charge_type_id' => 'نوع التهمة',
        'charge_category_id' => 'فئة الشحن',
        'charge_id' => 'الشفرة',
        'standard_charge' => 'الشحن القياسي',
        'applied_charge' => 'الرسوم التطبيقية',
    ],

    'ipd_operation' => [
        'ipd_operation' => 'عملية IPD',
        'ipd_operation_created_successfully' => 'تم إنشاء عملية IPD بنجاح',
    ],

    'ipd_patient_prescription' => [
        'ipd_no' => 'IPD لا',
        'header_note' => 'ملاحظة رأس',
        'footer_note' => 'ملاحظة التذييل',
        'new_prescription' => 'إضافة وصفة طبية',
        'edit_prescription' => 'تحرير الوصفة الطبية',
        'prescription_details' => 'تفاصيل الوصفة',
        'category_id' => 'فئة الطب',
        'medicine_id' => 'الدواء',
        'dosage' => 'الجرعة',
        'instruction' => 'تعليمات',
        'print_prescription' => 'وصفة طبية مطبوعة',
    ],

    'ipd_patient_timeline' => [
        'timeline' => 'الجدول الزمني',
        'new_ipd_timeline' => 'أضف الجدول الزمني',
        'edit_ipd_timeline' => 'تحرير الجدول الزمني',
        'title' => 'عنوان',
        'date' => 'تاريخ',
        'description' => 'وصف',
        'document' => 'وثيقة',
        'visible_to_person' => 'مرئي للشخص',
        'no_timeline_found' => 'لم يتم العثور على خط زمني',
    ],

    'ipd_payments' => [
        'add_ipd_payment' => 'إضافة دفع Ipd',
        'edit_ipd_payment' => 'تحرير دفع IPD',
        'payment_mode' => 'طريقة الدفع',
        'make_payment' => 'قم بالدفع',
    ],

    'ipd_bill' => [
        'paid_amount' => 'المبلغ المدفوع',
        'total_charges' => 'الكلفة الاجماليه',
        'gross_total' => 'المجموع الكلي',
        'discount_in_percentage' => 'نسبة الخصم',
        'discount_in_number' => 'الخصم في العدد',
        'tax_in_percentage' => 'الضريبة بالنسبة المئوية',
        'tax_in_number' => 'رقم الضريبة',
        'other_charges' => 'رسوم أخرى',
        'net_payable_amount' => 'صافي المبلغ المستحق',
        'discharge_patient' => 'خروج المريض',
    ],

    'opd_patient' => [
        'opd_patient_out' => 'العيادات الخارجية - المريض بالخارج',
        'opd_patient' => 'مريض العيادات الخارجية',
        'opd_patients' => 'مرضى العيادات الخارجية',
        'new_opd_patient' => 'مريض العيادات الخارجية الجديد',
        'edit_opd_patient' => 'تحرير مريض العيادات الخارجية',
        'opd_patient_details' => 'تفاصيل مريض العيادات الخارجية',
        'opd_number' => 'OPD لا',
        'appointment_date' => 'تاريخ الموعد',
        'visits' => 'الزيارات',
        'revisits' => 'إعادة النظر',
        'total_visits' => 'إجمالي عدد الزيارات',
    ],

    'opd_payments' => [
        'add_opd_payment' => 'إضافة دفع Opd',
        'edit_opd_payment' => 'تحرير دفع Opd',
        'payment_mode' => 'طريقة الدفع',
        'make_payment' => 'قم بالدفع',
    ],

    'call_log' => [
        'call_log' => 'سجل المكالمات',
        'new' => 'سجل المكالمات الجديد',
        'edit' => 'تحرير سجل المكالمات',
        'name' => 'اسم',
        'phone' => 'هاتف',
        'received_on' => 'وردت في',
        'description' => 'وصف',
        'follow_up_date' => 'متابعة التاريخ',
        'note' => 'ملحوظة',
        'call_type' => 'نوع الاتصال',
        'incoming' => 'واردة',
        'outgoing' => 'منفتح',
    ],

    'visitor' => [
        'visitor' => 'زائر',
        'new' => 'زائر جديد',
        'edit' => 'تحرير الزائر',
        'name' => 'اسم',
        'purpose' => 'غرض',
        'phone' => 'هاتف',
        'id_card' => 'بطاقة التعريف',
        'number_of_person' => 'عدد الأشخاص',
        'date' => 'تاريخ',
        'in_time' => 'في الوقت المناسب',
        'out_time' => 'وقت خروج',
        'note' => 'ملحوظة',
    ],

    'postal' => [
        'postal' => 'بريدي',
        'new_receive' => 'استلام جديد',
        'new_dispatch' => 'ديسباتش جديد',
        'dispatch' => 'إيفاد',
        'receive' => 'تسلم',
        'edit_receive' => 'تحرير تلقي',
        'edit_dispatch' => 'تحرير الإرسال',
        'to_title' => 'إلى العنوان',
        'from_title' => 'من العنوان',
        'reference_no' => 'رقم المرجع',
        'date' => 'تاريخ',
        'address' => 'عنوان',
        'validate_from_title' => 'عنوان المرسل مطلوب',
        'validate_to_title' => 'عنوان المستقبل مطلوب',
    ],

    'testimonial' => [
        'testimonial' => 'شهادة',
        'new_testimonial' => 'شهادة جديدة',
        'edit_testimonial' => 'تحرير شهادة',
        'testimonial_detail' => 'تفاصيل الشهادة',
        'name' => 'اسم',
        'description' => 'وصف',
        'profile_error' => 'يجب أن يكون الملف من النوع: jpg، jpeg، png.',
    ],

    'blood_donation' => [
        'blood_donation' => 'تبرع بالدم',
        'new_blood_donation' => 'التبرع بالدم الجديد',
        'edit_blood_donation' => 'تحرير التبرع بالدم',
        'donor_name' => 'اسم المتبرع',
        'bags' => 'أكياس',
        'last_donate_date' => 'تاريخ آخر تبرع',
    ],

    'blood_issue' => [
        'blood_issue' => 'مشكلة الدم',
        'new_blood_issue' => 'قضية دم جديدة',
        'edit_blood_issue' => 'تحرير قضية الدم',
        'issue_date' => 'تاريخ الاصدار',
        'patient_name' => 'اسم المريض',
        'doctor_name' => 'اسم الطبيب',
        'donor_name' => 'اسم المتبرع',
        'amount' => 'كمية',
        'remarks' => 'ملاحظات',
    ],

    'notification' => [
        'all_notification_read_successfully' => 'تمت قراءة جميع الإشعارات بنجاح',
        'notification_read_successfully' => 'تمت قراءة الإشعار بنجاح',
        'notifications' => 'إشعارات',
        'mark_all_as_read' => 'اشر عليها بانها قرات',
        'you_don`t_have_any_new_notification' => 'ليس لديك أي إخطار جديد',
    ],

    'live_consultation' => [
        'live_consultation' => 'استشارة مباشرة',
        'new_live_consultation' => 'استشارة مباشرة جديدة',
        'consultation_title' => 'عنوان الاستشارة',
        'consultation_date' => 'تاريخ الاستشارة',
        'consultation_duration_minutes' => 'مدة الاستشارة (بالدقائق)',
        'client_video' => 'فيديو العميل',
        'host_video' => 'فيديو المضيف',
        'enable' => 'تمكين',
        'disabled' => 'معطل',
        'type' => 'النوع',
        'type_number' => 'رقم النوع',
        'created_by' => 'تم الإنشاء بواسطة',
        'created_for' => 'تم الإنشاء لصالح',
        'new_live_meeting' => 'اجتماع مباشر جديد',
        'staff_list' => 'قائمة الموظفين',
        'edit_live_consultation' => 'تعديل الاستشارة المباشرة',
        'duration' => 'المدة (بالدقائق)',
        'start_now' => 'ابدأ الآن',
        'join_now' => 'انضم الآن',
        'edit_live_meeting' => 'تعديل الاجتماع المباشر',
        'add_credential' => 'إضافة اعتماد',
        'zoom_api_key' => 'مفتاح Zoom API',
        'zoom_api_secret' => 'سر Zoom API',
        'join_meeting' => 'الانضمام إلى الاجتماع',
        'start_meeting' => 'بدء الاجتماع',
        'generate_auth_credentials' => 'كيفية إنشاء بيانات اعتماد المصادقة؟',
        'user_zoom_credential_saved' => 'تم حفظ بيانات اعتماد Zoom للمستخدم بنجاح.',
        'add_credentials_for_zoom_meeting' => 'يرجى إضافة بيانات اعتماد لاجتماع Zoom.',
        'credentials_already_use' => 'بيانات اعتماد التكبير/التصغير الخاصة بك قيد الاستخدام بالفعل',
        'connect_with_zoom' => 'يجب عليك التواصل مع التكبير',
        'cannot_delete_meeting_in_progress' => 'عذرًا، لا يمكنك حذف هذا الاجتماع لأنه قيد التقدم',
        'select_platform' => 'حدد النظام الأساسي',
    ],

    'vaccination' => [
        'vaccinations' => 'التطعيمات',
        'new_vaccination' => 'تطعيم جديد',
        'edit_vaccination' => 'تحرير التطعيم',
        'name' => 'اسم',
        'manufactured_by' => 'صنع بواسطة',
        'brand' => 'ماركة',
        'vaccinated' => 'تلقيح',
    ],

    'vaccinated_patient' => [
        'vaccinated_patient' => 'تم تطعيم المريض',
        'patient' => 'مريض',
        'vaccination' => 'تلقيح',
        'serial_no' => 'الرقم التسلسلي',
        'does_no' => 'جرعة لا',
        'dose_given_date' => 'تاريخ إعطاء الجرعة',
        'description' => 'وصف',
        'add_vaccinate_patient' => 'اضافة لقاح للمريض',
        'new_vaccinate_patient' => 'لقاح جديد للمريض',
        'edit_vaccinate_patient' => 'تحرير لقاح المريض',
        'vaccine' => 'مصل',
        'vaccinate_patient' => 'تطعيم المريض',
        'already_registered_dose' => 'المريض مسجل بالفعل بنفس اللقاح ورقم الجرعة',
    ],

    'front_setting' => [
        'about_us_title' => 'لقب',
        'about_us_mission' => 'مهمة',
        'about_us_image' => 'صورة',
        'about_us_description' => 'وصف',
        'terms_conditions' => 'البنود و الظروف',
        'about_us_details' => 'من نحن التفاصيل',
        'appointment_details' => 'تفاصيل الموعد',
        'terms_condition_details' => 'تفاصيل الشروط والأحكام',
        'front_setting_details' => 'تفاصيل الإعداد الأمامي',
        'home_page_image' => 'صورة الصفحة الرئيسية',
        'home_page_title' => 'الصفحة الرئيسية عنوان',
        'home_page_description' => 'وصف الصفحة الرئيسية',
        'home_page_box_title' => 'عنوان مربع الصفحة الرئيسية',
        'home_page_box_description' => 'وصف مربع الصفحة الرئيسية',
        'home_page_experience' => 'تجربة الصفحة الرئيسية',
        'home_page_step_1_title' => 'الصفحة الرئيسية الخطوة 1 العنوان',
        'home_page_step_1_description' => 'الصفحة الرئيسية الخطوة 1 الوصف',
        'home_page_step_2_title' => 'الصفحة الرئيسية الخطوة 2 العنوان',
        'home_page_step_2_description' => 'الصفحة الرئيسية الخطوة 2 الوصف',
        'home_page_step_3_title' => 'الصفحة الرئيسية الخطوة 3 العنوان',
        'home_page_step_3_description' => 'الصفحة الرئيسية الخطوة 3 الوصف',
        'home_page_step_4_title' => 'الصفحة الرئيسية الخطوة 4 العنوان',
        'home_page_step_4_description' => 'الصفحة الرئيسية الخطوة 4 الوصف',
        'privacy_policy' => 'سياسة الخصوصية',
        'home_page_certified_doctor_image' => 'الصفحة الرئيسية صورة طبيب معتمد',
        'home_page_certified_doctor_text' => 'الصفحة الرئيسية نص طبيب معتمد',
        'home_page_certified_doctor_title' => 'الصفحة الرئيسية لقب طبيب معتمد',
        'home_page_certified_doctor_description' => 'الصفحة الرئيسية وصف طبيب معتمد',
        'home_page_certified_box_title' => 'عنوان مربع معتمد للصفحة الرئيسية',
        'home_page_certified_box_description' => 'وصف مربع معتمد للصفحة الرئيسية',
        'the_terms_conditions_is_required' => 'حقل الشروط والأحكام مطلوب.',
        'the_privacy_policy_is_required' => 'حقل سياسة الخصوصية مطلوب.',
        'home_page_experience_required' => 'حقل تجربة الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_title_required' => 'حقل عنوان الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_description_required' => 'حقل وصف الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_box_required' => 'حقل عنوان صندوق الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_box_descriptions_required' => 'حقل وصف صندوق الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_certified_required' => 'حقل نص الطبيب المعتمد على الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_certified_title_required' => 'حقل عنوان طبيب معتمد على الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_certified_doctor_description_required' => 'حقل وصف الطبيب المعتمد على الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_certified_box_title_required' => 'حقل عنوان صندوق الطبيب المعتمد على الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_certified_description_required' => 'حقل وصف الطبيب المعتمد على الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_step_title_required' => 'حقل عنوان الخطوة 1 على الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_step_description_required' => 'حقل وصف الخطوة 1 على الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_step_two_title_required' => 'حقل عنوان الخطوة 2 على الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_step_two_description_required' => 'حقل وصف الخطوة 2 على الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_step_three_title_required' => 'حقل عنوان الخطوة 3 على الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_step_three_description_required' => 'حقل وصف الخطوة 3 على الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_step_four_title_required' => 'حقل عنوان الخطوة 4 على الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'home_page_step_four_description_required' => 'حقل وصف الخطوة 4 على الصفحة الرئيسية لا يجب أن يحتوي على مساحة بيضاء فقط',
        'about_us_title_required' => 'حقل عنوان "من نحن" لا يجب أن يحتوي على مساحة بيضاء فقط',
        'about_us_description_required' => 'حقل وصف "من نحن" لا يجب أن يحتوي على مساحة بيضاء فقط',
        'about_us_mission_required' => 'حقل مهمة "من نحن" لا يجب أن يحتوي على مساحة بيضاء فقط',
    ],

    'change_password' => [
        'change_password' => 'تغيير كلمة المرور',
        'current_password' => 'كلمة السر الحالية',
        'new_password' => 'كلمة السر الجديدة',
        'confirm_password' => 'تأكيد كلمة المرور',
    ],

    'web_home' => [
        'home' => 'الصفحة الرئيسية',
        'services' => 'خدمات',
        'doctors' => 'الأطباء',
        'about_us' => 'معلومات عنا',
        'contact' => 'اتصل',
        'make_appointment' => 'حدد موعدا',
        'working_hours' => 'ساعات العمل',
        'testimonials' => 'الشهادات - التوصيات',
        'terms_of_service' => 'شروط الخدمة',
        'privacy_policy' => 'سياسة خاصة',
        'patients' => 'مرضى',
        'years_experience' => 'سنوات خبرة',
        'sign_up' => 'اشتراك',
        'available_doctors' => 'الأطباء المتاحون',
        'select_doctors' => 'حدد الأطباء',
        'contact_doctors' => 'اتصل بالطبيب',
        'contact_hospital' => 'اتصل بالمستشفى',
        'easy_solutions' => 'حلول سهلة',
        '4_easy_step_and_get_the_world_best_treatment' => '4 خطوات سهلة واحصل على أفضل علاج في العالم',
        'book_an_appointment' => 'احجز موعدًا',
        'select_doctor' => 'اختر دكتور',
        'book_now' => 'احجز الآن',
        'patients_beds' => 'أسرة المرضى',
        'doctors_nurses' => 'أطباء وممرضات',
        'happy_patients' => 'مرضى سعداء',
        'book_appointment' => 'موعد الكتاب',
        'our_services' => 'خدماتنا',
        'we_offer_different_services_to_improve_your_health' => 'نحن نقدم خدمات مختلفة لتحسين صحتك',
        'professional_doctors' => 'أطباء متخصصون',
        'we_are_experienced_healthcare_professionals' => 'نحن متخصصون في مجال الرعاية الصحية من ذوي الخبرة',
        'our_testimonials' => 'شهاداتنا',
        'what_our_patient_say_about_medical_treatments' => 'ماذا يقول مرضانا عن علاجاتنا الطبية',
        'professional_details' => 'تفاصيل احترافية'
    ],

    'web_password' => [
        'please_fill_all_the_required_fields' => 'يرجى ملء جميع الحقول المطلوبة.',
        'password_and_confirm_password_not_match' => 'كلمة المرور وتأكيد كلمة المرور غير متطابقين.',
    ],

    'web_contact' => [
        'call_today' => 'الدعوة اليوم',
        'open_hours' => 'ساعات مفتوحة',
        'our_location' => 'موقعنا',
        'send_us_a_message' => 'أرسل لنا رسالة',
        'your_name' => 'اسمك',
        'your_email' => 'بريدك الالكتروني',
        'phone_number' => 'رقم الهاتف',
        'select_enquiry' => 'حدد الاستفسار',
        'your_message' => 'رسالتك',
        'send_message' => 'أرسل رسالة',
        'enter_your_name' => 'أدخل أسمك',
        'enter_your_email' => 'أدخل بريدك الإلكتروني',
        'contact_no' => 'رقم الاتصال',
        'please_enter_your_phone_number' => 'يرجى إدخال رقم الهاتف الخاص بك',
        'write_your_message' => 'اكتب رسالتك',
        'type_your_message' => 'اكتب رسالتك',
    ],

    'web_menu' => [
        'about' => 'عن',
        'our_features' => 'ميزاتنا',
        'appointment' => 'ميعاد',
        'working_hours' => 'ساعات العمل',
        'login' => 'تسجيل الدخول',
        'useful_link' => 'رابط مفيد',
        'contact_information' => 'معلومات للتواصل',
        'copyright' => 'حقوق النشر',
        'all_rights_reserved_by' => 'جميع الحقوق محفوظة',
    ],

    'web_appointment' => [
        'make_an_appointment' => 'إحجز موعد',
        'call_now_and_get_a_free_consulting' => 'اتصل الآن واحصل على استشارة مجانية',
        'enter_your_first_name' => 'أدخل اسمك الأول',
        'enter_your_last_name' => 'أدخل اسمك الأخير',
        'enter_your_password' => 'ادخل رقمك السري',
        'enter_confirm_password' => 'أدخل تأكيد كلمة المرور',
        'select_department' => 'حدد القسم',
        'select_doctor' => 'اختر دكتور',
        'enter_description' => 'أدخل الوصف',
        'select_time' => 'حدد الوقت',
    ],

    'front_services' => [
        'new_service' => 'خدمة جديدة',
        'edit_service' => 'تحرير الخدمة',
        'select_icon_file' => 'الرجاء تحديد ملف الرمز',
    ],

    'web_working_hours' => [
        'opening_hours' => 'ساعات العمل',
        'no_yet_opening_hours' => 'لا توجد ساعات عمل بعد',
    ],

    'purchase_medicine' => [
        'purchase_number' => 'شراء رقم',
        'total' => 'المجموع',
        'discount' => 'تخفيض',
        'tax_amount' => 'قيمة الضريبة',
        'net_amount' => 'كمية الشبكة',
        'payment_mode' => 'طريقة الدفع',
        'payment_note' => 'مذكرة الدفع',
        'note' => 'ملحوظة',
        'purchase_medicine' => 'شراء الأدوية',
        'purchase_medicine_details' => 'تفاصيل شراء الدواء',
        'purchase_medicine_overview' => 'نظرة عامة على شراء الأدوية',
        'lot_no' => 'الكثير لا.',
        'tax' => 'ضريبة',
        'quantity' => 'كمية',
        'amount' => 'كمية',
        'expiry_date' => 'تاريخ الانتهاء',
        'other_details' => 'تفاصيل أخرى',
        'dose_duration' => 'مدة الجرعة',
        'medicine_purchased_successfully' => 'تم شراء الدواء بنجاح',
    ],

    'used_medicine' => [
        'used_medicine' => 'لطب المستعمل',
        'used_quantity' => 'الكمية المستخدمة',
        'used_at' => 'تستخدم في',
    ],

    'medicine_bills' => [
        'medicine_bills' => 'فواتير الطب',
        'medicine_bill' => 'فاتورة الطب',
        'edit_medicine_bill' => 'تحرير فاتورة الطب',
        'medicine_bill_details' => 'تفاصيل فاتورة الدواء',
        'dose_interval' => 'الفاصل الزمني للجرعة',
        'available_quantity' => 'الكمية المتوفرة من',
        'is' => 'يكون',
        'prescription_not_found' => 'الوصفة الطبية غير موجودة.',
        'medicine_not_selected' => 'الرجاء تحديد دواء واحد على الأقل.',
        'duplicate_medicine' => 'لا يمكن إضافة أدوية مكررة.',
        'payment_status' => 'حالة السداد',
        'sale_price' => 'سعر البيع',
        'add_medicine_bill' => 'اضافة فاتورة الدواء',
        'select_medicine' => 'اختر الطب',
        'update_quantity' => 'يجب أن تكون كمية التحديث أقل من الكمية السابقة.',
        'net_amount_not_empty' => 'لا يمكن أن يكون المبلغ الصافي فارغًا.',
        'net_amount_not_zero' => 'لا يمكن أن يكون المبلغ الصافي صفرًا.',
        'medicine_required' => 'حقل الطب مطلوب',
        'bill_number' => 'رقم الفاتوره',
        'payment_type' => 'نوع الدفع',
        'tax_amount_not_zero_or_empty' => 'مبلغ الضريبة لا يمكن أن يكون صفرًا أو فارغًا.',
        'medicine_required' => 'حقل الدواء مطلوب.',
        'bill_number' => 'رقم الفاتورة',
        'validate_discount' => 'يجب أن يكون الخصم أقل من المبلغ الإجمالي',
        'validate_tax' => 'يجب أن تكون الضرائب أقل من 100٪.',
        'quantity_cannot_be_zero' => 'الكمية لا يمكن أن تكون صفرًا أو فارغة.',
        'lot_number' => 'أدخل رقم الدُفعة',
        'sale_price' => 'أدخل سعر البيع',
        'purchase_price' => 'أدخل سعر الشراء',
        'validate_quantity' => 'يجب أن تكون الكمية أكبر من 0.',
        'quantity_required' => 'الرجاء إدخال الكمية.',
    ],
    // subscription plan
    'subscription_plans' => [
        'payment_type' => 'اختر نوع الدفع',
        'connect_with_zoom' => 'الاتصال مع Zoom',
        'connected' => 'متصل',
    ],

    'holiday' => [
        'holiday' => 'عطلة',
        'add_holiday' => 'إضافة عطلة',
        'doctor_holiday' => 'عطلات الأطباء',
        'service_category' => 'فئة الخدمة',
        'holiday_date' => 'تاريخ العطلة',
        'reason' => 'السبب',
        'holiday_already_is_exist' => 'العطلة موجودة بالفعل',
        'doctor_holiday_create' => 'تم حفظ عطلة الطبيب بنجاح',
        'you_are_not_allow_to_record' => 'يبدو أنك غير مسموح لك بالوصول إلى هذا السجل',
        'appointment_exists' => 'الموعد موجود لا يمكنك أخذ إجازة.',
    ],

    'lunch_break' => [
        'lunch_breaks' => 'فترات الاستراحة',
        'lunch_break' => 'فترة الاستراحة',
        'break_create' => 'تم حفظ الاستراحة بنجاح',
        'break_update' => 'تم تحديث الاستراحة بنجاح',
        'add_break' => 'إضافة فترة استراحة',
        'edit_break' => 'تعديل فترة الاستراحة',
        'break_already_is_exist' => 'الفترة موجودة بالفعل',
        'break_time_greater_than_zero' => 'وقت بدء الاستراحة يجب أن يكون أكبر من الصفر',
        'break_to_time_greater_than_zero' => 'وقت نهاية الاستراحة يجب أن يكون أكبر من الصفر',
        'break_to_time_greater_than_from_time' => 'وقت نهاية الاستراحة يجب أن يكون أكبر من وقت بدء الاستراحة',
        'every_day' => 'يومياً',
        'single_day' => 'يوم واحد',
        'date_required' => 'حقل التاريخ مطلوب.',
        'appointment_exists' => 'الموعد موجود، لا يمكنك أخذ استراحة.',
    ],

    'new_change' => [
        'pathology_units' => 'وحدات علم الأمراض',
        'pathology_unit' => 'وحدة علم الأمراض',
        'add_unit' => 'وحدة علم الأمراض الجديدة',
        'edit_unit' => 'تحرير وحدة علم الأمراض',
        'pathology_unit_not_found' => 'لم يتم العثور على وحدة علم الأمراض',
        'pathology_unit_cant_deleted' => 'لا يمكن حذف وحدة علم الأمراض.',
        'pathology_parameter_not_found' => 'لم يتم العثور على معلمة علم الأمراض',
        'pathology_parameter_cant_deleted' => 'لا يمكن حذف معلمة علم الأمراض.',
        'pathology_parameter' => 'معلمة علم الأمراض',
        'pathology_parameters' => 'معلمات علم الأمراض',
        'add_parameter' => 'معلمة علم الأمراض الجديدة',
        'edit_parameter' => 'تحرير معلمة علم الأمراض',
        'parameter_name_required' => 'حقل اسم المعلمة مطلوب.',
        'patient_result_required' => 'حقل نتيجة المريض مطلوب.',
        'parameter_name' => 'اسم المعلمة',
        'patient_result' => 'نتيجة المريض',
        'select_parameter_name' => 'حدد اسم المعلمة',
        'reference_range' => 'مجموعة المرجعية',
        'select_unit' => 'حدد الوحدة',
        'print_pathology_test' => 'طباعة اختبار علم الأمراض',
        'pathology_test_report' => 'تقرير اختبار علم الأمراض',
    ],
    'subscription_plans' => [
        'payment_type' => 'اختر نوع الدفع',
        'connect_with_zoom' => 'الاتصال مع Zoom',
        'connected' => 'متصل',
        'select_ipd_patient' => 'حدد مريض IPD',
    ],

    'patient_id_card' => [
        'id' => 'بطاقة تعريف',
        'patient_id_card' => 'البطاقات الذكية للمرضى',
        'new_patient_id_card_template' => 'نموذج البطاقة الذكية للمريض الجديد',
        'edit_patient_id_card_template' => 'تحرير قالب البطاقة الذكية للمريض',
        'patient_id_card_template' => 'نموذج البطاقة الذكية للمريض',
        'color' => 'اللون',
        'patient_unique_id' => 'معرف المريض الفريد',
        'new_patient_id_card' => 'البطاقة الذكية للمريض الجديد',
        'generate_patient_id_card' => 'إنشاء البطاقة الذكية للمريض',
        'template_id' => 'اسم القالب',
        'select_template' => 'اختيار القالب',
        'select_type' => 'اختيار النوع',
        'all_patient' => 'لجميع المرضى',
        'one_patient' => 'لمريض واحد فقط',
        'remaining_patients' => 'المرضى المتبقين',
        'template_required' => 'حقل القالب مطلوب',
        'patient_required' => 'حقل المريض مطلوب',
    ],

    'register' => [
        'hello' => 'مرحبًا!',
        'regards' => 'يعتبر،',
        'whoops' => 'عفوًا!',
        'if_having_trouble_text' => "إذا كنت تواجه مشكلة في النقر على الزر \":actionText\"، قم بنسخ ولصق الرابط أدناه\n" . 'في متصفح الويب الخاص بك: [:actionURL](:actionURL)'
    ],

    'custom_field' => [
        'custom_field' => 'حقل مخصص',
        'add_custom_field' => 'إضافة حقل مخصص',
        'edit_custom_field' => 'تعديل حقل مخصص',
        'module_name' => 'اسم الوحدة',
        'field_type' => 'نوع الحقل',
        'field_name' => 'اسم الحقل',
        'grid' => 'جدول',
        'value' => 'القيمة',
        'seperated_by_comma' => 'مفصول بواسطة الفاصلة',
        'is_reqired' => 'مطلوب',
        'input' => 'إدخال',
        'textarea' => 'مساحة النص',
        'checkbox' => 'خانة اختيار',
        'number' => 'رقم',
        'dropdown' => 'قائمة منسدلة',
        'multi_select' => 'اختيار متعدد',
        'date' => 'تاريخ',
        'date_time' => 'التاريخ والوقت',
        'appointment' => 'موعد',
        'ipd_patient' => 'مريض داخلي',
        'opd_patient' => 'مريض خارجي',
        'patient' => 'مريض',
        'value_must_be_greter_then' => 'يجب أن تكون القيمة أكبر من 1',
        'select_module' => 'اختر الوحدة',
        'select_field_type' => 'اختر نوع الحقل',
        'text' => 'نص'
    ],

    'google_meet' => [
        'connect_calendar' => 'قم بتوصيل تقويم جوجل الخاص بك',
        'disconnect_google_calendar' => 'افصل تقويم جوجل الخاص بك',
        'sync_google_calendar' => 'مزامنة تقويم جوجل الخاص بك',
        'validate_json_file' => 'يرجى تعيين ملف json الخاص ببيانات اعتماد تقويم Google',
        'google_calendar_connect' => 'تم ربط تقويم Google بنجاح',
        'google_calendar_add' => 'تمت إضافة التقويم بنجاح',
        'google_calendar_update' => 'تم تحديث تقويم Google بنجاح.',
        'disconnect_or_reconnect' => 'يرجى قطع الاتصال وإعادة توصيل تقويم Google الخاص بك',
        'google_calendar_disconnect' => 'تم قطع اتصال تقويم Google',
        'select_google_calendar' => 'حدد التقويمات الخاصة بك (من تقويم Google) التي تريد إنشاء الأحداث فيها',
        'platform_type' => 'نوع المنصة',
        'google_json_file' => 'ملف جوجل جيسون',
        'upload_json_file' => 'يرجى تحميل ملف JSON.',
        'upload_file' => 'يرجى تحميل ملف.',
        'invalid_json_format' => 'هذا التنسيق غير صالح، التنسيق الصالح هو JSON.',
        'json_file_saved_successfully' => 'تم حفظ ملف Json لتقويم Google بنجاح',
    ],

    'footer' => [
        'all_rights_reserved' => 'كل الحقوق محفوظة',
    ],

    'open_ai' => [
        'provide_prompt' => 'يرجى تقديم المعلومات المادية للموجه.',
        'open_ai_key_not_found' => 'لم يتم العثور على مفتاح OpenAI API.',
        'repsonse_retrive_successfully' => 'تم استرداد الاستجابة بنجاح.',
        'open_ai_key' => 'مفتاح أوبيناي',
        'suggest_medicines' => 'أقترح الأدوية',
    ],

    'schedule_weekday' => [
        'Monday' => 'الاثنين',
        'Tuesday' => 'يوم الثلاثاء',
        'Wednesday' => 'الأربعاء',
        'Thursday' => 'يوم الخميس',
        'Friday' => 'جمعة',
        'Saturday' => 'السبت',
        'Sunday' => 'الأحد',
    ],

    'hospital_schedule_weekday' => [
        'MON' => 'العالمية',
        'TUE' => 'الثلاثاء',
        'WED' => 'الأربعاء',
        'THU' => 'الخميس',
        'FRI' => 'جمهورية مقدونيا',
        'SAT' => 'جلس',
        'SUN' => 'الشمس',
    ],
];
