<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patient_cases', function (Blueprint $table) {
            $table->increments('id');
            $table->string('case_id', 160)->unique();
            $table->unsignedInteger('patient_id');
            $table->string('phone')->nullable();
            $table->unsignedBigInteger('doctor_id');
            $table->datetime('date');
            $table->double('fee');
            $table->boolean('status')->default(0);
            $table->text('description')->nullable();
            $table->timestamps();

            $table->foreign('patient_id')->references('id')->on('patients')
                ->onDelete('cascade')
                ->onUpdate('cascade');
            $table->foreign('doctor_id')->references('id')->on('doctors')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::drop('case_managers');
    }
};
