<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Carbon;

/**
 * App\Models\IpdPrescription
 *
 * @property int $id
 * @property int $ipd_patient_department_id
 * @property string|null $header_note
 * @property string|null $footer_note
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\IpdPrescription newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\IpdPrescription newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\IpdPrescription query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\IpdPrescription whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\IpdPrescription whereFooterNote($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\IpdPrescription whereHeaderNote($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\IpdPrescription whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\IpdPrescription whereIpdPatientDepartmentId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\IpdPrescription whereUpdatedAt($value)
 *
 * @mixin \Eloquent
 *
 * @property-read Collection|IpdPrescriptionItem[] $ipdPrescriptionItems
 * @property-read int|null $ipd_prescription_items_count
 * @property-read \App\Models\IpdPatientDepartment $ipdPatient
 * @property-read \App\Models\IpdPatientDepartment $patient
 */
class IpdPrescription extends Model
{
    public $table = 'ipd_prescriptions';

    public $fillable = [
        'ipd_patient_department_id',
        'header_note',
        'footer_note',
    ];

    protected $casts = [
        'id' => 'integer',
        'ipd_patient_department_id' => 'integer',
        'header_note' => 'string',
        'footer_note' => 'string',
    ];

    public static $rules = [
        'date.*' => 'nullable',
        'charge_type_id.*' => 'nullable',
        'category_id.*' => 'required',
        'category_id.*' => 'required',
        'dose_interval.*' => 'required',
        'dosage.*' => 'required',
        'instruction.*' => 'required',
        'day.*' => 'required',
        'time.*' => 'required',
    ];

    public function ipdPrescriptionItems(): HasMany
    {
        return $this->hasMany(IpdPrescriptionItem::class, 'ipd_prescription_id');
    }

    public function patient(): BelongsTo
    {
        return $this->belongsTo(IpdPatientDepartment::class, 'ipd_patient_department_id');
    }
}
