<?php

namespace App\Models;

use Eloquent as Model;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Carbon;

/**
 * Class Insurance
 *
 * @version February 22, 2020, 9:01 am UTC
 *
 * @property int $id
 * @property string $name
 * @property float $service_tax
 * @property float|null $discount
 * @property string|null $remark
 * @property string $insurance_no
 * @property string $insurance_code
 * @property float $hospital_rate
 * @property float $total
 * @property int $status
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @method static Builder|Insurance newModelQuery()
 * @method static Builder|Insurance newQuery()
 * @method static Builder|Insurance query()
 * @method static Builder|Insurance whereCreatedAt($value)
 * @method static Builder|Insurance whereDiscount($value)
 * @method static Builder|Insurance whereHospitalRate($value)
 * @method static Builder|Insurance whereId($value)
 * @method static Builder|Insurance whereInsuranceCode($value)
 * @method static Builder|Insurance whereInsuranceNo($value)
 * @method static Builder|Insurance whereName($value)
 * @method static Builder|Insurance whereRemark($value)
 * @method static Builder|Insurance whereServiceTax($value)
 * @method static Builder|Insurance whereStatus($value)
 * @method static Builder|Insurance whereTotal($value)
 * @method static Builder|Insurance whereUpdatedAt($value)
 *
 * @mixin Model
 *
 * @property int $is_default
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\InsuranceDisease[] $insuranceDiseases
 * @property-read int|null $insurance_diseases_count
 *
 * @method static Builder|Insurance whereIsDefault($value)
 */
class Insurance extends Model
{
    public static $rules = [
        'name' => 'required|unique:insurances,name',
        'service_tax' => 'required',
        'insurance_no' => 'required',
        'insurance_code' => 'required',
        'hospital_rate' => 'required',
        'discount' => 'required|integer',
    ];

    public $table = 'insurances';

    const STATUS_ALL = 2;

    const ACTIVE = 1;

    const INACTIVE = 0;

    const STATUS_ARR = [
        self::STATUS_ALL => 'All',
        self::ACTIVE => 'Active',
        self::INACTIVE => 'Deactive',
    ];

    const FILTER_STATUS_ARRAY = [
        0 => 'All',
        1 => 'Active',
        2 => 'Deactive',
    ];

    public $fillable = [
        'name',
        'service_tax',
        'discount',
        'remark',
        'insurance_no',
        'insurance_code',
        'hospital_rate',
        'total',
        'status',
    ];

    protected $casts = [
        'id' => 'integer',
        'service_tax' => 'integer',
        'discount' => 'integer',
        'remark' => 'string',
        'insurance_no' => 'string',
        'insurance_code' => 'string',
        'hospital_rate' => 'double',
        'total' => 'double',
        'status' => 'integer',
        'name' => 'string',
    ];

    public function insuranceDiseases(): HasMany
    {
        return $this->hasMany(InsuranceDisease::class, 'insurance_id');
    }
}
