<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Models\DiagnosisCategory
 *
 * @property int $id
 * @property string $name
 * @property string $description
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 *
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DiagnosisCategory newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DiagnosisCategory newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DiagnosisCategory query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DiagnosisCategory whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DiagnosisCategory whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DiagnosisCategory whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DiagnosisCategory whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Models\DiagnosisCategory whereUpdatedAt($value)
 *
 * @mixin \Eloquent
 */
class DiagnosisCategory extends Model
{
    public $table = 'diagnosis_categories';

    public $fillable = [
        'name',
        'description',
    ];

    protected $casts = [
        'id' => 'integer',
        'name' => 'string',
        'description' => 'string',
    ];

    public static $rules = [
        'name' => 'required|unique:diagnosis_categories,name',
    ];
}
